/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefAdvertiser;

public class ReceivePack
extends BaseReceivePack {
    private PreReceiveHook preReceive = PreReceiveHook.NULL;
    private PostReceiveHook postReceive = PostReceiveHook.NULL;
    private boolean reportStatus;
    private boolean echoCommandFailures;
    private boolean usePushOptions;
    private List<String> pushOptions;

    public ReceivePack(Repository into2) {
        super(into2);
    }

    @Nullable
    public List<String> getPushOptions() {
        if (this.isAllowPushOptions() && this.usePushOptions) {
            return Collections.unmodifiableList(this.pushOptions);
        }
        return null;
    }

    public void setPushOptions(@Nullable List<String> options) {
        this.usePushOptions = options != null;
        this.pushOptions = options;
    }

    public PreReceiveHook getPreReceiveHook() {
        return this.preReceive;
    }

    public void setPreReceiveHook(PreReceiveHook h) {
        this.preReceive = h != null ? h : PreReceiveHook.NULL;
    }

    public PostReceiveHook getPostReceiveHook() {
        return this.postReceive;
    }

    public void setPostReceiveHook(PostReceiveHook h) {
        this.postReceive = h != null ? h : PostReceiveHook.NULL;
    }

    public void setEchoCommandFailures(boolean echo) {
        this.echoCommandFailures = echo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        this.init(input, output, messages);
        try {
            this.service();
        }
        finally {
            try {
                this.close();
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    protected void enableCapabilities() {
        this.reportStatus = this.isCapabilityEnabled("report-status");
        this.usePushOptions = this.isCapabilityEnabled("push-options");
        super.enableCapabilities();
    }

    @Override
    void readPostCommands(PacketLineIn in) throws IOException {
        if (this.usePushOptions) {
            String option;
            this.pushOptions = new ArrayList<String>(4);
            while ((option = in.readString()) != PacketLineIn.END) {
                this.pushOptions.add(option);
            }
        }
    }

    private void service() throws IOException {
        if (this.isBiDirectionalPipe()) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
            this.pckOut.flush();
        } else {
            this.getAdvertisedOrDefaultRefs();
        }
        if (this.hasError()) {
            return;
        }
        this.recvCommands();
        if (this.hasCommands()) {
            Throwable unpackError = null;
            if (this.needPack()) {
                try {
                    this.receivePackAndCheckConnectivity();
                }
                catch (IOException | Error | RuntimeException err) {
                    unpackError = err;
                }
            }
            if (unpackError == null) {
                boolean atomic = this.isCapabilityEnabled("atomic");
                this.setAtomic(atomic);
                this.validateCommands();
                if (atomic && this.anyRejects()) {
                    this.failPendingCommands();
                }
                this.preReceive.onPreReceive(this, this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED));
                if (atomic && this.anyRejects()) {
                    this.failPendingCommands();
                }
                this.executeCommands();
            }
            this.unlockPack();
            if (this.reportStatus) {
                if (this.echoCommandFailures && this.msgOut != null) {
                    this.sendStatusReport(false, unpackError, new BaseReceivePack.Reporter(){

                        @Override
                        void sendString(String s) throws IOException {
                            ReceivePack.this.msgOut.write(Constants.encode(s + "\n"));
                        }
                    });
                    this.msgOut.flush();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.sendStatusReport(true, unpackError, new BaseReceivePack.Reporter(){

                    @Override
                    void sendString(String s) throws IOException {
                        ReceivePack.this.pckOut.writeString(s + "\n");
                    }
                });
                this.pckOut.end();
            } else if (this.msgOut != null) {
                this.sendStatusReport(false, unpackError, new BaseReceivePack.Reporter(){

                    @Override
                    void sendString(String s) throws IOException {
                        ReceivePack.this.msgOut.write(Constants.encode(s + "\n"));
                    }
                });
            }
            if (unpackError != null) {
                try {
                    this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new UnpackException(unpackError);
            }
            this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
            this.autoGc();
        }
    }

    private void autoGc() {
        Repository repo = this.getRepository();
        if (!repo.getConfig().getBoolean("receive", "autogc", true)) {
            return;
        }
        repo.autoGC(NullProgressMonitor.INSTANCE);
    }

    @Override
    protected String getLockMessageProcessName() {
        return "jgit receive-pack";
    }
}

