/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class I18n {
    private static volatile PluralMode pluralMode = PluralMode.MODE_NOTONE;
    private static volatile String loadedCode = "en";
    private static volatile Map<String, String> strings;
    private static volatile Map<String, String[]> pstrings;
    private static Map<String, PluralMode> languages;

    private I18n() {
    }

    public static String tr(String text, Object ... objects) {
        if (text == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext(text, null), objects);
    }

    public static String trc(String context, String text) {
        if (context == null) {
            return I18n.tr(text, new Object[0]);
        }
        if (text == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext(text, context), new Object[]{null});
    }

    public static String trcLazy(String context, String text) {
        if (context == null) {
            return I18n.tr(text, new Object[0]);
        }
        if (text == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettextLazy(text, context), new Object[]{null});
    }

    public static String marktr(String text) {
        return text;
    }

    public static String marktrc(String context, String text) {
        return text;
    }

    public static String trn(String singularText, String pluralText, long n, Object ... objects) {
        return MessageFormat.format(I18n.gettextn(singularText, pluralText, null, n), objects);
    }

    public static String trnc(String context, String singularText, String pluralText, long n, Object ... objects) {
        return MessageFormat.format(I18n.gettextn(singularText, pluralText, context, n), objects);
    }

    private static String gettext(String text, String ctx, boolean lazy) {
        String[] trans;
        int i;
        if (ctx == null && text.startsWith("_:") && (i = text.indexOf(10)) >= 0) {
            ctx = text.substring(2, i - 1);
            text = text.substring(i + 1);
        }
        if (strings != null && (trans = strings.get(ctx == null ? text : "_:" + ctx + '\n' + text)) != null) {
            return trans;
        }
        if (pstrings != null) {
            i = I18n.pluralEval(1L);
            trans = pstrings.get(ctx == null ? text : "_:" + ctx + '\n' + text);
            if (trans != null && trans.length > i) {
                return trans[i];
            }
        }
        return lazy ? I18n.gettext(text, null) : text;
    }

    private static String gettext(String text, String ctx) {
        return I18n.gettext(text, ctx, false);
    }

    private static String gettextLazy(String text, String ctx) {
        return I18n.gettext(text, ctx, true);
    }

    private static String gettextn(String text, String plural, String ctx, long num) {
        int i;
        if (ctx == null && text.startsWith("_:") && (i = text.indexOf(10)) >= 0) {
            ctx = text.substring(2, i - 1);
            text = text.substring(i + 1);
        }
        if (pstrings != null) {
            i = I18n.pluralEval(num);
            String[] trans = pstrings.get(ctx == null ? text : "_:" + ctx + '\n' + text);
            if (trans != null && trans.length > i) {
                return trans[i];
            }
        }
        return num == 1L ? text : plural;
    }

    public static String escape(String msg) {
        if (msg == null) {
            return null;
        }
        return msg.replace("'", "''").replace("{", "'{'").replace("}", "'}'");
    }

    private static URL getTranslationFile(String lang) {
        return I18n.class.getResource("/data/" + lang.replace('@', '-') + ".lang");
    }

    public static Locale[] getAvailableTranslations() {
        ArrayList<Locale> v = new ArrayList<Locale>(languages.size());
        if (I18n.getTranslationFile("en") != null) {
            for (String loc : languages.keySet()) {
                if (I18n.getTranslationFile(loc) == null) continue;
                v.add(LanguageInfo.getLocale(loc));
            }
        }
        v.add(Locale.ENGLISH);
        Locale[] l = new Locale[v.size()];
        l = v.toArray(l);
        Arrays.sort(l, Comparator.comparing(Locale::toString));
        return l;
    }

    public static boolean hasCode(String code) {
        return languages.containsKey(code);
    }

    static void setupJavaLocaleProviders() {
        try {
            System.setProperty("java.locale.providers", "SPI,JRE,CLDR");
        }
        catch (SecurityException e) {
            System.err.println("Unable to set locale providers: " + e.getMessage());
        }
    }

    public static void init() {
        I18n.setupJavaLocaleProviders();
        if (!I18n.load(LanguageInfo.getJOSMLocaleCode())) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    public static void addTexts(File source) {
        if ("en".equals(loadedCode)) {
            return;
        }
        ZipEntry enfile = new ZipEntry("data/en.lang");
        ZipEntry langfile = new ZipEntry("data/" + loadedCode + ".lang");
        try (ZipFile zipFile = new ZipFile(source, StandardCharsets.UTF_8);
             InputStream orig = zipFile.getInputStream(enfile);
             InputStream trans = zipFile.getInputStream(langfile);){
            if (orig != null && trans != null) {
                I18n.load(orig, trans, true);
            }
        }
        catch (IOException | InvalidPathException e) {
            Logging.trace(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean load(String l) {
        if ("en".equals(l) || "en_US".equals(l)) {
            strings = null;
            pstrings = null;
            loadedCode = "en";
            pluralMode = PluralMode.MODE_NOTONE;
            return true;
        }
        URL en = I18n.getTranslationFile("en");
        if (en == null) {
            return false;
        }
        URL tr = I18n.getTranslationFile(l);
        if (tr == null) return false;
        if (!languages.containsKey(l)) {
            return false;
        }
        try (InputStream enStream = Utils.openStream(en);
             InputStream trStream = Utils.openStream(tr);){
            if (!I18n.load(enStream, trStream, false)) return false;
            pluralMode = languages.get(l);
            loadedCode = l;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logging.trace(e);
        }
        return false;
    }

    private static boolean load(InputStream en, InputStream tr, boolean add) {
        Map<String, String[]> p;
        Map<String, String> s;
        if (add) {
            s = strings;
            p = pstrings;
        } else {
            s = new HashMap<String, String>();
            p = new HashMap<String, String[]>();
        }
        try {
            BufferedInputStream ens = new BufferedInputStream(en);
            BufferedInputStream trs = new BufferedInputStream(tr);
            byte[] enlen = new byte[2];
            byte[] trlen = new byte[2];
            boolean multimode = false;
            byte[] str = new byte[4096];
            while (true) {
                if (multimode) {
                    int ennum = ((InputStream)ens).read();
                    int trnum = ((InputStream)trs).read();
                    if (trnum == 254) {
                        trnum = 0;
                    }
                    if (ennum == -1 && trnum != -1 || ennum != -1 && trnum == -1) {
                        return false;
                    }
                    if (ennum != -1) {
                        String[] enstrings = new String[ennum];
                        for (int i = 0; i < ennum; ++i) {
                            int rval;
                            int val = ((InputStream)ens).read(enlen);
                            if (val != 2) {
                                return false;
                            }
                            val = (enlen[0] < 0 ? 256 + enlen[0] : enlen[0]) * 256 + (enlen[1] < 0 ? 256 + enlen[1] : enlen[1]);
                            if (val > str.length) {
                                str = new byte[val];
                            }
                            if ((rval = ((InputStream)ens).read(str, 0, val)) != val) {
                                return false;
                            }
                            enstrings[i] = new String(str, 0, val, StandardCharsets.UTF_8);
                        }
                        String[] trstrings = new String[trnum];
                        for (int i = 0; i < trnum; ++i) {
                            int rval;
                            int val = ((InputStream)trs).read(trlen);
                            if (val != 2) {
                                return false;
                            }
                            val = (trlen[0] < 0 ? 256 + trlen[0] : trlen[0]) * 256 + (trlen[1] < 0 ? 256 + trlen[1] : trlen[1]);
                            if (val > str.length) {
                                str = new byte[val];
                            }
                            if ((rval = ((InputStream)trs).read(str, 0, val)) != val) {
                                return false;
                            }
                            trstrings[i] = new String(str, 0, val, StandardCharsets.UTF_8);
                        }
                        if (trnum <= 0 || p.containsKey(enstrings[0])) continue;
                        p.put(enstrings[0], trstrings);
                        continue;
                    }
                } else {
                    int trval;
                    int enval = ((InputStream)ens).read(enlen);
                    if (enval != (trval = ((InputStream)trs).read(trlen))) {
                        return false;
                    }
                    if (enval != -1) {
                        int val;
                        if (enval != 2) {
                            return false;
                        }
                        enval = (enlen[0] < 0 ? 256 + enlen[0] : enlen[0]) * 256 + (enlen[1] < 0 ? 256 + enlen[1] : enlen[1]);
                        trval = (trlen[0] < 0 ? 256 + trlen[0] : trlen[0]) * 256 + (trlen[1] < 0 ? 256 + trlen[1] : trlen[1]);
                        if (trval == 65534) {
                            trval = 0;
                        }
                        if (enval == 65535) {
                            multimode = true;
                            if (trval == 65535) continue;
                            return false;
                        }
                        if (enval > str.length) {
                            str = new byte[enval];
                        }
                        if (trval > str.length) {
                            str = new byte[trval];
                        }
                        if ((val = ((InputStream)ens).read(str, 0, enval)) != enval) {
                            return false;
                        }
                        String enstr = new String(str, 0, enval, StandardCharsets.UTF_8);
                        if (trval == 0) continue;
                        val = ((InputStream)trs).read(str, 0, trval);
                        if (val != trval) {
                            return false;
                        }
                        String trstr = new String(str, 0, trval, StandardCharsets.UTF_8);
                        if (s.containsKey(enstr)) continue;
                        s.put(enstr, trstr);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            Logging.trace(e);
            return false;
        }
        if (!s.isEmpty()) {
            strings = s;
            pstrings = p;
            return true;
        }
        return false;
    }

    public static void set(String localeName) {
        if (localeName != null) {
            Locale l = LanguageInfo.getLocale(localeName);
            if (I18n.load(LanguageInfo.getJOSMLocaleCode(l))) {
                Locale.setDefault(l);
            } else if (!"en".equals(l.getLanguage())) {
                Logging.info(I18n.tr("Unable to find translation for the locale {0}. Reverting to {1}.", LanguageInfo.getDisplayName(l), LanguageInfo.getDisplayName(Locale.getDefault())));
            } else {
                strings = null;
                pstrings = null;
            }
        }
    }

    private static int pluralEval(long n) {
        switch (pluralMode) {
            case MODE_NOTONE: {
                return n != 1L ? 1 : 0;
            }
            case MODE_NONE: {
                return 0;
            }
            case MODE_GREATERONE: {
                return n > 1L ? 1 : 0;
            }
            case MODE_CS: {
                return n == 1L ? 0 : (n >= 2L && n <= 4L ? 1 : 2);
            }
            case MODE_PL: {
                return n == 1L ? 0 : (n % 10L >= 2L && n % 10L <= 4L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            }
            case MODE_LT: {
                return n % 10L == 1L && n % 100L != 11L ? 0 : (n % 10L >= 2L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            }
            case MODE_RU: {
                return n % 10L == 1L && n % 100L != 11L ? 0 : (n % 10L >= 2L && n % 10L <= 4L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            }
            case MODE_SK: {
                return n == 1L ? 1 : (n >= 2L && n <= 4L ? 2 : 0);
            }
        }
        return 0;
    }

    public static Map<String, String> getSingularTranslations() {
        return new HashMap<String, String>(strings);
    }

    public static Map<String, String[]> getPluralTranslations() {
        return new HashMap<String, String[]>(pstrings);
    }

    static {
        languages = new HashMap<String, PluralMode>();
        languages.put("ast", PluralMode.MODE_NOTONE);
        languages.put("bg", PluralMode.MODE_NOTONE);
        languages.put("be", PluralMode.MODE_RU);
        languages.put("ca", PluralMode.MODE_NOTONE);
        languages.put("ca@valencia", PluralMode.MODE_NOTONE);
        languages.put("cs", PluralMode.MODE_CS);
        languages.put("da", PluralMode.MODE_NOTONE);
        languages.put("de", PluralMode.MODE_NOTONE);
        languages.put("el", PluralMode.MODE_NOTONE);
        languages.put("en_AU", PluralMode.MODE_NOTONE);
        languages.put("en_GB", PluralMode.MODE_NOTONE);
        languages.put("es", PluralMode.MODE_NOTONE);
        languages.put("et", PluralMode.MODE_NOTONE);
        languages.put("fi", PluralMode.MODE_NOTONE);
        languages.put("fr", PluralMode.MODE_GREATERONE);
        languages.put("gl", PluralMode.MODE_NOTONE);
        languages.put("hu", PluralMode.MODE_NOTONE);
        languages.put("id", PluralMode.MODE_NONE);
        languages.put("it", PluralMode.MODE_NOTONE);
        languages.put("ja", PluralMode.MODE_NONE);
        languages.put("ko", PluralMode.MODE_NONE);
        languages.put("km", PluralMode.MODE_NONE);
        languages.put("lt", PluralMode.MODE_LT);
        languages.put("nb", PluralMode.MODE_NOTONE);
        languages.put("nl", PluralMode.MODE_NOTONE);
        languages.put("pl", PluralMode.MODE_PL);
        languages.put("pt", PluralMode.MODE_NOTONE);
        languages.put("pt_BR", PluralMode.MODE_GREATERONE);
        languages.put("ru", PluralMode.MODE_RU);
        languages.put("sk", PluralMode.MODE_SK);
        languages.put("sv", PluralMode.MODE_NOTONE);
        languages.put("uk", PluralMode.MODE_RU);
        languages.put("vi", PluralMode.MODE_NONE);
        languages.put("zh_CN", PluralMode.MODE_NONE);
        languages.put("zh_TW", PluralMode.MODE_NONE);
    }

    private static enum PluralMode {
        MODE_NOTONE,
        MODE_NONE,
        MODE_GREATERONE,
        MODE_CS,
        MODE_PL,
        MODE_LT,
        MODE_RU,
        MODE_SK;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QuirkyPluralString {
    }
}

