/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T notNull(T object, String message) throws PreconditionViolationException {
        return Preconditions.notNull(object, () -> message);
    }

    public static <T> T notNull(T object, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(object != null, messageSupplier);
        return object;
    }

    public static <T> T[] notEmpty(T[] array, String message) throws PreconditionViolationException {
        return Preconditions.notEmpty(array, () -> message);
    }

    public static <T> T[] notEmpty(T[] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(array != null && array.length > 0, messageSupplier);
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message) throws PreconditionViolationException {
        return Preconditions.notEmpty(collection, () -> message);
    }

    public static <T extends Collection<?>> T notEmpty(T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(collection != null && !collection.isEmpty(), messageSupplier);
        return collection;
    }

    public static <T> T[] containsNoNullElements(T[] array, String message) throws PreconditionViolationException {
        return Preconditions.containsNoNullElements(array, () -> message);
    }

    public static <T> T[] containsNoNullElements(T[] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return array;
    }

    public static <T extends Collection<?>> T containsNoNullElements(T collection, String message) throws PreconditionViolationException {
        return Preconditions.containsNoNullElements(collection, () -> message);
    }

    public static <T extends Collection<?>> T containsNoNullElements(T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (collection != null) {
            collection.forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return (T)collection;
    }

    public static String notBlank(String str, String message) throws PreconditionViolationException {
        return Preconditions.notBlank(str, () -> message);
    }

    public static String notBlank(String str, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotBlank(str), messageSupplier);
        return str;
    }

    public static void condition(boolean predicate, String message) throws PreconditionViolationException {
        Preconditions.condition(predicate, () -> message);
    }

    public static void condition(boolean predicate, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
    }
}

