/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gradle.api.internal.tasks.OutputType;

public class TaskOutputPackerUtils {
    public static void ensureDirectoryForProperty(OutputType outputType, File specRoot) throws IOException {
        switch (outputType) {
            case DIRECTORY: {
                if (TaskOutputPackerUtils.makeDirectory(specRoot)) break;
                FileUtils.cleanDirectory((File)specRoot);
                break;
            }
            case FILE: {
                if (TaskOutputPackerUtils.makeDirectory(specRoot.getParentFile()) || !specRoot.exists()) break;
                FileUtils.forceDelete((File)specRoot);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static boolean makeDirectory(File output) throws IOException {
        if (output.isDirectory()) {
            return false;
        }
        if (output.isFile()) {
            FileUtils.forceDelete((File)output);
        }
        FileUtils.forceMkdir((File)output);
        return true;
    }
}

