#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.6.0
id: esqueleto-2.6.0-Ls7uAsgduz94TyQ9EQibt
key: esqueleto-2.6.0-Ls7uAsgduz94TyQ9EQibt
license: BSD-3-Clause
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
author: Felipe Lessa
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.
category: Database
abi: de00ad7062d4d8492f9382261d3a030b
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.MySQL
    Database.Esqueleto.PostgreSQL Database.Esqueleto.SQLite
hidden-modules: Database.Esqueleto.Internal.PersistentImport
                Paths_esqueleto
import-dirs: /usr/lib/ghc-8.4.3/site-local/esqueleto-2.6.0
library-dirs: /usr/lib/ghc-8.4.3/site-local/esqueleto-2.6.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/esqueleto-2.6.0
hs-libraries: HSesqueleto-2.6.0-Ls7uAsgduz94TyQ9EQibt
depends:
    base-4.11.1.0 blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG
    bytestring-0.10.8.2 conduit-1.3.0.2-CmpsFFB0CNdJAwBqx2M2rY
    monad-logger-0.3.28.5-K5TOeGuOGlKKmSG814IHT1
    persistent-2.8.2-BtcR8GaT1XW6BACZecbjsG
    resourcet-1.2.1-HwvyG5Ro3dY2I74iZB2jB
    tagged-0.8.5-8zhZJ4AR6AIK89q9NUJ4H text-1.2.3.0 time-1.8.0.2
    transformers-0.5.5.0 unliftio-0.2.7.0-AVCNN2qxwsPAnMqSXwNxxs
    unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG=c53bb3bf02513bb30eb5ce3eb528e263
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             conduit-1.3.0.2-CmpsFFB0CNdJAwBqx2M2rY=35973616512ff3a89e26461aa04e9f50
             monad-logger-0.3.28.5-K5TOeGuOGlKKmSG814IHT1=d31c74e3b25fbcd31dbb35acd135c0ab
             persistent-2.8.2-BtcR8GaT1XW6BACZecbjsG=ff0714efb0ff29925d53e016b5b31116
             resourcet-1.2.1-HwvyG5Ro3dY2I74iZB2jB=d9ddc5f723b835717074cf86137c6377
             tagged-0.8.5-8zhZJ4AR6AIK89q9NUJ4H=a77bb2a04ac30650821b1fe6972fa094
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             unliftio-0.2.7.0-AVCNN2qxwsPAnMqSXwNxxs=53bd061d72502e5ed7f709e68c6e62fb
             unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu=5b052eced98346d45f3db03378f2841d
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

