/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.SimpleEffect;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "()V", "reduceEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "effect", "reduceEffects", "", "schema", "visitAnd", "and", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "esConstant", "visitEqual", "equal", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitIs", "isOperator", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitNot", "not", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitOr", "or", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "esVariable", "resolution"})
public final class Reducer
implements ESExpressionVisitor<ESExpression> {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ESEffect> reduceEffects(@NotNull List<? extends ESEffect> schema) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(schema, "schema");
        Iterable iterable = $receiver$iv = (Iterable)schema;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ESEffect eSEffect;
            Object element$iv$iv = element$iv$iv$iv;
            ESEffect it = (ESEffect)element$iv$iv;
            if (this.reduceEffect(it) == null) continue;
            ESEffect it$iv$iv = eSEffect;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ESEffect reduceEffect(ESEffect effect) {
        ESEffect eSEffect = effect;
        if (eSEffect instanceof SimpleEffect) {
            return effect;
        }
        if (eSEffect instanceof ConditionalEffect) {
            ESExpression eSExpression = (ESExpression)((ConditionalEffect)effect).getCondition().accept(this);
            if (eSExpression == null) {
                return null;
            }
            ESExpression reducedCondition = eSExpression;
            if (reducedCondition instanceof ESConstant && Intrinsics.areEqual(reducedCondition, ESConstant.Companion.getFALSE())) {
                return null;
            }
            if (reducedCondition instanceof ESConstant && Intrinsics.areEqual(reducedCondition, ESConstant.Companion.getTRUE())) {
                return ((ConditionalEffect)effect).getSimpleEffect();
            }
            return effect;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ESExpression visitIs(@NotNull ESIs isOperator) {
        Boolean result2;
        Boolean bl;
        Intrinsics.checkParameterIsNotNull(isOperator, "isOperator");
        Object t = isOperator.getLeft().accept(this);
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.contracts.model.ESValue");
        }
        ESValue reducedArg = (ESValue)t;
        ESValue eSValue = reducedArg;
        if (eSValue instanceof ESConstant) {
            bl = TypeUtilsKt.isSubtypeOf(((ESConstant)reducedArg).getType(), isOperator.getFunctor().getType());
        } else {
            if (!(eSValue instanceof ESVariable)) throw (Throwable)new IllegalStateException("Unknown ESValue: " + reducedArg);
            KotlinType kotlinType = reducedArg.getType();
            bl = kotlinType != null && TypeUtilsKt.isSubtypeOf(kotlinType, isOperator.getFunctor().getType()) ? Boolean.valueOf(true) : null;
        }
        Boolean bl2 = result2 = bl;
        if (bl2 == null) return new ESIs(reducedArg, isOperator.getFunctor());
        bl2.booleanValue();
        return ValuesKt.lift(result2 ^ isOperator.getFunctor().isNegated());
    }

    @Override
    @NotNull
    public ESExpression visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkParameterIsNotNull(equal, "equal");
        Object t = equal.getLeft().accept(this);
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.contracts.model.ESValue");
        }
        ESValue reducedLeft = (ESValue)t;
        ESValue reducedRight = equal.getRight();
        if (reducedLeft instanceof ESConstant) {
            return ValuesKt.lift(Intrinsics.areEqual(reducedLeft, reducedRight) ^ equal.getFunctor().isNegated());
        }
        return new ESEqual(reducedLeft, reducedRight, equal.getFunctor().isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitAnd(@NotNull ESAnd and) {
        Intrinsics.checkParameterIsNotNull(and, "and");
        ESExpression eSExpression = (ESExpression)and.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)and.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return Intrinsics.areEqual(reducedLeft, ValuesKt.lift(false)) || Intrinsics.areEqual(reducedRight, ValuesKt.lift(false)) ? (ESExpression)ValuesKt.lift(false) : (Intrinsics.areEqual(reducedLeft, ValuesKt.lift(true)) ? reducedRight : (Intrinsics.areEqual(reducedRight, ValuesKt.lift(true)) ? reducedLeft : (ESExpression)new ESAnd(reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitOr(@NotNull ESOr or2) {
        Intrinsics.checkParameterIsNotNull(or2, "or");
        ESExpression eSExpression = (ESExpression)or2.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)or2.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return Intrinsics.areEqual(reducedLeft, ValuesKt.lift(true)) || Intrinsics.areEqual(reducedRight, ValuesKt.lift(true)) ? (ESExpression)ValuesKt.lift(true) : (Intrinsics.areEqual(reducedLeft, ValuesKt.lift(false)) ? reducedRight : (Intrinsics.areEqual(reducedRight, ValuesKt.lift(false)) ? reducedLeft : (ESExpression)new ESOr(reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitNot(@NotNull ESNot not) {
        ESExpression reducedArg;
        Intrinsics.checkParameterIsNotNull(not, "not");
        ESExpression eSExpression = (ESExpression)not.getArg().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression eSExpression2 = reducedArg = eSExpression;
        return Intrinsics.areEqual(eSExpression2, ESConstant.Companion.getTRUE()) ? (ESExpression)ESConstant.Companion.getFALSE() : (Intrinsics.areEqual(eSExpression2, ESConstant.Companion.getFALSE()) ? (ESExpression)ESConstant.Companion.getTRUE() : reducedArg);
    }

    @Override
    @NotNull
    public ESVariable visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkParameterIsNotNull(esVariable, "esVariable");
        return esVariable;
    }

    @Override
    @NotNull
    public ESConstant visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkParameterIsNotNull(esConstant, "esConstant");
        return esConstant;
    }
}

