/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.ArrayDeque;
import java.util.Deque;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;

public class MarkAwareNodeProcessorPlugin
extends RuntimeCCTNodeProcessor.PluginAdapter
implements MarkingEngine.StateObserver {
    volatile boolean resetFlag = false;
    private Mark parentMark = null;
    private Deque<Mark> markStack = new ArrayDeque<Mark>();
    private final TransactionalSupport transaction = new TransactionalSupport();

    @Override
    public void onBackout(MarkedCPUCCTNode markedCPUCCTNode) {
        this.markStack.pop();
        this.parentMark = this.markStack.isEmpty() ? null : this.markStack.peek();
    }

    @Override
    public void onNode(MarkedCPUCCTNode markedCPUCCTNode) {
        this.parentMark = this.markStack.isEmpty() ? null : this.markStack.peek();
        this.markStack.push(markedCPUCCTNode.getMark());
    }

    @Override
    public void onStart() {
        this.transaction.beginTrans(true);
        this.parentMark = null;
        this.resetFlag = false;
    }

    @Override
    public void onStop() {
        this.markStack.clear();
        this.parentMark = null;
        this.transaction.endTrans();
    }

    public void beginTrans(boolean bl) {
        this.transaction.beginTrans(bl);
    }

    public void endTrans() {
        if (this.resetFlag) {
            this.markStack.clear();
            this.resetFlag = false;
        }
        this.transaction.endTrans();
    }

    public synchronized void onReset() {
        this.resetFlag = true;
        this.transaction.endTrans();
    }

    @Override
    public void stateChanged(MarkingEngine markingEngine) {
        this.reset();
    }

    protected final Mark getCurrentMark() {
        return this.markStack.isEmpty() ? Mark.DEFAULT : this.markStack.peek();
    }

    protected final Mark getParentMark() {
        return this.parentMark != null ? this.parentMark : Mark.DEFAULT;
    }

    protected synchronized boolean isReset() {
        return this.resetFlag;
    }

    private void reset() {
        this.resetFlag = true;
    }
}

