/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.Interner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.StringDeduplicatingDecoder;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class ModuleMetadataStore {
    private final PathKeyFileStore metaDataStore;
    private final ModuleMetadataSerializer moduleMetadataSerializer;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final Interner<String> stringInterner;

    public ModuleMetadataStore(PathKeyFileStore metaDataStore, ModuleMetadataSerializer moduleMetadataSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, Interner<String> stringInterner) {
        this.metaDataStore = metaDataStore;
        this.moduleMetadataSerializer = moduleMetadataSerializer;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.stringInterner = stringInterner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableModuleComponentResolveMetadata getModuleDescriptor(ModuleComponentAtRepositoryKey component) {
        String filePath = this.getFilePath(component);
        LocallyAvailableResource resource = this.metaDataStore.get(filePath);
        if (resource != null) {
            MutableModuleComponentResolveMetadata mutableModuleComponentResolveMetadata;
            StringDeduplicatingDecoder decoder = new StringDeduplicatingDecoder((Decoder)new KryoBackedDecoder((InputStream)new FileInputStream(resource.getFile())), this.stringInterner);
            try {
                mutableModuleComponentResolveMetadata = this.moduleMetadataSerializer.read(decoder, this.moduleIdentifierFactory);
            }
            catch (Throwable throwable) {
                try {
                    decoder.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load module metadata from " + resource.getDisplayName(), e);
                }
            }
            decoder.close();
            return mutableModuleComponentResolveMetadata;
        }
        return null;
    }

    public LocallyAvailableResource putModuleDescriptor(ModuleComponentAtRepositoryKey component, final ModuleComponentResolveMetadata metadata) {
        String filePath = this.getFilePath(component);
        return this.metaDataStore.add((Object)filePath, (Action)new Action<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(File moduleDescriptorFile) {
                try (KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)new FileOutputStream(moduleDescriptorFile));){
                    ModuleMetadataStore.this.moduleMetadataSerializer.write((Encoder)encoder, metadata);
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        });
    }

    private String getFilePath(ModuleComponentAtRepositoryKey componentId) {
        ModuleComponentIdentifier moduleComponentIdentifier = componentId.getComponentId();
        return moduleComponentIdentifier.getGroup() + "/" + moduleComponentIdentifier.getModule() + "/" + moduleComponentIdentifier.getVersion() + "/" + componentId.getRepositoryId() + "/descriptor.bin";
    }
}

