/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.RealizableTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskReferenceResolver;
import org.gradle.api.internal.tasks.TaskStatistics;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.TaskReference;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Cast;
import org.gradle.internal.Transformers;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private static final Object[] NO_ARGS = new Object[0];
    private static final String EAGERLY_CREATE_LAZY_TASKS_PROPERTY = "org.gradle.internal.tasks.eager";
    private static final Set<String> VALID_TASK_ARGUMENTS = ImmutableSet.of((Object)"action", (Object)"dependsOn", (Object)"description", (Object)"group", (Object)"name", (Object)"overwrite", (Object[])new String[]{"type", "constructorArgs"});
    private static final Set<String> MANDATORY_TASK_ARGUMENTS = ImmutableSet.of((Object)"name", (Object)"type");
    private final ITaskFactory taskFactory;
    private final ProjectAccessListener projectAccessListener;
    private final TaskStatistics statistics;
    private final boolean eagerlyCreateLazyTasks;
    private final Map<String, TaskProvider<? extends Task>> placeholders = Maps.newLinkedHashMap();
    private MutableModelNode modelNode;

    public DefaultTaskContainer(ProjectInternal project, Instantiator instantiator, ITaskFactory taskFactory, ProjectAccessListener projectAccessListener, TaskStatistics statistics) {
        super(Task.class, instantiator, project);
        this.taskFactory = taskFactory;
        this.projectAccessListener = projectAccessListener;
        this.statistics = statistics;
        this.eagerlyCreateLazyTasks = Boolean.getBoolean(EAGERLY_CREATE_LAZY_TASKS_PROPERTY);
    }

    public Task create(Map<String, ?> options) {
        Object action;
        Object group;
        Object description;
        Map<String, ?> actualArgs;
        String name;
        Map<String, ?> factoryOptions = options;
        boolean replace = false;
        if (options.containsKey("overwrite")) {
            factoryOptions = new HashMap(options);
            Object replaceStr = factoryOptions.remove("overwrite");
            replace = "true".equals(replaceStr.toString());
        }
        if (!GUtil.isTrue((Object)(name = (actualArgs = DefaultTaskContainer.checkTaskArgsAndCreateDefaultValues(factoryOptions)).get("name").toString()))) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        Class type = (Class)Cast.uncheckedCast(actualArgs.get("type"));
        Object[] constructorArgs = DefaultTaskContainer.getConstructorArgs(actualArgs);
        TaskInternal task = (TaskInternal)this.createTask(name, type, constructorArgs);
        this.statistics.eagerTask(type);
        Object dependsOnTasks = actualArgs.get("dependsOn");
        if (dependsOnTasks != null) {
            task.dependsOn(new Object[]{dependsOnTasks});
        }
        if ((description = actualArgs.get("description")) != null) {
            task.setDescription(description.toString());
        }
        if ((group = actualArgs.get("group")) != null) {
            task.setGroup(group.toString());
        }
        if ((action = actualArgs.get("action")) instanceof Action) {
            Action taskAction = (Action)Cast.uncheckedCast(action);
            task.doFirst(taskAction);
        } else if (action != null) {
            Closure closure = (Closure)action;
            task.doFirst(closure);
        }
        return this.addTask(task, replace);
    }

    private static Object[] getConstructorArgs(Map<String, ?> args) {
        Object constructorArgs = args.get("constructorArgs");
        if (constructorArgs instanceof List) {
            List asList = (List)constructorArgs;
            return asList.toArray(new Object[asList.size()]);
        }
        if (constructorArgs instanceof Object[]) {
            return (Object[])constructorArgs;
        }
        if (constructorArgs != null) {
            throw new IllegalArgumentException(String.format("%s must be a List or Object[].  Received %s", "constructorArgs", constructorArgs.getClass()));
        }
        return NO_ARGS;
    }

    private static Map<String, ?> checkTaskArgsAndCreateDefaultValues(Map<String, ?> args) {
        DefaultTaskContainer.validateArgs(args);
        if (!args.keySet().containsAll(MANDATORY_TASK_ARGUMENTS)) {
            HashMap argsWithDefaults = Maps.newHashMap(args);
            DefaultTaskContainer.setIfNull(argsWithDefaults, "name", "");
            DefaultTaskContainer.setIfNull(argsWithDefaults, "type", DefaultTask.class);
            return argsWithDefaults;
        }
        return args;
    }

    private static void validateArgs(Map<String, ?> args) {
        if (!VALID_TASK_ARGUMENTS.containsAll(args.keySet())) {
            HashMap unknownArguments = new HashMap(args);
            unknownArguments.keySet().removeAll(VALID_TASK_ARGUMENTS);
            throw new InvalidUserDataException(String.format("Could not create task '%s': Unknown argument(s) in task definition: %s", args.get("name"), unknownArguments.keySet()));
        }
    }

    private static void setIfNull(Map<String, Object> map, String key, Object defaultValue) {
        if (map.get(key) == null) {
            map.put(key, defaultValue);
        }
    }

    private <T extends Task> T addTask(T task, boolean replaceExisting) {
        String name = task.getName();
        DefaultTaskProvider placeholderProvider = (DefaultTaskProvider)this.placeholders.remove(name);
        if (placeholderProvider != null) {
            placeholderProvider.removed = true;
            if (!replaceExisting) {
                if (this.modelNode != null) {
                    this.modelNode.removeLink(name);
                }
                this.warnAboutPlaceholderDeprecation(name);
            }
        }
        if (replaceExisting) {
            Task existing = (Task)this.findByNameWithoutRules(name);
            if (existing != null) {
                this.remove(existing);
            } else {
                DefaultTaskProvider taskProvider = (DefaultTaskProvider)this.findByNameLaterWithoutRules(name);
                if (taskProvider != null) {
                    taskProvider.removed = true;
                }
            }
        } else if (this.hasWithName(name)) {
            this.duplicateTask(name);
        }
        this.add(task);
        return task;
    }

    private <T extends Task> T duplicateTask(String task) {
        throw new InvalidUserDataException(String.format("Cannot add task '%s' as a task with that name already exists.", task));
    }

    public <U extends Task> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Task existing = this.findByName(name);
        if (existing != null) {
            return (U)((Task)Transformers.cast(type).transform((Object)existing));
        }
        return this.create(name, type);
    }

    public Task create(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.create(options).configure(configureClosure);
    }

    public <T extends Task> T create(String name, Class<T> type) {
        return this.create(name, type, NO_ARGS);
    }

    public <T extends Task> T create(String name, Class<T> type, Object ... constructorArgs) throws InvalidUserDataException {
        T task = this.createTask(name, type, constructorArgs);
        this.statistics.eagerTask(type);
        return this.addTask(task, false);
    }

    private <T extends Task> T createTask(String name, Class<T> type, Object ... constructorArgs) throws InvalidUserDataException {
        for (int i = 0; i < constructorArgs.length; ++i) {
            if (constructorArgs[i] != null) continue;
            throw new NullPointerException(String.format("Received null for %s constructor argument #%s", type.getName(), i + 1));
        }
        return this.taskFactory.create(name, type, constructorArgs);
    }

    public Task create(String name) {
        return this.create(name, DefaultTask.class);
    }

    public Task create(String name, Action<? super Task> configureAction) throws InvalidUserDataException {
        Task task = this.create(name);
        configureAction.execute((Object)task);
        return task;
    }

    public Task maybeCreate(String name) {
        Task task = this.findByName(name);
        if (task != null) {
            return task;
        }
        return this.create(name);
    }

    public Task replace(String name) {
        return this.replace(name, DefaultTask.class);
    }

    public Task create(String name, Closure configureClosure) {
        return this.create(name).configure(configureClosure);
    }

    public <T extends Task> T create(String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        T task = this.create(name, type);
        configuration.execute(task);
        return task;
    }

    public TaskProvider<Task> createLater(String name, Action<? super Task> configurationAction) {
        return (TaskProvider)Cast.uncheckedCast(this.createLater(name, DefaultTask.class, configurationAction));
    }

    public <T extends Task> TaskProvider<T> createLater(String name, Class<T> type, @Nullable Action<? super T> configurationAction) {
        if (this.hasWithName(name)) {
            this.duplicateTask(name);
        }
        TaskCreatingProvider<T> provider = new TaskCreatingProvider<T>(type, name, configurationAction);
        this.addLater(provider);
        if (this.eagerlyCreateLazyTasks) {
            provider.get();
        }
        return provider;
    }

    public <T extends Task> TaskProvider<T> createLater(String name, Class<T> type) {
        return this.createLater(name, type, null);
    }

    public <T extends Task> TaskProvider<T> createLater(String name) {
        return (TaskProvider)Cast.uncheckedCast(this.createLater(name, DefaultTask.class));
    }

    public <T extends Task> T replace(String name, Class<T> type) {
        Task task = (Task)this.taskFactory.create(name, type);
        return (T)this.addTask(task, true);
    }

    public Task findByPath(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        ProjectInternal project = this.project.findProject(Strings.isNullOrEmpty((String)projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        this.projectAccessListener.beforeRequestingTaskByPath(project);
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    public <T extends Task> TaskProvider<T> getByNameLater(Class<T> type, String name) throws InvalidUserDataException {
        Task task = (Task)this.findByNameWithoutRules(name);
        if (task == null) {
            ProviderInternal taskProvider = this.findByNameLaterWithoutRules(name);
            if (taskProvider == null) {
                throw this.createNotFoundException(name);
            }
            if (!type.isAssignableFrom(taskProvider.getType())) {
                return this.createTypeMismatchException(name, taskProvider.getType(), type);
            }
            return (TaskProvider)taskProvider;
        }
        if (!type.isAssignableFrom(task.getClass())) {
            return this.createTypeMismatchException(name, this.getDeclaredTaskType(task), type);
        }
        return new ExistingTaskProvider(this, type, name, task);
    }

    private <T extends Task> TaskProvider<T> createTypeMismatchException(String name, Class<?> actualType, Class<?> expectedType) {
        throw new IllegalArgumentException(String.format("Task with name '%s' exists in %s, but task does not have requested type. Found %s expected %s.", name, this.project, actualType.getName(), expectedType.getName()));
    }

    private Class getDeclaredTaskType(Task original) {
        return new DslObject(original).getDeclaredType();
    }

    @Override
    public Task resolveTask(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getByPath(path);
    }

    @Override
    public Task resolveTask(TaskReference reference) {
        for (TaskReferenceResolver taskResolver : this.project.getServices().getAll(TaskReferenceResolver.class)) {
            Task constructed = taskResolver.constructTask(reference, this);
            if (constructed == null) continue;
            return constructed;
        }
        throw new UnknownTaskException(String.format("Task reference '%s' could not be resolved in %s.", reference.getName(), this.project));
    }

    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    public TaskContainerInternal configure(Closure configureClosure) {
        return ConfigureUtil.configureSelf(configureClosure, this, new NamedDomainObjectContainerConfigureDelegate(configureClosure, (NamedDomainObjectContainer)this));
    }

    @Override
    public NamedEntityInstantiator<Task> getEntityInstantiator() {
        return this.taskFactory;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public SortedSet<String> getNames() {
        SortedSet<String> names = super.getNames();
        if (this.placeholders.isEmpty() && this.modelNode == null) {
            return names;
        }
        TreeSet<String> allNames = new TreeSet<String>(names);
        allNames.addAll(this.placeholders.keySet());
        if (this.modelNode != null) {
            allNames.addAll(this.modelNode.getLinkNames());
        }
        return allNames;
    }

    @Override
    public void realize() {
        this.flushPlaceholders();
        if (this.modelNode != null) {
            this.project.getModelRegistry().realizeNode(this.modelNode.getPath());
        }
    }

    @Override
    public void discoverTasks() {
        this.project.fireDeferredConfiguration();
        if (this.modelNode != null) {
            this.project.getModelRegistry().atStateOrLater(this.modelNode.getPath(), ModelNode.State.SelfClosed);
        }
    }

    private void flushPlaceholders() {
        Iterator<TaskProvider<? extends Task>> iterator = this.placeholders.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().get();
            iterator.remove();
        }
    }

    @Override
    public void prepareForExecution(Task task) {
        assert (task.getProject() == this.project);
        if (this.modelNode != null && this.modelNode.hasLink(task.getName())) {
            this.realizeTask(MODEL_PATH.child(task.getName()), ModelNode.State.GraphClosed);
        }
    }

    private boolean maybeCreateTasks(String name) {
        TaskProvider<? extends Task> placeholder = this.placeholders.remove(name);
        if (placeholder != null) {
            placeholder.get();
            return true;
        }
        if (this.modelNode != null && this.modelNode.hasLink(name)) {
            this.realizeTask(MODEL_PATH.child(name), ModelNode.State.Initialized);
            return true;
        }
        return false;
    }

    @Override
    public Task findByName(String name) {
        Task task = (Task)super.findByName(name);
        if (task != null) {
            return task;
        }
        if (!this.maybeCreateTasks(name)) {
            return null;
        }
        this.placeholders.remove(name);
        return (Task)super.findByNameWithoutRules(name);
    }

    private Task realizeTask(ModelPath taskPath, ModelNode.State minState) {
        return (Task)this.project.getModelRegistry().atStateOrLater(taskPath, ModelType.of(Task.class), minState);
    }

    @Override
    public <T extends Task> void addPlaceholderAction(String placeholderName, Class<T> taskType, Action<? super T> configure) {
        if (this.findByNameWithoutRules(placeholderName) == null) {
            TaskCreatingProvider<? super T> provider = new TaskCreatingProvider<T>(taskType, placeholderName, configure);
            this.placeholders.put(placeholderName, provider);
            this.deferredElementKnown(placeholderName, provider);
        } else {
            this.warnAboutPlaceholderDeprecation(placeholderName);
        }
    }

    private void warnAboutPlaceholderDeprecation(String placeholderName) {
        DeprecationLogger.nagUserOfDeprecated((String)("Creating a custom task named '" + placeholderName + "'"), (String)("You can configure the existing task using the '" + placeholderName + " { }' syntax or create your custom task under a different name.'"));
    }

    public <U extends Task> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Class<? extends Task>> getCreateableTypes() {
        return Collections.singleton(this.getType());
    }

    public void setModelNode(MutableModelNode modelNode) {
        this.modelNode = modelNode;
    }

    @Override
    public void whenElementKnown(Action<? super DefaultNamedDomainObjectCollection.ElementInfo<Task>> action) {
        super.whenElementKnown(action);
        for (Map.Entry<String, TaskProvider<? extends Task>> entry : this.placeholders.entrySet()) {
            this.deferredElementKnown(entry.getKey(), (Provider)entry.getValue());
        }
    }

    @Override
    public <S extends Task> TaskCollection<S> withType(Class<S> type) {
        return new RealizableTaskCollection<S>(type, super.withType(type), this.modelNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExistingTaskProvider<T extends Task>
    extends DefaultTaskProvider<T> {
        final T task;
        final /* synthetic */ DefaultTaskContainer this$0;

        public ExistingTaskProvider(Class<T> type, String name, T task) {
            this.this$0 = var1_1;
            super(type, name);
            this.task = task;
        }

        @Override
        public boolean isPresent() {
            return this.task != null;
        }

        public T getOrNull() {
            return this.task;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskCreatingProvider<T extends Task>
    extends DefaultTaskProvider<T> {
        T task;
        boolean failed;

        public TaskCreatingProvider(Class<T> type, @Nullable String name, Action<? super T> configureAction) {
            super(type, name);
            this.failed = false;
            if (configureAction != null) {
                this.configure(configureAction);
            }
            DefaultTaskContainer.this.statistics.lazyTask();
        }

        public T getOrNull() {
            if (this.task == null) {
                this.task = (Task)this.type.cast(DefaultTaskContainer.this.findByNameWithoutRules(this.name));
                if (this.task == null && !this.failed) {
                    try {
                        this.task = DefaultTaskContainer.this.createTask(this.name, this.type, NO_ARGS);
                        DefaultTaskContainer.this.statistics.lazyTaskRealized(this.type);
                        DefaultTaskContainer.this.add(this.task);
                    }
                    catch (RuntimeException ex) {
                        this.failed = true;
                        throw ex;
                    }
                }
            }
            return this.task;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DefaultTaskProvider<T extends Task>
    extends AbstractProvider<T>
    implements Named,
    TaskProvider<T> {
        final Class<T> type;
        final String name;
        boolean removed = false;

        DefaultTaskProvider(Class<T> type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public boolean isPresent() {
            return DefaultTaskContainer.this.findByNameWithoutRules(this.name) != null;
        }

        public void configure(final Action<? super T> action) {
            DefaultTaskContainer.this.configureEachLater(new Action<Task>(){
                private boolean alreadyExecuted = false;

                public void execute(Task task) {
                    if (task.getName().equals(DefaultTaskProvider.this.name) && !DefaultTaskProvider.this.removed && !this.alreadyExecuted) {
                        this.alreadyExecuted = true;
                        action.execute((Object)task);
                    }
                }
            });
        }
    }
}

