/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionSet;
import org.apache.tools.ant.taskdefs.optional.extension.ExtraAttribute;
import org.apache.tools.ant.util.FileUtils;

public final class JarLibManifestTask
extends Task {
    private static final String MANIFEST_VERSION = "1.0";
    private static final String CREATED_BY = "Created-By";
    private File destFile;
    private Extension extension;
    private final ArrayList dependencies = new ArrayList();
    private final ArrayList optionals = new ArrayList();
    private final ArrayList extraAttributes = new ArrayList();

    public void setDestfile(File destFile) {
        this.destFile = destFile;
    }

    public void addConfiguredExtension(ExtensionAdapter extensionAdapter) throws BuildException {
        if (null != this.extension) {
            throw new BuildException("Can not have multiple extensions defined in one library.");
        }
        this.extension = extensionAdapter.toExtension();
    }

    public void addConfiguredDepends(ExtensionSet extensionSet) {
        this.dependencies.add(extensionSet);
    }

    public void addConfiguredOptions(ExtensionSet extensionSet) {
        this.optionals.add(extensionSet);
    }

    public void addConfiguredAttribute(ExtraAttribute attribute) {
        this.extraAttributes.add(attribute);
    }

    public void execute() throws BuildException {
        this.validate();
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION);
        attributes.putValue(CREATED_BY, "Apache Ant " + this.getProject().getProperty("ant.version"));
        this.appendExtraAttributes(attributes);
        if (null != this.extension) {
            Extension.addExtension(this.extension, attributes);
        }
        ArrayList depends = this.toExtensions(this.dependencies);
        this.appendExtensionList(attributes, Extension.EXTENSION_LIST, "lib", depends.size());
        this.appendLibraryList(attributes, "lib", depends);
        ArrayList option = this.toExtensions(this.optionals);
        this.appendExtensionList(attributes, Extension.OPTIONAL_EXTENSION_LIST, "opt", option.size());
        this.appendLibraryList(attributes, "opt", option);
        try {
            this.log("Generating manifest " + this.destFile.getAbsoluteFile(), 2);
            this.writeManifest(manifest);
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), ioe);
        }
    }

    private void validate() throws BuildException {
        if (null == this.destFile) {
            throw new BuildException("Destfile attribute not specified.");
        }
        if (this.destFile.exists() && !this.destFile.isFile()) {
            throw new BuildException(this.destFile + " is not a file.");
        }
    }

    private void appendExtraAttributes(Attributes attributes) {
        for (ExtraAttribute attribute : this.extraAttributes) {
            attributes.putValue(attribute.getName(), attribute.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest(Manifest manifest) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.destFile);
            manifest.write(output);
            output.flush();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            FileUtils.close(output);
            throw throwable;
        }
        FileUtils.close(output);
    }

    private void appendLibraryList(Attributes attributes, String listPrefix, ArrayList extensions) throws BuildException {
        int size = extensions.size();
        for (int i = 0; i < size; ++i) {
            Extension ext = (Extension)extensions.get(i);
            String prefix = listPrefix + i + "-";
            Extension.addExtension(ext, prefix, attributes);
        }
    }

    private void appendExtensionList(Attributes attributes, Attributes.Name extensionKey, String listPrefix, int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append(listPrefix);
            sb.append(i);
            sb.append(' ');
        }
        attributes.put(extensionKey, sb.toString());
    }

    private ArrayList toExtensions(ArrayList extensionSets) throws BuildException {
        ArrayList<Extension> results = new ArrayList<Extension>();
        int size = extensionSets.size();
        for (int i = 0; i < size; ++i) {
            ExtensionSet set = (ExtensionSet)extensionSets.get(i);
            Extension[] extensions = set.toExtensions(this.getProject());
            for (int j = 0; j < extensions.length; ++j) {
                results.add(extensions[j]);
            }
        }
        return results;
    }
}

