/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.work.ConditionalExecution;
import org.gradle.internal.work.ConditionalExecutionQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConditionalExecutionQueue<T>
implements ConditionalExecutionQueue<T> {
    private final int maxWorkers;
    private final ResourceLockCoordinationService coordinationService;
    private final ManagedExecutor executor;
    private final Deque<ConditionalExecution<T>> queue = Lists.newLinkedList();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition workAvailable = this.lock.newCondition();
    private QueueState queueState = QueueState.Working;
    private int workerCount;

    public DefaultConditionalExecutionQueue(String displayName, int maxWorkers, ExecutorFactory executorFactory, ResourceLockCoordinationService coordinationService) {
        this.maxWorkers = maxWorkers;
        this.executor = executorFactory.create(displayName);
        this.coordinationService = coordinationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(ConditionalExecution<T> execution) {
        if (this.queueState == QueueState.Stopped) {
            throw new IllegalStateException("DefaultConditionalExecutionQueue cannot be reused once it has been stopped.");
        }
        this.lock.lock();
        try {
            if (this.workerCount < this.maxWorkers) {
                this.expand();
            }
            this.queue.add(execution);
            this.workAvailable.signalAll();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expand() {
        this.lock.lock();
        try {
            this.executor.submit(new ExecutionRunner());
            ++this.workerCount;
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.queueState = QueueState.Stopped;
            this.workAvailable.signalAll();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
        this.executor.stop();
    }

    private class ExecutionRunner
    implements Runnable {
        private ExecutionRunner() {
        }

        public void run() {
            ConditionalExecution operation;
            while ((operation = this.waitForNextOperation()) != null) {
                this.runBatch(operation);
            }
            this.shutDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConditionalExecution waitForNextOperation() {
            DefaultConditionalExecutionQueue.this.lock.lock();
            try {
                while (DefaultConditionalExecutionQueue.this.queueState == QueueState.Working && DefaultConditionalExecutionQueue.this.queue.isEmpty()) {
                    try {
                        DefaultConditionalExecutionQueue.this.workAvailable.await();
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedException(e);
                    }
                }
                Object var3_2 = null;
                DefaultConditionalExecutionQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                DefaultConditionalExecutionQueue.this.lock.unlock();
                throw throwable;
            }
            return this.getReadyExecution();
        }

        private void runBatch(ConditionalExecution firstOperation) {
            ConditionalExecution operation = firstOperation;
            while (operation != null) {
                this.runExecution(operation);
                operation = this.getReadyExecution();
            }
        }

        private ConditionalExecution getReadyExecution() {
            final AtomicReference execution = new AtomicReference();
            DefaultConditionalExecutionQueue.this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    if (DefaultConditionalExecutionQueue.this.queue.isEmpty()) {
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    DefaultConditionalExecutionQueue.this.lock.lock();
                    try {
                        Iterator itr = DefaultConditionalExecutionQueue.this.queue.iterator();
                        while (itr.hasNext()) {
                            ConditionalExecution next = (ConditionalExecution)itr.next();
                            if (!next.getResourceLock().tryLock()) continue;
                            execution.set(next);
                            itr.remove();
                            break;
                        }
                        Object var5_4 = null;
                        DefaultConditionalExecutionQueue.this.lock.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        DefaultConditionalExecutionQueue.this.lock.unlock();
                        throw throwable;
                    }
                    if (execution.get() == null && !DefaultConditionalExecutionQueue.this.queue.isEmpty()) {
                        return ResourceLockState.Disposition.RETRY;
                    }
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
            return (ConditionalExecution)execution.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runExecution(ConditionalExecution execution) {
            try {
                try {
                    execution.getExecution().run();
                }
                catch (Throwable t) {
                    execution.registerFailure(t);
                    Object var4_3 = null;
                    DefaultConditionalExecutionQueue.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(execution.getResourceLock()));
                    execution.complete();
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                DefaultConditionalExecutionQueue.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(execution.getResourceLock()));
                execution.complete();
                throw throwable;
            }
            DefaultConditionalExecutionQueue.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(execution.getResourceLock()));
            execution.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutDown() {
            DefaultConditionalExecutionQueue.this.lock.lock();
            try {
                DefaultConditionalExecutionQueue.this.workerCount--;
                Object var2_1 = null;
                DefaultConditionalExecutionQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DefaultConditionalExecutionQueue.this.lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QueueState {
        Working,
        Stopped;

    }
}

