/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;

public class JcaTlsDSAVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    private final DSAPublicKey pubKey;

    protected JcaTlsDSAVerifier(DSAPublicKey dSAPublicKey, JcaJceHelper jcaJceHelper) {
        if (dSAPublicKey == null) {
            throw new IllegalArgumentException("'pubKey' cannot be null");
        }
        this.pubKey = dSAPublicKey;
        this.helper = jcaJceHelper;
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != 2) {
            throw new IllegalStateException();
        }
        try {
            Signature signature = this.helper.createSignature("NoneWithDSA");
            signature.initVerify(this.pubKey);
            if (signatureAndHashAlgorithm == null) {
                signature.update(byArray, 16, 20);
            } else {
                signature.update(byArray, 0, byArray.length);
            }
            return signature.verify(digitallySigned.getSignature());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("unable to process signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

