/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;

public final class DocumentSubsetReader
extends FilterLeafReader {
    static final Map<IndexReader.CacheKey, Cache<Query, Integer>> NUM_DOCS_CACHE = new ConcurrentHashMap<IndexReader.CacheKey, Cache<Query, Integer>>();
    private final BitSet roleQueryBits;
    private final int numDocs;

    public static DocumentSubsetDirectoryReader wrap(DirectoryReader in, BitsetFilterCache bitsetFilterCache, Query roleQuery) throws IOException {
        return new DocumentSubsetDirectoryReader(in, bitsetFilterCache, roleQuery);
    }

    private static int computeNumDocs(LeafReader reader, Query roleQuery, BitSet roleQueryBits) {
        Bits liveDocs = reader.getLiveDocs();
        if (roleQueryBits == null) {
            return 0;
        }
        if (liveDocs == null) {
            return roleQueryBits.cardinality();
        }
        int numDocs = 0;
        BitSetIterator it = new BitSetIterator(roleQueryBits, 0L);
        try {
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs.get(doc)) {
                    ++numDocs;
                }
                doc = it.nextDoc();
            }
            return numDocs;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int getNumDocs(LeafReader reader, Query roleQuery, BitSet roleQueryBits) throws IOException, ExecutionException {
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalStateException("Reader " + reader + " does not support caching");
        }
        boolean[] added = new boolean[]{false};
        Cache perReaderCache = NUM_DOCS_CACHE.computeIfAbsent(cacheHelper.getKey(), key -> {
            added[0] = true;
            return CacheBuilder.builder().setMaximumWeight(1000L).weigher((k, v) -> 1L).build();
        });
        if (added[0]) {
            IndexReader.ClosedListener closedListener = NUM_DOCS_CACHE::remove;
            try {
                cacheHelper.addClosedListener(closedListener);
            }
            catch (AlreadyClosedException e) {
                closedListener.onClose(cacheHelper.getKey());
                throw e;
            }
        }
        return (Integer)perReaderCache.computeIfAbsent((Object)roleQuery, q -> DocumentSubsetReader.computeNumDocs(reader, roleQuery, roleQueryBits));
    }

    private DocumentSubsetReader(LeafReader in, BitsetFilterCache bitsetFilterCache, Query roleQuery) throws Exception {
        super(in);
        this.roleQueryBits = bitsetFilterCache.getBitSetProducer(roleQuery).getBitSet(in.getContext());
        this.numDocs = DocumentSubsetReader.getNumDocs(in, roleQuery, this.roleQueryBits);
    }

    public Bits getLiveDocs() {
        final Bits actualLiveDocs = this.in.getLiveDocs();
        if (this.roleQueryBits == null) {
            return new Bits.MatchNoBits(this.in.maxDoc());
        }
        if (actualLiveDocs == null) {
            return this.roleQueryBits;
        }
        return new Bits(){

            public boolean get(int index) {
                return DocumentSubsetReader.this.roleQueryBits.get(index) && actualLiveDocs.get(index);
            }

            public int length() {
                return DocumentSubsetReader.this.roleQueryBits.length();
            }
        };
    }

    public int numDocs() {
        return this.numDocs;
    }

    public boolean hasDeletions() {
        return true;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    BitSet getRoleQueryBits() {
        return this.roleQueryBits;
    }

    Bits getWrappedLiveDocs() {
        return this.in.getLiveDocs();
    }

    public static final class DocumentSubsetDirectoryReader
    extends FilterDirectoryReader {
        private final Query roleQuery;
        private final BitsetFilterCache bitsetFilterCache;

        DocumentSubsetDirectoryReader(DirectoryReader in, final BitsetFilterCache bitsetFilterCache, final Query roleQuery) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    try {
                        return new DocumentSubsetReader(reader, bitsetFilterCache, roleQuery);
                    }
                    catch (Exception e) {
                        throw ExceptionsHelper.convertToElastic((Exception)e);
                    }
                }
            });
            this.bitsetFilterCache = bitsetFilterCache;
            this.roleQuery = roleQuery;
            DocumentSubsetDirectoryReader.verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(in);
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DocumentSubsetDirectoryReader(in, this.bitsetFilterCache, this.roleQuery);
        }

        private static void verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(DirectoryReader reader) {
            if (reader instanceof FilterDirectoryReader) {
                FilterDirectoryReader filterDirectoryReader = (FilterDirectoryReader)reader;
                if (filterDirectoryReader instanceof DocumentSubsetDirectoryReader) {
                    throw new IllegalArgumentException(LoggerMessageFormat.format((String)"Can't wrap [{}] twice", (Object[])new Object[]{DocumentSubsetDirectoryReader.class}));
                }
                DocumentSubsetDirectoryReader.verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(filterDirectoryReader.getDelegate());
            }
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }
}

