/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.http;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.http.ExecutableHttpInput;
import org.elasticsearch.xpack.watcher.input.http.HttpInput;

public final class HttpInputFactory
extends InputFactory<HttpInput, HttpInput.Result, ExecutableHttpInput> {
    private final HttpClient httpClient;
    private final TextTemplateEngine templateEngine;
    private final HttpRequestTemplate.Parser requestTemplateParser;

    public HttpInputFactory(Settings settings, HttpClient httpClient, TextTemplateEngine templateEngine, HttpRequestTemplate.Parser requestTemplateParser) {
        super(Loggers.getLogger(ExecutableHttpInput.class, (Settings)settings, (String[])new String[0]));
        this.templateEngine = templateEngine;
        this.httpClient = httpClient;
        this.requestTemplateParser = requestTemplateParser;
    }

    @Override
    public String type() {
        return "http";
    }

    @Override
    public HttpInput parseInput(String watchId, XContentParser parser) throws IOException {
        return HttpInput.parse(watchId, parser, this.requestTemplateParser);
    }

    @Override
    public ExecutableHttpInput createExecutable(HttpInput input) {
        return new ExecutableHttpInput(input, this.inputLogger, this.httpClient, this.templateEngine);
    }
}

