/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.CastProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinitions;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.UnaryProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.Params;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class Cast
extends UnaryScalarFunction {
    private final DataType dataType;

    public Cast(Location location, Expression field, DataType dataType) {
        super(location, field);
        this.dataType = dataType;
    }

    @Override
    protected NodeInfo<Cast> info() {
        return NodeInfo.create(this, Cast::new, this.field(), this.dataType);
    }

    @Override
    protected UnaryScalarFunction replaceChild(Expression newChild) {
        return new Cast(this.location(), newChild, this.dataType);
    }

    public DataType from() {
        return this.field().dataType();
    }

    public DataType to() {
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return DataTypeConversion.convert(this.field().fold(), this.dataType);
    }

    @Override
    public boolean nullable() {
        return this.field().nullable() || DataTypes.isNull(this.from());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return DataTypeConversion.canConvert(this.from(), this.to()) ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution("Cannot cast %s to %s", this.from(), this.to());
    }

    @Override
    protected ScriptTemplate asScriptFrom(ScalarFunctionAttribute scalar) {
        return scalar.script();
    }

    @Override
    protected ScriptTemplate asScriptFrom(FieldAttribute field) {
        return new ScriptTemplate(field.name(), Params.EMPTY, field.dataType());
    }

    @Override
    protected ProcessorDefinition makeProcessorDefinition() {
        return new UnaryProcessorDefinition(this.location(), this, ProcessorDefinitions.toProcessorDefinition(this.field()), new CastProcessor(DataTypeConversion.conversionFor(this.from(), this.to())));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Cast other = (Cast)obj;
        return Objects.equals(this.dataType, other.dataType()) && Objects.equals(this.field(), other.field());
    }

    @Override
    public String toString() {
        return this.functionName() + "(" + this.field().toString() + " AS " + this.to().sqlName() + ")#" + this.id();
    }
}

