/*
 * Decompiled with CFR 0.152.
 */
package org.grails.asm;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.grails.asm.ClassReader;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import org.springframework.core.type.classreading.MetadataReader;

public class AnnotationMetadataReader
implements MetadataReader {
    private final Resource resource;
    private final ClassMetadata classMetadata;
    private final AnnotationMetadata annotationMetadata;

    public AnnotationMetadataReader(Resource resource, ClassLoader classLoader) throws IOException {
        this(resource, classLoader, false);
    }

    public AnnotationMetadataReader(Resource resource, ClassLoader classLoader, boolean readAttributeValues) throws IOException {
        ClassReader classReader;
        try (BufferedInputStream is = new BufferedInputStream(resource.getInputStream());){
            classReader = new ClassReader(is);
        }
        AnnotationMetadataReadingVisitor visitor = readAttributeValues ? new AnnotationMetadataReadingVisitor(classLoader) : new AnnotationMetadataReadingVisitor(classLoader){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                String className = Type.getType((String)desc).getClassName();
                this.annotationSet.add(className);
                return new EmptyAnnotationVisitor();
            }
        };
        classReader.accept((ClassVisitor)visitor, 2);
        this.annotationMetadata = visitor;
        this.classMetadata = visitor;
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    private static class EmptyAnnotationVisitor
    extends AnnotationVisitor {
        public EmptyAnnotationVisitor() {
            super(393216);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }
}

