#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-builder
version: 0.3.4.1
id: vector-builder-0.3.4.1-4FiQrKHaXou1LmReqDxyAD
key: vector-builder-0.3.4.1-4FiQrKHaXou1LmReqDxyAD
license: MIT
copyright: (c) 2016, Nikita Volkov
maintainer: Nikita Volkov <nikita.y.volkov@mail.ru>
author: Nikita Volkov <nikita.y.volkov@mail.ru>
homepage: https://github.com/nikita-volkov/vector-builder
synopsis: Vector builder
description:
    An API for efficient and convenient construction of vectors.
    It provides the composable `Builder` abstraction, which has instances of the `Monoid` and `Semigroup` classes.
    .
    [Usage]
    .
    First you use the `Builder` abstraction to specify the structure of the vector.
    Then you execute the builder to actually produce the vector.
    .
    [Example]
    .
    The following code shows how you can efficiently concatenate different datastructures into a single immutable vector:
    .
    >
    >import qualified Data.Vector as A
    >import qualified VectorBuilder.Builder as B
    >import qualified VectorBuilder.Vector as C
    >
    >
    >myVector :: A.Vector a -> [a] -> a -> A.Vector a
    >myVector vector list element =
    >  C.build builder
    >  where
    >    builder =
    >      B.vector vector <>
    >      foldMap B.singleton list <>
    >      B.singleton element
category: Vector
abi: 8ca9e99601ae5e23dd9f5f734395057e
exposed: True
exposed-modules:
    VectorBuilder.Builder VectorBuilder.MVector VectorBuilder.MonadPlus
    VectorBuilder.Vector
hidden-modules: VectorBuilder.Prelude VectorBuilder.Core.Update
                VectorBuilder.Core.Builder
import-dirs: /usr/lib/ghc-8.4.3/site-local/vector-builder-0.3.4.1
library-dirs: /usr/lib/ghc-8.4.3/site-local/vector-builder-0.3.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/vector-builder-0.3.4.1
hs-libraries: HSvector-builder-0.3.4.1-4FiQrKHaXou1LmReqDxyAD
depends:
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    base-prelude-1.3-6USA4MwBClb3KaEhnb0gD7 base-4.11.1.0
abi-depends: vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             base-prelude-1.3-6USA4MwBClb3KaEhnb0gD7=6440a7e70ad5450b51ffd7c9c4277ed3
             base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
haddock-interfaces: /usr/share/doc/haskell-vector-builder/html/vector-builder.haddock
haddock-html: /usr/share/doc/haskell-vector-builder/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

