/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayNoTagCorrector;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public final class ReverseWayAction
extends JosmAction {
    public ReverseWayAction() {
        super(I18n.tr("Reverse Ways", new Object[0]), "wayflip", I18n.tr("Reverse the direction of all selected ways.", new Object[0]), Shortcut.registerShortcut("tools:reverse", I18n.tr("Tool: {0}", I18n.tr("Reverse Ways", new Object[0])), 82, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/ReverseWays"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (!this.isEnabled() || ds == null) {
            return;
        }
        LinkedHashSet<Way> sel = new LinkedHashSet<Way>(ds.getSelectedWays());
        sel.removeIf(AbstractPrimitive::isIncomplete);
        if (sel.isEmpty()) {
            new Notification(I18n.tr("Please select at least one way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        LinkedList<Command> c = new LinkedList<Command>();
        for (Way w : sel) {
            ReverseWayResult revResult;
            try {
                revResult = ReverseWayAction.reverseWay(w);
            }
            catch (UserCancelException ex) {
                Logging.trace(ex);
                return;
            }
            c.addAll(revResult.getCommands());
        }
        MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Reverse Ways", new Object[0]), c));
    }

    public static ReverseWayResult reverseWay(Way w) throws UserCancelException {
        ReverseWayNoTagCorrector.checkAndConfirmReverseWay(w);
        Way wnew = new Way(w);
        List<Node> nodesCopy = wnew.getNodes();
        Collections.reverse(nodesCopy);
        wnew.setNodes(nodesCopy);
        Collection<Command> corrCmds = Collections.emptyList();
        if (Config.getPref().getBoolean("tag-correction.reverse-way", true)) {
            corrCmds = new ReverseWayTagCorrector().execute(w, wnew);
        }
        return new ReverseWayResult(wnew, corrCmds, new ChangeCommand(w, wnew));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection.stream().anyMatch(o -> o instanceof Way && !o.isIncomplete() && !o.getDataSet().isLocked()));
    }

    public static class ReverseWayResult {
        private final Way newWay;
        private final Collection<Command> tagCorrectionCommands;
        private final Command reverseCommand;

        public ReverseWayResult(Way newWay, Collection<Command> tagCorrectionCommands, Command reverseCommand) {
            this.newWay = newWay;
            this.tagCorrectionCommands = tagCorrectionCommands;
            this.reverseCommand = reverseCommand;
        }

        public Way getNewWay() {
            return this.newWay;
        }

        public Collection<Command> getCommands() {
            ArrayList<Command> c = new ArrayList<Command>();
            c.addAll(this.tagCorrectionCommands);
            c.add(this.reverseCommand);
            return c;
        }

        public Command getAsSequenceCommand() {
            return new SequenceCommand(I18n.tr("Reverse way", new Object[0]), this.getCommands());
        }

        public Command getReverseCommand() {
            return this.reverseCommand;
        }

        public Collection<Command> getTagCorrectionCommands() {
            return this.tagCorrectionCommands;
        }
    }
}

