/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang.WordUtils;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.ExtensionFactory;

public final class ZapSupportUtils {
    private static final String NEWLINE = System.lineSeparator();

    private ZapSupportUtils() {
    }

    public static String getProductName() {
        return "OWASP ZAP";
    }

    public static String getVersion() {
        return Constant.messages.getString("support.version.label") + " " + Constant.PROGRAM_VERSION;
    }

    public static String getZapHomeDirectory() {
        return Constant.messages.getString("support.home.directory.label") + " " + Constant.getZapHome();
    }

    public static String getOperatingSystem() {
        return Constant.messages.getString("support.operating.system.label") + " " + System.getProperty("os.name");
    }

    public static String getJavaVersionVendor() {
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        return Constant.messages.getString("support.java.version.label") + " " + javaVendor + " " + javaVersion;
    }

    public static String getLocaleDisplay() {
        return Constant.messages.getString("support.locale.display.label") + " " + Locale.getDefault(Locale.Category.DISPLAY);
    }

    public static String getLocaleFormat() {
        return Constant.messages.getString("support.locale.format.label") + " " + Locale.getDefault(Locale.Category.FORMAT);
    }

    public static String getLocaleSystem() {
        return Constant.messages.getString("support.locale.system.label") + " " + Constant.getSystemsLocale();
    }

    public static String getLookAndFeel() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        String strLaf = laf != null ? laf.getName() + " (" + laf.getClass().getCanonicalName() + ")" : "[null]";
        return Constant.messages.getString("support.laf.label") + " " + strLaf;
    }

    public static String getInstalledAddons() {
        AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
        ArrayList<AddOn> sortedAddOns = new ArrayList<AddOn>(addOnLoader.getAddOnCollection().getInstalledAddOns());
        Collections.sort(sortedAddOns, new Comparator<AddOn>(){

            @Override
            public int compare(AddOn addOn, AddOn otherAddOn) {
                return addOn.getId().compareTo(otherAddOn.getId());
            }
        });
        return Constant.messages.getString("support.installed.addons.label") + " " + sortedAddOns;
    }

    public static String getAll(boolean formatted) {
        StringBuilder installedAddons = new StringBuilder(200);
        if (formatted) {
            installedAddons.append("---").append(NEWLINE);
            installedAddons.append(WordUtils.wrap((String)ZapSupportUtils.getInstalledAddons(), (int)60)).append(NEWLINE);
            installedAddons.append("---").append(NEWLINE);
        } else {
            installedAddons.append(ZapSupportUtils.getInstalledAddons()).append(NEWLINE);
        }
        StringBuilder supportDetailsBuilder = new StringBuilder(300);
        supportDetailsBuilder.append(ZapSupportUtils.getProductName()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getVersion()).append(NEWLINE);
        supportDetailsBuilder.append((CharSequence)installedAddons);
        supportDetailsBuilder.append(ZapSupportUtils.getOperatingSystem()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getJavaVersionVendor()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLocaleSystem()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLocaleDisplay()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLocaleFormat()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getZapHomeDirectory()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLookAndFeel()).append(NEWLINE);
        return supportDetailsBuilder.toString();
    }
}

