/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XTopWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexContainer;
import com.sun.star.frame.TerminationVetoException;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.XActionListenerAdapter;
import com.sun.star.wizards.ui.event.XItemListenerAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;

public abstract class WizardDialog
extends UnoDialog2
implements VetoableChangeListener,
XTerminateListener {
    private static final int iButtonWidth = 50;
    private int nNewStep = 1;
    private int nOldStep = 1;
    private int nMaxStep = 1;
    private String[] sRMItemLabels;
    private Object oRoadmap;
    private XSingleServiceFactory xSSFRoadmap;
    public XIndexContainer xIndexContRoadmap;
    private final Resource oWizardResource;
    private final int hid;
    private boolean bTerminateListenermustberemoved = true;

    public WizardDialog(XMultiServiceFactory xMSF, int hid_) {
        super(xMSF);
        this.hid = hid_;
        this.oWizardResource = new Resource(xMSF, "dbw");
        this.oWizardResource.getResText(1033);
    }

    public Resource getResource() {
        return this.oWizardResource;
    }

    private void activate() {
        try {
            XTopWindow top = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)this.xWindow);
            if (top != null) {
                top.toFront();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxStep(int i) {
        this.nMaxStep = i;
    }

    public int getNewStep() {
        return this.nNewStep;
    }

    public void vetoableChange(PropertyChangeEvent arg0) {
        this.nNewStep = this.nOldStep;
    }

    public void setRoadmapInteractive(boolean _bInteractive) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Activated", _bInteractive);
    }

    public void setRoadmapComplete(boolean bComplete) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Complete", bComplete);
    }

    private boolean isRoadmapComplete() {
        try {
            return AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.oRoadmap, "Complete"));
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public void setCurrentRoadmapItemID(short ID) {
        int nCurItemID;
        if (this.oRoadmap != null && (nCurItemID = this.getCurrentRoadmapItemID()) != ID) {
            Helper.setUnoPropertyValue(this.oRoadmap, "CurrentItemID", ID);
        }
    }

    private int getCurrentRoadmapItemID() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.oRoadmap, "CurrentItemID"));
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public void addRoadmap() {
        try {
            int iDialogHeight = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HEIGHT);
            this.oRoadmap = this.insertControlModel("com.sun.star.awt.UnoControlRoadmapModel", "rdmNavi", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH}, new Object[]{iDialogHeight - 26, 0, 0, 0, (short)0, Boolean.TRUE, 85});
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oRoadmap);
            xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)"rdmNavi");
            this.xSSFRoadmap = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)this.oRoadmap);
            this.xIndexContRoadmap = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.oRoadmap);
            XControl xRoadmapControl = this.xDlgContainer.getControl("rdmNavi");
            XItemEventBroadcaster xRoadmapBroadcaster = (XItemEventBroadcaster)UnoRuntime.queryInterface(XItemEventBroadcaster.class, (Object)xRoadmapControl);
            xRoadmapBroadcaster.addItemListener((XItemListener)new XItemListenerAdapter(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        WizardDialog.this.nNewStep = itemEvent.ItemId;
                        WizardDialog.this.nOldStep = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(WizardDialog.this.xDialogModel, PropertyNames.PROPERTY_STEP));
                        if (WizardDialog.this.nNewStep != WizardDialog.this.nOldStep) {
                            WizardDialog.this.switchToStep();
                        }
                    }
                    catch (IllegalArgumentException exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            });
            Helper.setUnoPropertyValue(this.oRoadmap, "Text", this.oWizardResource.getResText(516));
        }
        catch (Exception jexception) {
            jexception.printStackTrace(System.err);
        }
    }

    public void setRMItemLabels(Resource _oResource, int StartResID) {
        this.sRMItemLabels = _oResource.getResArray(StartResID, this.nMaxStep);
    }

    public int insertRoadmapItem(int _Index, boolean _bEnabled, int _LabelID, int _CurItemID) {
        return this.insertRoadmapItem(_Index, _bEnabled, this.sRMItemLabels[_LabelID], _CurItemID);
    }

    public int insertRoadmapItem(int Index, boolean _bEnabled, String _sLabel, int _CurItemID) {
        try {
            Object oRoadmapItem = this.xSSFRoadmap.createInstance();
            Helper.setUnoPropertyValue(oRoadmapItem, PropertyNames.PROPERTY_LABEL, _sLabel);
            Helper.setUnoPropertyValue(oRoadmapItem, PropertyNames.PROPERTY_ENABLED, _bEnabled);
            Helper.setUnoPropertyValue(oRoadmapItem, "ID", _CurItemID);
            this.xIndexContRoadmap.insertByIndex(Index, oRoadmapItem);
            return Index + 1;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public int getRMItemCount() {
        return this.xIndexContRoadmap.getCount();
    }

    public XInterface getRoadmapItemByID(int _ID) {
        try {
            for (int i = 0; i < this.xIndexContRoadmap.getCount(); ++i) {
                XInterface CurRoadmapItem = (XInterface)this.xIndexContRoadmap.getByIndex(i);
                int CurID = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(CurRoadmapItem, "ID"));
                if (CurID != _ID) continue;
                return CurRoadmapItem;
            }
            return null;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public boolean switchToStep(int _nOldStep, int _nNewStep) {
        this.nOldStep = _nOldStep;
        this.nNewStep = _nNewStep;
        return this.switchToStep();
    }

    private boolean switchToStep() {
        this.leaveStep(this.nOldStep, this.nNewStep);
        if (this.nNewStep != this.nOldStep) {
            if (this.nNewStep == this.nMaxStep) {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.FALSE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.TRUE);
            } else {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.FALSE);
            }
            this.changeToStep(this.nNewStep);
            this.enterStep(this.nOldStep, this.nNewStep);
            return true;
        }
        return false;
    }

    protected abstract void leaveStep(int var1, int var2);

    protected abstract void enterStep(int var1, int var2);

    private void changeToStep(int nNewStep) {
        Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP, nNewStep);
        this.setCurrentRoadmapItemID((short)nNewStep);
        this.enableNextButton(this.getNextAvailableStep() > 0);
        this.enableBackButton(nNewStep != 1);
    }

    public void drawNaviBar() {
        try {
            short curtabindex = 30000;
            Integer IButtonWidth = 50;
            int iButtonHeight = 14;
            Integer IButtonHeight = iButtonHeight;
            Integer ICurStep = 0;
            int iDialogHeight = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HEIGHT);
            int iDialogWidth = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_WIDTH);
            int iHelpPosX = 8;
            int iBtnPosY = iDialogHeight - iButtonHeight - 6;
            int iCancelPosX = iDialogWidth - 50 - 6;
            int iFinishPosX = iCancelPosX - 6 - 50;
            int iNextPosX = iFinishPosX - 6 - 50;
            int iBackPosX = iNextPosX - 3 - 50;
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnNaviSep", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.ORIENTATION, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{1, 0, 0, iDialogHeight - 26, ICurStep, iDialogWidth});
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnRoadSep", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.ORIENTATION, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{iBtnPosY - 6, 1, 85, 0, ICurStep, 1});
            String[] propNames = new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "PushButtonType", PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH};
            Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HELPURL, HelpIds.getHelpIdString(this.hid));
            Object[] objectArray = new Object[9];
            objectArray[0] = true;
            objectArray[1] = IButtonHeight;
            objectArray[2] = this.oWizardResource.getResText(515);
            objectArray[3] = iHelpPosX;
            objectArray[4] = iBtnPosY;
            objectArray[5] = (short)3;
            objectArray[6] = ICurStep;
            short s = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray[7] = s;
            objectArray[8] = IButtonWidth;
            this.insertButton("btnWizardHelp", new XActionListenerAdapter(){

                public void actionPerformed(ActionEvent event) {
                    WizardDialog.this.callHelp();
                }
            }, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "PushButtonType", PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray);
            Object[] objectArray2 = new Object[10];
            objectArray2[0] = false;
            objectArray2[1] = IButtonHeight;
            objectArray2[2] = HelpIds.getHelpIdString(this.hid + 2);
            objectArray2[3] = this.oWizardResource.getResText(513);
            objectArray2[4] = iBackPosX;
            objectArray2[5] = iBtnPosY;
            objectArray2[6] = (short)0;
            objectArray2[7] = ICurStep;
            short s2 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray2[8] = s2;
            objectArray2[9] = IButtonWidth;
            this.insertButton("btnWizardBack", new XActionListenerAdapter(){

                public void actionPerformed(ActionEvent event) {
                    WizardDialog.this.gotoPreviousAvailableStep();
                }
            }, propNames, objectArray2);
            Object[] objectArray3 = new Object[10];
            objectArray3[0] = true;
            objectArray3[1] = IButtonHeight;
            objectArray3[2] = HelpIds.getHelpIdString(this.hid + 3);
            objectArray3[3] = this.oWizardResource.getResText(514);
            objectArray3[4] = iNextPosX;
            objectArray3[5] = iBtnPosY;
            objectArray3[6] = (short)0;
            objectArray3[7] = ICurStep;
            short s3 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray3[8] = s3;
            objectArray3[9] = IButtonWidth;
            this.insertButton("btnWizardNext", new XActionListenerAdapter(){

                public void actionPerformed(ActionEvent event) {
                    WizardDialog.this.gotoNextAvailableStep();
                }
            }, propNames, objectArray3);
            Object[] objectArray4 = new Object[10];
            objectArray4[0] = true;
            objectArray4[1] = IButtonHeight;
            objectArray4[2] = HelpIds.getHelpIdString(this.hid + 4);
            objectArray4[3] = this.oWizardResource.getResText(512);
            objectArray4[4] = iFinishPosX;
            objectArray4[5] = iBtnPosY;
            objectArray4[6] = (short)0;
            objectArray4[7] = ICurStep;
            short s4 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray4[8] = s4;
            objectArray4[9] = IButtonWidth;
            this.insertButton("btnWizardFinish", new XActionListenerAdapter(){

                public void actionPerformed(ActionEvent event) {
                    WizardDialog.this.finishWizard_1();
                }
            }, propNames, objectArray4);
            Object[] objectArray5 = new Object[10];
            objectArray5[0] = true;
            objectArray5[1] = IButtonHeight;
            objectArray5[2] = HelpIds.getHelpIdString(this.hid + 5);
            objectArray5[3] = this.oWizardResource.getResText(511);
            objectArray5[4] = iCancelPosX;
            objectArray5[5] = iBtnPosY;
            objectArray5[6] = (short)0;
            objectArray5[7] = ICurStep;
            short s5 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray5[8] = s5;
            objectArray5[9] = IButtonWidth;
            this.insertButton("btnWizardCancel", new XActionListenerAdapter(){

                public void actionPerformed(ActionEvent event) {
                    WizardDialog.this.cancelWizard_1();
                }
            }, propNames, objectArray5);
            this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
        }
        catch (Exception jexception) {
            jexception.printStackTrace(System.err);
        }
    }

    public void enableNavigationButtons(boolean _bEnableBack, boolean _bEnableNext, boolean _bEnableFinish) {
        this.enableBackButton(_bEnableBack);
        this.enableNextButton(_bEnableNext);
        this.enableFinishButton(_bEnableFinish);
    }

    private void enableBackButton(boolean enabled) {
        this.setControlProperty("btnWizardBack", PropertyNames.PROPERTY_ENABLED, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableNextButton(boolean enabled) {
        this.setControlProperty("btnWizardNext", PropertyNames.PROPERTY_ENABLED, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableFinishButton(boolean enabled) {
        this.setControlProperty("btnWizardFinish", PropertyNames.PROPERTY_ENABLED, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStepEnabled(int _nStep, boolean bEnabled) {
        XInterface xRoadmapItem = this.getRoadmapItemByID(_nStep);
        if (xRoadmapItem != null) {
            Helper.setUnoPropertyValue(xRoadmapItem, PropertyNames.PROPERTY_ENABLED, bEnabled);
        }
    }

    public void enablefromStep(int _iStep, boolean _bDoEnable) {
        if (_iStep <= this.nMaxStep) {
            for (int i = _iStep; i <= this.nMaxStep; ++i) {
                this.setStepEnabled(i, _bDoEnable);
            }
            this.enableFinishButton(_bDoEnable);
            if (!_bDoEnable) {
                this.enableNextButton(_iStep > this.getCurrentStep() + 1);
            } else {
                this.enableNextButton(this.getCurrentStep() != this.nMaxStep);
            }
        }
    }

    private boolean isStepEnabled(int _nStep) {
        try {
            XInterface xRoadmapItem = this.getRoadmapItemByID(_nStep);
            if (xRoadmapItem == null) {
                return false;
            }
            boolean bIsEnabled = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(xRoadmapItem, PropertyNames.PROPERTY_ENABLED));
            return bIsEnabled;
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private synchronized void gotoPreviousAvailableStep() {
        if (this.nNewStep > 1) {
            boolean bIsEnabled;
            this.nOldStep = this.nNewStep--;
            while (this.nNewStep > 0 && !(bIsEnabled = this.isStepEnabled(this.nNewStep))) {
                --this.nNewStep;
            }
            if (this.nNewStep == 0) {
                this.nNewStep = this.nOldStep;
            }
            this.switchToStep();
        }
    }

    private int getNextAvailableStep() {
        if (this.isRoadmapComplete()) {
            for (int i = this.nNewStep + 1; i <= this.nMaxStep; ++i) {
                if (!this.isStepEnabled(i)) continue;
                return i;
            }
        }
        return -1;
    }

    private synchronized void gotoNextAvailableStep() {
        this.nOldStep = this.nNewStep;
        this.nNewStep = this.getNextAvailableStep();
        if (this.nNewStep > -1) {
            this.switchToStep();
        }
    }

    public abstract boolean finishWizard();

    private void finishWizard_1() {
        this.enableFinishButton(false);
        boolean success = false;
        try {
            success = this.finishWizard();
        }
        finally {
            if (!success) {
                this.enableFinishButton(true);
            }
        }
        if (success) {
            this.removeTerminateListener();
        }
    }

    public int getCurrentStep() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.MSFDialogModel, PropertyNames.PROPERTY_STEP));
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public void setCurrentStep(int _nNewstep) {
        this.nNewStep = _nNewstep;
        this.changeToStep(this.nNewStep);
    }

    public void setRightPaneHeaders(Resource _oResource, int StartResID, int _nMaxStep) {
        String[] sRightPaneHeaders = _oResource.getResArray(StartResID, _nMaxStep);
        this.setRightPaneHeaders(sRightPaneHeaders);
    }

    public void setRightPaneHeaders(String[] _sRightPaneHeaders) {
        this.nMaxStep = _sRightPaneHeaders.length;
        FontDescriptor oFontDesc = new FontDescriptor();
        oFontDesc.Weight = 150.0f;
        for (int i = 0; i < _sRightPaneHeaders.length; ++i) {
            this.insertLabel("lblQueryTitle" + i, new String[]{PropertyNames.FONT_DESCRIPTOR, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_MULTILINE, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{oFontDesc, 16, _sRightPaneHeaders[i], Boolean.TRUE, 91, 8, i + 1, (short)12, 212});
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    private void callHelp() {
    }

    private void removeTerminateListener() {
        if (this.bTerminateListenermustberemoved) {
            Desktop.getDesktop(this.xMSF).removeTerminateListener((XTerminateListener)this);
            this.bTerminateListenermustberemoved = false;
        }
    }

    private void cancelWizard_1() {
        this.cancelWizard();
        this.removeTerminateListener();
    }

    public void notifyTermination(EventObject arg0) {
        this.cancelWizard_1();
    }

    public void queryTermination(EventObject arg0) throws TerminationVetoException {
        this.activate();
        throw new TerminationVetoException();
    }

    public void disposing(EventObject arg0) {
        this.cancelWizard_1();
    }
}

