/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;

public class TransportGetCategoriesAction
extends HandledTransportAction<GetCategoriesAction.Request, GetCategoriesAction.Response> {
    private final JobProvider jobProvider;
    private final Client client;
    private final JobManager jobManager;

    @Inject
    public TransportGetCategoriesAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, Client client, JobManager jobManager) {
        super(settings, "cluster:monitor/xpack/ml/job/results/categories/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetCategoriesAction.Request::new);
        this.jobProvider = jobProvider;
        this.client = client;
        this.jobManager = jobManager;
    }

    protected void doExecute(GetCategoriesAction.Request request, ActionListener<GetCategoriesAction.Response> listener) {
        this.jobManager.getJobOrThrowIfUnknown(request.getJobId());
        Integer from = request.getPageParams() != null ? Integer.valueOf(request.getPageParams().getFrom()) : null;
        Integer size = request.getPageParams() != null ? Integer.valueOf(request.getPageParams().getSize()) : null;
        this.jobProvider.categoryDefinitions(request.getJobId(), request.getCategoryId(), from, size, r -> listener.onResponse((Object)new GetCategoriesAction.Response(r)), arg_0 -> listener.onFailure(arg_0), this.client);
    }
}

