/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.AuthorizationService;

public class TransportHasPrivilegesAction
extends HandledTransportAction<HasPrivilegesRequest, HasPrivilegesResponse> {
    private final AuthorizationService authorizationService;

    @Inject
    public TransportHasPrivilegesAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AuthorizationService authorizationService) {
        super(settings, "cluster:admin/xpack/security/user/has_privileges", threadPool, transportService, actionFilters, indexNameExpressionResolver, HasPrivilegesRequest::new);
        this.authorizationService = authorizationService;
    }

    protected void doExecute(HasPrivilegesRequest request, ActionListener<HasPrivilegesResponse> listener) {
        String username = request.username();
        User user = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext()).getUser();
        if (!user.principal().equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only check the privileges of their own account"));
            return;
        }
        this.authorizationService.roles(user, (ActionListener<Role>)ActionListener.wrap(role -> this.checkPrivileges(request, (Role)role, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkPrivileges(HasPrivilegesRequest request, Role userRole, ActionListener<HasPrivilegesResponse> listener) {
        this.logger.debug(() -> new ParameterizedMessage("Check whether role [{}] has privileges cluster=[{}] index=[{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), Strings.arrayToCommaDelimitedString((Object[])request.clusterPrivileges()), Strings.arrayToCommaDelimitedString((Object[])request.indexPrivileges())}));
        HashMap<String, Boolean> cluster = new HashMap<String, Boolean>();
        for (String checkAction : request.clusterPrivileges()) {
            ClusterPrivilege checkPrivilege = ClusterPrivilege.get(Collections.singleton(checkAction));
            ClusterPrivilege rolePrivilege = userRole.cluster().privilege();
            cluster.put(checkAction, TransportHasPrivilegesAction.testPrivilege((Privilege)checkPrivilege, rolePrivilege.getAutomaton()));
        }
        boolean allMatch = cluster.values().stream().allMatch(Boolean::booleanValue);
        HashMap<IndicesPermission.Group, Automaton> predicateCache = new HashMap<IndicesPermission.Group, Automaton>();
        LinkedHashMap<String, HasPrivilegesResponse.IndexPrivileges> indices = new LinkedHashMap<String, HasPrivilegesResponse.IndexPrivileges>();
        for (RoleDescriptor.IndicesPrivileges check : request.indexPrivileges()) {
            for (String index : check.getIndices()) {
                HashMap<String, Boolean> privileges = new HashMap<String, Boolean>();
                HasPrivilegesResponse.IndexPrivileges existing = (HasPrivilegesResponse.IndexPrivileges)indices.get(index);
                if (existing != null) {
                    privileges.putAll(existing.getPrivileges());
                }
                for (String privilege : check.getPrivileges()) {
                    if (this.testIndexMatch(index, privilege, userRole, predicateCache)) {
                        this.logger.debug(() -> new ParameterizedMessage("Role [{}] has [{}] on [{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), privilege, index}));
                        privileges.put(privilege, true);
                        continue;
                    }
                    this.logger.debug(() -> new ParameterizedMessage("Role [{}] does not have [{}] on [{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), privilege, index}));
                    privileges.put(privilege, false);
                    allMatch = false;
                }
                indices.put(index, new HasPrivilegesResponse.IndexPrivileges(index, privileges));
            }
        }
        listener.onResponse((Object)new HasPrivilegesResponse(allMatch, cluster, indices.values()));
    }

    private boolean testIndexMatch(String checkIndex, String checkPrivilegeName, Role userRole, Map<IndicesPermission.Group, Automaton> predicateCache) {
        IndexPrivilege checkPrivilege = IndexPrivilege.get(Collections.singleton(checkPrivilegeName));
        Automaton checkIndexAutomaton = Automatons.patterns((String[])new String[]{checkIndex});
        ArrayList<Automaton> privilegeAutomatons = new ArrayList<Automaton>();
        for (IndicesPermission.Group group : userRole.indices().groups()) {
            Automaton groupIndexAutomaton = predicateCache.computeIfAbsent(group, g -> Automatons.patterns((String[])g.indices()));
            if (!TransportHasPrivilegesAction.testIndex(checkIndexAutomaton, groupIndexAutomaton)) continue;
            IndexPrivilege rolePrivilege = group.privilege();
            if (rolePrivilege.name().contains(checkPrivilegeName)) {
                return true;
            }
            privilegeAutomatons.add(rolePrivilege.getAutomaton());
        }
        return TransportHasPrivilegesAction.testPrivilege((Privilege)checkPrivilege, Automatons.unionAndMinimize(privilegeAutomatons));
    }

    private static boolean testIndex(Automaton checkIndex, Automaton roleIndex) {
        return Operations.subsetOf((Automaton)checkIndex, (Automaton)roleIndex);
    }

    private static boolean testPrivilege(Privilege checkPrivilege, Automaton roleAutomaton) {
        return Operations.subsetOf((Automaton)checkPrivilege.getAutomaton(), (Automaton)roleAutomaton);
    }
}

