/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.sql.expression.function.Score;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Kurtosis;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRank;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Skewness;
import org.elasticsearch.xpack.sql.expression.function.aggregate.StddevPop;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.aggregate.SumOfSquares;
import org.elasticsearch.xpack.sql.expression.function.aggregate.VarPop;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Mod;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfMonth;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfWeek;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DayOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.HourOfDay;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MinuteOfDay;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MinuteOfHour;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.MonthOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.SecondOfMinute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.WeekOfYear;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.Year;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ACos;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ASin;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ATan;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.ATan2;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Abs;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cbrt;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Ceil;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cos;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cosh;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Cot;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Degrees;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.E;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Exp;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Expm1;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Log;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Log10;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Pi;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Power;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Radians;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Random;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Round;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sign;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sin;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sinh;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Sqrt;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.Tan;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.util.StringUtils;

public class FunctionRegistry {
    private static final List<FunctionDefinition> DEFAULT_FUNCTIONS = Collections.unmodifiableList(Arrays.asList(FunctionRegistry.def(Avg.class, Avg::new, new String[0]), FunctionRegistry.def(Count.class, Count::new, new String[0]), FunctionRegistry.def(Max.class, Max::new, new String[0]), FunctionRegistry.def(Min.class, Min::new, new String[0]), FunctionRegistry.def(Sum.class, Sum::new, new String[0]), FunctionRegistry.def(StddevPop.class, StddevPop::new, new String[0]), FunctionRegistry.def(VarPop.class, VarPop::new, new String[0]), FunctionRegistry.def(Percentile.class, Percentile::new, new String[0]), FunctionRegistry.def(PercentileRank.class, PercentileRank::new, new String[0]), FunctionRegistry.def(SumOfSquares.class, SumOfSquares::new, new String[0]), FunctionRegistry.def(Skewness.class, Skewness::new, new String[0]), FunctionRegistry.def(Kurtosis.class, Kurtosis::new, new String[0]), FunctionRegistry.def(DayOfMonth.class, DayOfMonth::new, "DAY", "DOM"), FunctionRegistry.def(DayOfWeek.class, DayOfWeek::new, "DOW"), FunctionRegistry.def(DayOfYear.class, DayOfYear::new, "DOY"), FunctionRegistry.def(HourOfDay.class, HourOfDay::new, "HOUR"), FunctionRegistry.def(MinuteOfDay.class, MinuteOfDay::new, new String[0]), FunctionRegistry.def(MinuteOfHour.class, MinuteOfHour::new, "MINUTE"), FunctionRegistry.def(SecondOfMinute.class, SecondOfMinute::new, "SECOND"), FunctionRegistry.def(MonthOfYear.class, MonthOfYear::new, "MONTH"), FunctionRegistry.def(Year.class, Year::new, new String[0]), FunctionRegistry.def(WeekOfYear.class, WeekOfYear::new, "WEEK"), FunctionRegistry.def(Abs.class, Abs::new, new String[0]), FunctionRegistry.def(ACos.class, ACos::new, new String[0]), FunctionRegistry.def(ASin.class, ASin::new, new String[0]), FunctionRegistry.def(ATan.class, ATan::new, new String[0]), FunctionRegistry.def(ATan2.class, ATan2::new, new String[0]), FunctionRegistry.def(Cbrt.class, Cbrt::new, new String[0]), FunctionRegistry.def(Ceil.class, Ceil::new, "CEILING"), FunctionRegistry.def(Cos.class, Cos::new, new String[0]), FunctionRegistry.def(Cosh.class, Cosh::new, new String[0]), FunctionRegistry.def(Cot.class, Cot::new, new String[0]), FunctionRegistry.def(Degrees.class, Degrees::new, new String[0]), FunctionRegistry.def(E.class, E::new, new String[0]), FunctionRegistry.def(Exp.class, Exp::new, new String[0]), FunctionRegistry.def(Expm1.class, Expm1::new, new String[0]), FunctionRegistry.def(Floor.class, Floor::new, new String[0]), FunctionRegistry.def(Log.class, Log::new, new String[0]), FunctionRegistry.def(Log10.class, Log10::new, new String[0]), FunctionRegistry.def(Mod.class, Mod::new, new String[0]), FunctionRegistry.def(Pi.class, Pi::new, new String[0]), FunctionRegistry.def(Power.class, Power::new, new String[0]), FunctionRegistry.def(Radians.class, Radians::new, new String[0]), FunctionRegistry.def(Random.class, Random::new, "RAND"), FunctionRegistry.def(Round.class, Round::new, new String[0]), FunctionRegistry.def(Sign.class, Sign::new, "SIGNUM"), FunctionRegistry.def(Sin.class, Sin::new, new String[0]), FunctionRegistry.def(Sinh.class, Sinh::new, new String[0]), FunctionRegistry.def(Sqrt.class, Sqrt::new, new String[0]), FunctionRegistry.def(Tan.class, Tan::new, new String[0]), FunctionRegistry.def(Score.class, Score::new, new String[0])));
    private final Map<String, FunctionDefinition> defs = new LinkedHashMap<String, FunctionDefinition>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public FunctionRegistry() {
        this(DEFAULT_FUNCTIONS);
    }

    FunctionRegistry(List<FunctionDefinition> functions) {
        for (FunctionDefinition f : functions) {
            this.defs.put(f.name(), f);
            for (String alias : f.aliases()) {
                String old = this.aliases.put(alias, f.name());
                if (old != null) {
                    throw new IllegalArgumentException("alias [" + alias + "] is used by [" + old + "] and [" + f.name() + "]");
                }
                this.defs.put(alias, f);
            }
        }
    }

    public FunctionDefinition resolveFunction(String name) {
        FunctionDefinition def = this.defs.get(FunctionRegistry.normalize(name));
        if (def == null) {
            throw new SqlIllegalArgumentException("Cannot find function {}; this should have been caught during analysis", name);
        }
        return def;
    }

    public String concreteFunctionName(String alias) {
        String normalized = FunctionRegistry.normalize(alias);
        return this.aliases.getOrDefault(normalized, normalized);
    }

    public boolean functionExists(String name) {
        return this.defs.containsKey(FunctionRegistry.normalize(name));
    }

    public Collection<FunctionDefinition> listFunctions() {
        return this.defs.entrySet().stream().map(e -> new FunctionDefinition((String)e.getKey(), Collections.emptyList(), ((FunctionDefinition)e.getValue()).clazz(), ((FunctionDefinition)e.getValue()).datetime(), ((FunctionDefinition)e.getValue()).builder())).collect(Collectors.toList());
    }

    public Collection<FunctionDefinition> listFunctions(String pattern) {
        Pattern p = Strings.hasText((String)pattern) ? Pattern.compile(FunctionRegistry.normalize(pattern)) : null;
        return this.defs.entrySet().stream().filter(e -> p == null || p.matcher((CharSequence)e.getKey()).matches()).map(e -> new FunctionDefinition((String)e.getKey(), Collections.emptyList(), ((FunctionDefinition)e.getValue()).clazz(), ((FunctionDefinition)e.getValue()).datetime(), ((FunctionDefinition)e.getValue()).builder())).collect(Collectors.toList());
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, java.util.function.Function<Location, T> ctorRef, String ... aliases) {
        FunctionBuilder builder = (location, children, distinct, tz) -> {
            if (!children.isEmpty()) {
                throw new IllegalArgumentException("expects no arguments");
            }
            if (distinct) {
                throw new IllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.apply(location);
        };
        return FunctionRegistry.def(function, builder, false, aliases);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, BiFunction<Location, Expression, T> ctorRef, String ... aliases) {
        FunctionBuilder builder = (location, children, distinct, tz) -> {
            if (children.size() != 1) {
                throw new IllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new IllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.apply(location, (Expression)children.get(0));
        };
        return FunctionRegistry.def(function, builder, false, aliases);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, DistinctAwareUnaryFunctionBuilder<T> ctorRef, String ... aliases) {
        FunctionBuilder builder = (location, children, distinct, tz) -> {
            if (children.size() != 1) {
                throw new IllegalArgumentException("expects exactly one argument");
            }
            return (Function)ctorRef.build(location, (Expression)children.get(0), distinct);
        };
        return FunctionRegistry.def(function, builder, false, aliases);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, DatetimeUnaryFunctionBuilder<T> ctorRef, String ... aliases) {
        FunctionBuilder builder = (location, children, distinct, tz) -> {
            if (children.size() != 1) {
                throw new IllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new IllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(location, (Expression)children.get(0), tz);
        };
        return FunctionRegistry.def(function, builder, true, aliases);
    }

    static <T extends Function> FunctionDefinition def(Class<T> function, BinaryFunctionBuilder<T> ctorRef, String ... aliases) {
        FunctionBuilder builder = (location, children, distinct, tz) -> {
            if (children.size() != 2) {
                throw new IllegalArgumentException("expects exactly two arguments");
            }
            if (distinct) {
                throw new IllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(location, (Expression)children.get(0), (Expression)children.get(1));
        };
        return FunctionRegistry.def(function, builder, false, aliases);
    }

    private static FunctionDefinition def(Class<? extends Function> function, FunctionBuilder builder, boolean datetime, String ... aliases) {
        String primaryName = FunctionRegistry.normalize(function.getSimpleName());
        FunctionDefinition.Builder realBuilder = (uf, distinct, tz) -> {
            try {
                return builder.build(uf.location(), uf.children(), distinct, tz);
            }
            catch (IllegalArgumentException e) {
                throw new ParsingException("error building [" + primaryName + "]: " + e.getMessage(), e, uf.location().getLineNumber(), uf.location().getColumnNumber());
            }
        };
        return new FunctionDefinition(primaryName, Collections.unmodifiableList(Arrays.asList(aliases)), function, datetime, realBuilder);
    }

    private static String normalize(String name) {
        return StringUtils.camelCaseToUnderscore(name);
    }

    private static interface FunctionBuilder {
        public Function build(Location var1, List<Expression> var2, boolean var3, TimeZone var4);
    }

    static interface BinaryFunctionBuilder<T> {
        public T build(Location var1, Expression var2, Expression var3);
    }

    static interface DatetimeUnaryFunctionBuilder<T> {
        public T build(Location var1, Expression var2, TimeZone var3);
    }

    static interface DistinctAwareUnaryFunctionBuilder<T> {
        public T build(Location var1, Expression var2, boolean var3);
    }
}

