/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.tree.Location;

public class BoolQuery
extends Query {
    private final boolean isAnd;
    private final Query left;
    private final Query right;

    public BoolQuery(Location location, boolean isAnd, Query left, Query right) {
        super(location);
        if (left == null) {
            throw new IllegalArgumentException("left is required");
        }
        if (right == null) {
            throw new IllegalArgumentException("right is required");
        }
        this.isAnd = isAnd;
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean containsNestedField(String path, String field) {
        return this.left.containsNestedField(path, field) || this.right.containsNestedField(path, field);
    }

    @Override
    public Query addNestedField(String path, String field, boolean hasDocValues) {
        Query rewrittenLeft = this.left.addNestedField(path, field, hasDocValues);
        Query rewrittenRight = this.right.addNestedField(path, field, hasDocValues);
        if (rewrittenLeft == this.left && rewrittenRight == this.right) {
            return this;
        }
        return new BoolQuery(this.location(), this.isAnd, rewrittenLeft, rewrittenRight);
    }

    @Override
    public void enrichNestedSort(NestedSortBuilder sort) {
        this.left.enrichNestedSort(sort);
        this.right.enrichNestedSort(sort);
    }

    @Override
    public QueryBuilder asBuilder() {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (this.isAnd) {
            boolQuery.filter(this.left.asBuilder());
            boolQuery.filter(this.right.asBuilder());
        } else {
            boolQuery.should(this.left.asBuilder());
            boolQuery.should(this.right.asBuilder());
        }
        return boolQuery;
    }

    boolean isAnd() {
        return this.isAnd;
    }

    Query left() {
        return this.left;
    }

    Query right() {
        return this.right;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isAnd, this.left, this.right);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BoolQuery other = (BoolQuery)obj;
        return this.isAnd == other.isAnd && this.left.equals(other.left) && this.right.equals(other.right);
    }

    @Override
    protected String innerToString() {
        return this.left + (this.isAnd ? " AND " : " OR ") + this.right;
    }
}

