/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class TemplateHttpResource
extends PublishableHttpResource {
    private static final Logger logger = Loggers.getLogger(TemplateHttpResource.class);
    private final String templateName;
    private final Supplier<String> template;

    public TemplateHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, String templateName, Supplier<String> template) {
        super(resourceOwnerName, masterTimeout, PublishableHttpResource.RESOURCE_VERSION_PARAMETERS);
        this.templateName = Objects.requireNonNull(templateName);
        this.template = Objects.requireNonNull(template);
    }

    @Override
    protected PublishableHttpResource.CheckResponse doCheck(RestClient client) {
        return this.versionCheckForResource(client, logger, "/_template", this.templateName, "monitoring template", this.resourceOwnerName, "monitoring cluster", XContentType.JSON.xContent(), MonitoringTemplateUtils.LAST_UPDATED_VERSION);
    }

    @Override
    protected boolean doPublish(RestClient client) {
        return this.putResource(client, logger, "/_template", this.templateName, this::templateToHttpEntity, "monitoring template", this.resourceOwnerName, "monitoring cluster");
    }

    HttpEntity templateToHttpEntity() {
        return new StringEntity(this.template.get(), ContentType.APPLICATION_JSON);
    }
}

