/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.values;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;
import org.elasticsearch.script.SearchScript;

public class ScriptBytesValues
extends SortingBinaryDocValues
implements ScorerAware {
    private final SearchScript script;

    public ScriptBytesValues(SearchScript script) {
        this.script = script;
    }

    private void set(int i, Object o) {
        if (o == null) {
            this.values[i].clear();
        } else {
            CollectionUtils.ensureNoSelfReferences(o);
            this.values[i].copyChars(o.toString());
        }
    }

    @Override
    public boolean advanceExact(int doc) throws IOException {
        this.script.setDocument(doc);
        Object value = this.script.run();
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            this.count = Array.getLength(value);
            if (this.count == 0) {
                return false;
            }
            this.grow();
            for (int i = 0; i < this.count; ++i) {
                this.set(i, Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            this.count = coll.size();
            if (this.count == 0) {
                return false;
            }
            this.grow();
            int i = 0;
            for (Object v : coll) {
                this.set(i++, v);
            }
        } else {
            this.count = 1;
            this.set(0, value);
        }
        this.sort();
        return true;
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }
}

