/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.plugin.SqlTypedParamValue;

public class SqlQueryRequest
extends AbstractSqlQueryRequest
implements ToXContentObject {
    private static final ObjectParser<SqlQueryRequest, Void> PARSER = SqlQueryRequest.objectParser(SqlQueryRequest::new);
    public static final ParseField CURSOR = new ParseField("cursor", new String[0]);
    public static final ParseField FILTER = new ParseField("filter", new String[0]);
    private String cursor = "";

    public SqlQueryRequest() {
    }

    public SqlQueryRequest(AbstractSqlRequest.Mode mode, String query, List<SqlTypedParamValue> params, QueryBuilder filter, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, String cursor) {
        super(mode, query, params, filter, timeZone, fetchSize, requestTimeout, pageTimeout);
        this.cursor = cursor;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText(this.query()) && !Strings.hasText(this.cursor)) {
            validationException = ValidateActions.addValidationError("one of [query] or [cursor] is required", validationException);
        }
        return validationException;
    }

    public String cursor() {
        return this.cursor;
    }

    public SqlQueryRequest cursor(String cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("cursor may not be null.");
        }
        this.cursor = cursor;
        return this;
    }

    public SqlQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cursor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.cursor, ((SqlQueryRequest)obj).cursor);
    }

    @Override
    public String getDescription() {
        return "SQL [" + this.query() + "][" + this.filter() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.toXContent(builder, params);
        if (this.cursor != null) {
            builder.field("cursor", this.cursor);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isFragment() {
        return false;
    }

    public static SqlQueryRequest fromXContent(XContentParser parser, AbstractSqlRequest.Mode mode) {
        SqlQueryRequest request = PARSER.apply(parser, null);
        request.mode(mode);
        return request;
    }

    static {
        PARSER.declareString(SqlQueryRequest::cursor, CURSOR);
        PARSER.declareObject(AbstractSqlQueryRequest::filter, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder(p), FILTER);
    }
}

