/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;

public class NodePersistentTasksExecutor {
    private final ThreadPool threadPool;

    public NodePersistentTasksExecutor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void executeTask(final Params params, final @Nullable Task.Status status, final AllocatedPersistentTask task, final PersistentTasksExecutor<Params> executor) {
        this.threadPool.executor(executor.getExecutor()).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                task.markAsFailed(e);
            }

            @Override
            protected void doRun() throws Exception {
                try {
                    executor.nodeOperation(task, params, status);
                }
                catch (Exception ex) {
                    task.markAsFailed(ex);
                }
            }
        });
    }
}

