/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.search.sort.SortBuilder;

public class NestedSortBuilder
implements Writeable,
ToXContentObject {
    public static final ParseField NESTED_FIELD = new ParseField("nested", new String[0]);
    public static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    public static final ParseField FILTER_FIELD = new ParseField("filter", new String[0]);
    private final String path;
    private QueryBuilder filter;
    private NestedSortBuilder nestedSort;

    public NestedSortBuilder(String path) {
        this.path = path;
    }

    public NestedSortBuilder(StreamInput in) throws IOException {
        this.path = in.readOptionalString();
        this.filter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nestedSort = in.readOptionalWriteable(NestedSortBuilder::new);
    }

    public String getPath() {
        return this.path;
    }

    public QueryBuilder getFilter() {
        return this.filter;
    }

    public NestedSortBuilder setFilter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public NestedSortBuilder setNestedSort(NestedSortBuilder nestedSortBuilder) {
        this.nestedSort = nestedSortBuilder;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.path);
        out.writeOptionalNamedWriteable(this.filter);
        out.writeOptionalWriteable(this.nestedSort);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.path != null) {
            builder.field(PATH_FIELD.getPreferredName(), this.path);
        }
        if (this.filter != null) {
            builder.field(FILTER_FIELD.getPreferredName(), (ToXContent)this.filter);
        }
        if (this.nestedSort != null) {
            builder.field(NESTED_FIELD.getPreferredName(), (ToXContent)this.nestedSort);
        }
        builder.endObject();
        return builder;
    }

    public static NestedSortBuilder fromXContent(XContentParser parser) throws IOException {
        String path = null;
        QueryBuilder filter = null;
        NestedSortBuilder nestedSort = null;
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentName = parser.currentName();
                    parser.nextToken();
                    if (currentName.equals(PATH_FIELD.getPreferredName())) {
                        path = parser.text();
                        continue;
                    }
                    if (currentName.equals(FILTER_FIELD.getPreferredName())) {
                        filter = SortBuilder.parseNestedFilter(parser);
                        continue;
                    }
                    if (currentName.equals(NESTED_FIELD.getPreferredName())) {
                        nestedSort = NestedSortBuilder.fromXContent(parser);
                        continue;
                    }
                    throw new IllegalArgumentException("malformed nested sort format, unknown field name [" + currentName + "]");
                }
                throw new IllegalArgumentException("malformed nested sort format, only field names are allowed");
            }
        } else {
            throw new IllegalArgumentException("malformed nested sort format, must start with an object");
        }
        return new NestedSortBuilder(path).setFilter(filter).setNestedSort(nestedSort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NestedSortBuilder that = (NestedSortBuilder)obj;
        return Objects.equals(this.path, that.path) && Objects.equals(this.filter, that.filter) && Objects.equals(this.nestedSort, that.nestedSort);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.filter, this.nestedSort);
    }

    public NestedSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.filter == null && this.nestedSort == null) {
            return this;
        }
        QueryBuilder rewriteFilter = this.filter;
        NestedSortBuilder rewriteNested = this.nestedSort;
        if (this.filter != null) {
            rewriteFilter = this.filter.rewrite(ctx);
        }
        if (this.nestedSort != null) {
            rewriteNested = this.nestedSort.rewrite(ctx);
        }
        if (rewriteFilter != this.filter || rewriteNested != this.nestedSort) {
            return new NestedSortBuilder(this.path).setFilter(rewriteFilter).setNestedSort(rewriteNested);
        }
        return this;
    }
}

