/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class RandomValuePropertySource
extends PropertySource<Random> {
    public static final String RANDOM_PROPERTY_SOURCE_NAME = "random";
    private static final String PREFIX = "random.";
    private static final Log logger = LogFactory.getLog(RandomValuePropertySource.class);

    public RandomValuePropertySource(String name) {
        super(name, (Object)new Random());
    }

    public RandomValuePropertySource() {
        this(RANDOM_PROPERTY_SOURCE_NAME);
    }

    public Object getProperty(String name) {
        if (!name.startsWith(PREFIX)) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Generating random property for '" + name + "'"));
        }
        return this.getRandomValue(name.substring(PREFIX.length()));
    }

    private Object getRandomValue(String type) {
        if (type.equals("int")) {
            return ((Random)this.getSource()).nextInt();
        }
        if (type.equals("long")) {
            return ((Random)this.getSource()).nextLong();
        }
        String range = this.getRange(type, "int");
        if (range != null) {
            return this.getNextIntInRange(range);
        }
        range = this.getRange(type, "long");
        if (range != null) {
            return this.getNextLongInRange(range);
        }
        if (type.equals("uuid")) {
            return UUID.randomUUID().toString();
        }
        return this.getRandomBytes();
    }

    private String getRange(String type, String prefix) {
        if (type.startsWith(prefix)) {
            int startIndex = prefix.length() + 1;
            if (type.length() > startIndex) {
                return type.substring(startIndex, type.length() - 1);
            }
        }
        return null;
    }

    private int getNextIntInRange(String range) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray((String)range);
        int start = Integer.parseInt(tokens[0]);
        if (tokens.length == 1) {
            return ((Random)this.getSource()).nextInt(start);
        }
        return start + ((Random)this.getSource()).nextInt(Integer.parseInt(tokens[1]) - start);
    }

    private long getNextLongInRange(String range) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray((String)range);
        if (tokens.length == 1) {
            return Math.abs(((Random)this.getSource()).nextLong() % Long.parseLong(tokens[0]));
        }
        long lowerBound = Long.parseLong(tokens[0]);
        long upperBound = Long.parseLong(tokens[1]) - lowerBound;
        return lowerBound + Math.abs(((Random)this.getSource()).nextLong() % upperBound);
    }

    private Object getRandomBytes() {
        byte[] bytes = new byte[32];
        ((Random)this.getSource()).nextBytes(bytes);
        return DigestUtils.md5DigestAsHex((byte[])bytes);
    }

    public static void addToEnvironment(ConfigurableEnvironment environment) {
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new RandomValuePropertySource(RANDOM_PROPERTY_SOURCE_NAME));
        logger.trace((Object)"RandomValuePropertySource add to Environment");
    }
}

