/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <K, V> Map newMap(Object ... keysAndValues) {
        if (keysAndValues == null) {
            return Collections.emptyMap();
        }
        if (keysAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Must have an even number of keys and values");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    public static <T> Set<T> newSet(T ... values) {
        if (values == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(values));
    }

    public static <T> List<T> newList(T ... values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static Map getOrCreateChildMap(Map parent, String key) {
        Object o = parent.get(key);
        if (o instanceof Map) {
            return (Map)o;
        }
        return new LinkedHashMap();
    }
}

