# -*- coding: utf-8; -*-
"""
Copyright (C) 2007-2013 Guake authors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301 USA
"""

# index 00: Host
# index 01: Syntax string
# index 02: Command
# index 03: Command color 2
# index 04: Path
# index 05: Syntax var
# index 06: Promp
# index 07:
# index 08:
# index 09: Command error
# index 10: Exec
# index 11:
# index 12: Folder
# index 13:
# index 14:
# index 15:
# index 16: Background Color
# index 17: Foreground Color

PALETTES = {
    '3024 Day': (
        '#090903030000:#DBDB2D2D2020:#0101A2A25252:#FDFDEDED0202:#0101A0A0E4E4:'
        '#A1A16A6A9494:#B5B5E4E4F4F4:#A5A5A2A2A2A2:#5C5C58585555:#E8E8BBBBD0D0:'
        '#3A3A34343232:#4A4A45454343:#80807D7D7C7C:#D6D6D5D5D4D4:#CDCDABAB5353:'
        '#F7F7F7F7F7F7:#4A4A45454343:#F7F7F7F7F7F7'
    ),
    '3024 Night': (
        '#090903030000:#DBDB2D2D2020:#0101A2A25252:#FDFDEDED0202:#0101A0A0E4E4:'
        '#A1A16A6A9494:#B5B5E4E4F4F4:#A5A5A2A2A2A2:#5C5C58585555:#E8E8BBBBD0D0:'
        '#3A3A34343232:#4A4A45454343:#80807D7D7C7C:#D6D6D5D5D4D4:#CDCDABAB5353:'
        '#F7F7F7F7F7F7:#A5A5A2A2A2A2:#090903030000'
    ),
    'Adventure Time': (
        '#050504040404:#BCBC00001313:#4949B1B11717:#E6E674741D1D:#0F0F4949C6C6:'
        '#666659599292:#6F6FA4A49797:#F8F8DBDBC0C0:#4E4E7B7BBFBF:#FCFC5E5E5959:'
        '#9D9DFFFF6E6E:#EFEFC1C11A1A:#18189696C6C6:#9A9A59595252:#C8C8F9F9F3F3:'
        '#F5F5F4F4FBFB:#F8F8DBDBC0C0:#1E1E1C1C4444'
    ),
    'Afterglow': (
        '#151515151515:#ACAC41414242:#7E7E8D8D5050:#E5E5B5B56767:#6C6C9999BABA:'
        '#9E9E4E4E8585:#7D7DD5D5CFCF:#D0D0D0D0D0D0:#505050505050:#ACAC41414242:'
        '#7E7E8D8D5050:#E5E5B5B56666:#6C6C9999BBBB:#9E9E4E4E8585:#7D7DD5D5CFCF:'
        '#F5F5F5F5F5F5:#D0D0D0D0D0D0:#202020202020'
    ),
    'Alien Blood': (
        '#111126261515:#7F7F2B2B2626:#2F2F7E7E2525:#70707F7F2323:#2F2F69697F7F:'
        '#474757577E7E:#31317F7F7676:#64647D7D7575:#3C3C47471111:#DFDF80800808:'
        '#1818E0E00000:#BDBDE0E00000:#0000A9A9DFDF:#00005858DFDF:#0000DFDFC3C3:'
        '#7373F9F99090:#63637D7D7575:#0F0F16160F0F'
    ),
    'Argonaut': (
        '#222222222222:#FFFF00000F0F:#8C8CE0E00A0A:#FFFFB9B90000:#00008D8DF8F8:'
        '#6C6C4343A5A5:#0000D7D7EBEB:#FFFFFFFFFFFF:#444444444444:#FFFF27273F3F:'
        '#ABABE0E05A5A:#FFFFD1D14141:#00009292FFFF:#9A9A5F5FEBEB:#6767FFFFEFEF:'
        '#FFFFFFFFFFFF:#FFFFFAFAF3F3:#0D0D0F0F1818'
    ),
    'Arthur': (
        '#3D3D35352A2A:#CDCD5C5C5C5C:#8686AFAF8080:#E8E8AEAE5B5B:#64649595EDED:'
        '#DEDEB8B88787:#B0B0C4C4DEDE:#BBBBAAAA9999:#555544444444:#CCCC55553333:'
        '#8888AAAA2222:#FFFFA7A75D5D:#8787CECEEBEB:#999966660000:#B0B0C4C4DEDE:'
        '#DDDDCCCCBBBB:#DDDDEEEEDDDD:#1C1C1C1C1C1C'
    ),
    'Atom': (
        '#000000000000:#FCFC5E5EF0F0:#8787C3C38A8A:#FFFFD7D7B1B1:#8585BEBEFDFD:'
        '#B9B9B5B5FCFC:#8585BEBEFDFD:#DFDFDFDFDFDF:#000000000000:#FCFC5E5EF0F0:'
        '#9494F9F93636:#F5F5FFFFA7A7:#9696CBCBFEFE:#B9B9B5B5FCFC:#8585BEBEFDFD:'
        '#DFDFDFDFDFDF:#C5C5C8C8C6C6:#161617171818'
    ),
    'Belafonte Day': (
        '#202011111B1B:#BEBE10100E0E:#858581816262:#EAEAA5A54949:#42426A6A7979:'
        '#979752522C2C:#98989A9A9C9C:#96968C8C8383:#5E5E52525252:#BEBE10100E0E:'
        '#858581816262:#EAEAA5A54949:#42426A6A7979:#979752522C2C:#98989A9A9C9C:'
        '#D5D5CCCCBABA:#454537373C3C:#D5D5CCCCBABA'
    ),
    'Belafonte Night': (
        '#202011111B1B:#BEBE10100E0E:#858581816262:#EAEAA5A54949:#42426A6A7979:'
        '#979752522C2C:#98989A9A9C9C:#96968C8C8383:#5E5E52525252:#BEBE10100E0E:'
        '#858581816262:#EAEAA5A54949:#42426A6A7979:#979752522C2C:#98989A9A9C9C:'
        '#D5D5CCCCBABA:#96968C8C8383:#202011111B1B'
    ),
    'Birdsofparadise': (
        '#57573D3D2525:#BEBE2D2D2626:#6B6BA0A08A8A:#E9E99C9C2929:#5A5A8686ACAC:'
        '#ABAB8080A6A6:#7474A5A5ACAC:#DFDFDADAB7B7:#9A9A6B6B4949:#E8E845452626:'
        '#9494D7D7BABA:#D0D0D0D04F4F:#B8B8D3D3EDED:#D0D09D9DCACA:#9292CECED6D6:'
        '#FFFFF9F9D4D4:#DFDFDADAB7B7:#2A2A1E1E1D1D'
    ),
    'Blazer': (
        '#000000000000:#B8B87A7A7A7A:#7A7AB8B87A7A:#B8B8B8B87A7A:#7A7A7A7AB8B8:'
        '#B8B87A7AB8B8:#7A7AB8B8B8B8:#D9D9D9D9D9D9:#262626262626:#DBDBBDBDBDBD:'
        '#BDBDDBDBBDBD:#DBDBDBDBBDBD:#BDBDBDBDDBDB:#DBDBBDBDDBDB:#BDBDDBDBDBDB:'
        '#FFFFFFFFFFFF:#D9D9E6E6F2F2:#0D0D19192626'
    ),
    'Bluloco': (
        '#505050505050:#FFFF2E2E3F3F:#6F6FD6D65D5D:#FFFF6F6F2323:#34347676FFFF:'
        '#98986161F8F8:#0000CDCDB3B3:#FFFFFCFCC2C2:#7C7C7C7C7C7C:#FFFF64648080:'
        '#3F3FC5C56B6B:#F9F9C8C85959:#0000B1B1FEFE:#B6B68D8DFFFF:#B3B38B8B7D7D:'
        '#FFFFFEFEE3E3:#DEDEE0E0DFDF:#262626262626'
    ),
    'Borland': (
        '#4E4E4E4E4E4E:#FFFF6B6B6060:#A7A7FFFF6060:#FFFFFFFFB6B6:#9696CACAFDFD:'
        '#FFFF7373FDFD:#C6C6C4C4FDFD:#EEEEEEEEEEEE:#7C7C7C7C7C7C:#FFFFB6B6B0B0:'
        '#CECEFFFFABAB:#FFFFFFFFCBCB:#B5B5DCDCFEFE:#FFFF9C9CFEFE:#DFDFDFDFFEFE:'
        '#FFFFFFFFFFFF:#FFFFFFFF4E4E:#00000000A4A4'
    ),
    'Broadcast': (
        '#000000000000:#DADA49493939:#51519F9F5050:#FFFFD2D24A4A:#6D6D9C9CBEBE:'
        '#D0D0D0D0FFFF:#6E6E9C9CBEBE:#FFFFFFFFFFFF:#323232323232:#FFFF7B7B6B6B:'
        '#8383D1D18282:#FFFFFFFF7C7C:#9F9FCECEF0F0:#FFFFFFFFFFFF:#A0A0CECEF0F0:'
        '#FFFFFFFFFFFF:#E6E6E1E1DCDC:#2B2B2B2B2B2B'
    ),
    'Brogrammer': (
        '#1F1F1F1F1F1F:#F7F711111818:#2C2CC5C55D5D:#ECECB9B90F0F:#2A2A8484D2D2:'
        '#4E4E5959B7B7:#0F0F8080D5D5:#D6D6DADAE4E4:#D6D6DADAE4E4:#DEDE34342E2E:'
        '#1D1DD2D26060:#F2F2BDBD0909:#0F0F8080D5D5:#52524F4FB9B9:#0F0F7C7CDADA:'
        '#FFFFFFFFFFFF:#D6D6DADAE4E4:#131313131313'
    ),
    'C64': (
        '#090903030000:#888839393232:#5555A0A04949:#BFBFCECE7272:#404031318D8D:'
        '#8B8B3F3F9696:#6767B6B6BDBD:#FFFFFFFFFFFF:#000000000000:#888839393232:'
        '#5555A0A04949:#BFBFCECE7272:#404031318D8D:#8B8B3F3F9696:#6767B6B6BDBD:'
        '#F7F7F7F7F7F7:#78786969C4C4:#404031318D8D'
    ),
    'Chalk': (
        '#7C7C8A8A8F8F:#B2B23A3A5151:#78789A9A6969:#B9B9ABAB4A4A:#2A2A7F7FACAC:'
        '#BCBC4F4F5A5A:#4444A7A79999:#D2D2D8D8D9D9:#888888888888:#F2F248484040:'
        '#8080C4C46F6F:#FFFFEBEB6262:#40409595FFFF:#FBFB51517575:#5252CCCCBDBD:'
        '#D2D2D8D8D9D9:#D2D2D8D8D9D9:#2B2B2C2C2E2E'
    ),
    'Chalkboard': (
        '#000000000000:#C3C373737272:#7272C3C37373:#C2C2C3C37272:#73737272C3C3:'
        '#C3C37272C2C2:#7272C2C2C3C3:#D9D9D9D9D9D9:#323232323232:#DBDBAAAAAAAA:'
        '#AAAADBDBAAAA:#DADADBDBAAAA:#AAAAAAAADBDB:#DBDBAAAADADA:#AAAADADADBDB:'
        '#FFFFFFFFFFFF:#D9D9E6E6F2F2:#292926262F2F'
    ),
    'Ciapre': (
        '#181818181818:#808000000909:#484851513B3B:#CCCC8A8A3E3E:#56566D6D8C8C:'
        '#72724C4C7C7C:#5B5B4F4F4A4A:#ADADA3A37E7E:#555555555555:#ABAB38383434:'
        '#A6A6A6A65D5D:#DCDCDEDE7B7B:#2F2F9797C6C6:#D3D330306060:#F3F3DADAB1B1:'
        '#F3F3F3F3F3F3:#ADADA3A37A7A:#18181C1C2727'
    ),
    'Clrs': (
        '#000000000000:#F7F727272929:#323289895C5C:#F9F96F6F1C1C:#12125C5CCFCF:'
        '#9F9F0000BCBC:#3232C2C2C0C0:#B2B2B2B2B2B2:#545457575353:#FBFB04041616:'
        '#2C2CC6C63131:#FCFCD6D62727:#15156F6FFEFE:#E8E80000B0B0:#3939D5D5CECE:'
        '#EDEDEDEDECEC:#262626262626:#FFFFFFFFFFFF'
    ),
    'Cobalt Neon': (
        '#141426263030:#FFFF23232020:#3A3AA5A5FFFF:#E9E9E7E75C5C:#8F8FF5F58686:'
        '#78781A1AA0A0:#8F8FF5F58686:#BABA4545B1B1:#FFFFF6F68888:#D4D431312E2E:'
        '#8F8FF5F58686:#E9E9F0F06D6D:#3C3C7D7DD2D2:#82823030A7A7:#6C6CBCBC6767:'
        '#8F8FF5F58686:#8F8FF5F58686:#141428283838'
    ),
    'Cobalt2': (
        '#000000000000:#FFFF00000000:#3737DDDD2121:#FEFEE4E40909:#14146060D2D2:'
        '#FFFF00005D5D:#0000BBBBBBBB:#BBBBBBBBBBBB:#555555555555:#F4F40D0D1717:'
        '#3B3BCFCF1D1D:#ECECC8C80909:#55555555FFFF:#FFFF5555FFFF:#6A6AE3E3F9F9:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#121226263737'
    ),
    'Crayon Pony Fish': (
        '#2A2A1A1A1C1C:#909000002A2A:#575795952323:#AAAA30301B1B:#8B8B8787AFAF:'
        '#68682E2E5050:#E8E8A7A76666:#686852525959:#3C3C2A2A2E2E:#C5C524245C5C:'
        '#8D8DFFFF5656:#C7C737371D1D:#CFCFC9C9FFFF:#FBFB6C6CB9B9:#FFFFCECEAEAE:'
        '#AFAF94949D9D:#686852525959:#141406060707'
    ),
    'Dark Pastel': (
        '#000000000000:#FFFF55555555:#5555FFFF5555:#FFFFFFFF5555:#55555555FFFF:'
        '#FFFF5555FFFF:#5555FFFFFFFF:#BBBBBBBBBBBB:#555555555555:#FFFF55555555:'
        '#5555FFFF5555:#FFFFFFFF5555:#55555555FFFF:#FFFF5555FFFF:#5555FFFFFFFF:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#000000000000'
    ),
    'Darkside': (
        '#000000000000:#E8E834341C1C:#6868C2C25656:#F2F2D3D32C2C:#1C1C9898E8E8:'
        '#8E8E6969C9C9:#1C1C9898E8E8:#BABABABABABA:#000000000000:#DFDF5A5A4F4F:'
        '#7676B7B76868:#EEEED6D64A4A:#38387B7BD2D2:#95957B7BBDBD:#3D3D9696E2E2:'
        '#BABABABABABA:#BABABABABABA:#222223232424'
    ),
    'Desert': (
        '#4D4D4D4D4D4D:#FFFF2B2B2B2B:#9898FBFB9898:#F0F0E6E68C8C:#CDCD85853F3F:'
        '#FFFFDEDEADAD:#FFFFA0A0A0A0:#F5F5DEDEB3B3:#555555555555:#FFFF55555555:'
        '#5555FFFF5555:#FFFFFFFF5555:#8787CECEFFFF:#FFFF5555FFFF:#FFFFD7D70000:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#333333333333'
    ),
    'Dimmed Monokai': (
        '#3A3A3C3C4343:#BEBE3E3E4848:#86869A9A3A3A:#C4C4A5A53535:#4E4E7676A1A1:'
        '#85855B5B8D8D:#56568E8EA3A3:#B8B8BCBCB9B9:#888889898787:#FBFB00001E1E:'
        '#0E0E71712E2E:#C3C370703333:#17176C6CE3E3:#FBFB00006767:#2D2D6F6F6C6C:'
        '#FCFCFFFFB8B8:#B8B8BCBCB9B9:#1E1E1E1E1E1E'
    ),
    'Dracula': (
        '#000000000000:#FFFF55555555:#5050FAFA7B7B:#F1F1FAFA8C8C:#BDBD9393F9F9:'
        '#FFFF7979C6C6:#8B8BE9E9FDFD:#BBBBBBBBBBBB:#555555555555:#FFFF55555555:'
        '#5050FAFA7B7B:#F1F1FAFA8C8C:#BDBD9393F9F9:#FFFF7979C6C6:#8B8BE9E9FDFD:'
        '#FFFFFFFFFFFF:#F8F8F8F8F2F2:#1E1E1F1F2828'
    ),
    'Earthsong': (
        '#111114141717:#C8C841413434:#8484C4C44B4B:#F4F4AEAE2E2E:#13139797B9B9:'
        '#D0D062623C3C:#4F4F94945252:#E5E5C5C5A9A9:#66665E5E5454:#FFFF64645959:'
        '#9797E0E03535:#DFDFD5D56161:#5E5ED9D9FFFF:#FFFF91916868:#8383EFEF8888:'
        '#F6F6F6F6ECEC:#E5E5C6C6A8A8:#282824242020'
    ),
    'Elemental': (
        '#3C3C3B3B3030:#979728280F0F:#474799994242:#7F7F71711010:#49497F7F7D7D:'
        '#7E7E4E4E2E2E:#38387F7F5858:#808079797474:#545454544444:#DFDF50502A2A:'
        '#6060E0E06F6F:#D6D698982727:#7878D8D8D8D8:#CDCD7C7C5353:#5858D5D59898:'
        '#FFFFF1F1E8E8:#808079797373:#212121211C1C'
    ),
    'Elementary Loki': (
        '#070736364242:#DCDC32322F2F:#858599990000:#B5B589890000:#26268B8BD2D2:'
        '#ECEC00004848:#2A2AA1A19898:#9494A3A3A5A5:#58586E6E7575:#CBCB4B4B1616:'
        '#858599990000:#B5B589890000:#26268B8BD2D2:#D3D336368282:#2A2AA1A19898:'
        '#EEEEEEEEEEEE:#9494A3A3A5A5:#25252E2E3232'
    ),
    'Espresso Libre': (
        '#000000000000:#CCCC00000000:#1A1A92921C1C:#EFEFE4E43A3A:#00006666FFFF:'
        '#C5C565656B6B:#050598989A9A:#D3D3D7D7CFCF:#545457575353:#EFEF28282828:'
        '#9A9AFFFF8787:#FFFFFAFA5C5C:#4343A8A8EDED:#FFFF80808989:#3434E2E2E2E2:'
        '#EDEDEDEDECEC:#B8B8A8A89898:#2A2A21211C1C'
    ),
    'Espresso': (
        '#343434343434:#D2D251515151:#A5A5C2C26161:#FFFFC6C66D6D:#6C6C9999BBBB:'
        '#D1D19797D9D9:#BEBED6D6FFFF:#EEEEEEEEECEC:#535353535353:#F0F00C0C0C0C:'
        '#C2C2E0E07575:#E1E1E3E38B8B:#8A8AB7B7D9D9:#EFEFB5B5F7F7:#DCDCF3F3FFFF:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#323232323232'
    ),
    'Fideloper': (
        '#28282F2F3232:#CACA1D1D2C2C:#EDEDB7B7ABAB:#B7B7AAAA9A9A:#2E2E7878C1C1:'
        '#C0C022226E6E:#303091918585:#E9E9E2E2CDCD:#090920202727:#D3D35F5F5A5A:'
        '#D3D35F5F5A5A:#A8A865657171:#7C7C8484C4C4:#5B5B5D5DB2B2:#818190908F8F:'
        '#FCFCF4F4DEDE:#DADAD9D9DFDF:#28282F2F3232'
    ),
    'Fishtank': (
        '#030306063C3C:#C6C600004949:#ABABF1F15757:#FDFDCDCD5E5E:#52525F5FB8B8:'
        '#97976F6F8181:#969686866262:#ECECEFEFFCFC:#6C6C5A5A3030:#D9D94A4A8A8A:'
        '#DADAFFFFA8A8:#FEFEE6E6A8A8:#B1B1BDBDF9F9:#FDFDA4A4CCCC:#A4A4BCBC8686:'
        '#F6F6FFFFECEC:#ECECEFEFFDFD:#222224243636'
    ),
    'Flat': (
        '#22222D2D3F3F:#A8A823232020:#3232A5A54848:#E5E58D8D1111:#31316767ACAC:'
        '#78781A1AA0A0:#2C2C93937070:#B0B0B6B6BABA:#21212C2C3C3C:#D4D431312E2E:'
        '#2D2D94944040:#E5E5BEBE0C0C:#3C3C7D7DD2D2:#82823030A7A7:#3535B3B38787:'
        '#E7E7ECECEDED:#2C2CC5C55D5D:#000022224040'
    ),
    'Flatland': (
        '#1C1C1D1D1919:#F1F182823838:#9E9ED2D26464:#F3F3EFEF6D6D:#4F4F9696BEBE:'
        '#69695A5ABBBB:#D5D538386464:#FEFEFFFFFEFE:#1C1C1D1D1919:#D1D12A2A2424:'
        '#A7A7D3D32C2C:#FFFF89894848:#6161B8B8D0D0:#69695A5ABBBB:#D5D538386464:'
        '#FEFEFFFFFEFE:#B8B8DADAEEEE:#1C1C1E1E2020'
    ),
    'Frontend Delight': (
        '#242424242626:#F8F850501A1A:#565657574646:#F9F976761D1D:#2C2C7070B7B7:'
        '#F0F02D2D4E4E:#3B3BA0A0A5A5:#ACACACACACAC:#5E5EACAC6C6C:#F6F643431919:'
        '#7474EBEB4C4C:#FCFCC2C22424:#33339393C9C9:#E7E75E5E4E4E:#4E4EBCBCE5E5:'
        '#8B8B73735A5A:#ACACACACACAC:#1B1B1B1B1D1D'
    ),
    'Frontend Fun Forrest': (
        '#000000000000:#D5D525252B2B:#90909B9B0000:#BDBD8A8A1313:#46469898A2A2:'
        '#8C8C42423131:#D9D981811212:#DDDDC1C16565:#7E7E69695454:#E4E459591B1B:'
        '#BFBFC6C65959:#FFFFCACA1B1B:#7C7CC9C9CECE:#D1D163634949:#E6E6A9A96B6B:'
        '#FFFFE9E9A3A3:#DDDDC1C16565:#242412120000'
    ),
    'Frontend Galaxy': (
        '#000000000000:#F9F955555F5F:#2020AFAF8989:#FDFDF0F02929:#58589C9CF5F5:'
        '#93934D4D9595:#1E1E9E9EE6E6:#BBBBBBBBBBBB:#555555555555:#FAFA8B8B8E8E:'
        '#3434BBBB9999:#FFFFFFFF5555:#58589C9CF5F5:#E7E755559898:#39397878BBBB:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#1C1C28283636'
    ),
    'Github': (
        '#3E3E3E3E3E3E:#97970B0B1616:#070796962A2A:#F8F8EEEEC7C7:#00003E3E8A8A:'
        '#E9E946469191:#8989D1D1ECEC:#FFFFFFFFFFFF:#666666666666:#DEDE00000000:'
        '#8787D5D5A2A2:#F1F1D0D00707:#2E2E6C6CBABA:#FFFFA2A29F9F:#1C1CFAFAFEFE:'
        '#FFFFFFFFFFFF:#3E3E3E3E3E3E:#F4F4F4F4F4F4'
    ),
    'Grape': (
        '#2D2D28283E3E:#ECEC21216060:#1F1FA9A91B1B:#8D8DDCDC1F1F:#48487C7CF4F4:'
        '#8C8C3535C8C8:#3A3ADDDDEDED:#9E9E9E9EA0A0:#585850506A6A:#F0F071719A9A:'
        '#5252A9A95D5D:#B2B2DCDC8787:#A9A9BBBBEBEB:#ACAC8181C1C1:#9C9CE3E3EAEA:'
        '#A1A18888F7F7:#9E9E9E9EA0A0:#161614142323'
    ),
    'Grass': (
        '#000000000000:#BBBB00000000:#0000BBBB0000:#E7E7B0B00000:#00000000A3A3:'
        '#959500006161:#0000BBBBBBBB:#BBBBBBBBBBBB:#555555555555:#BBBB00000000:'
        '#0000BBBB0000:#E7E7B0B00000:#00000000BBBB:#FFFF5555FFFF:#5555FFFFFFFF:'
        '#FFFFFFFFFFFF:#FFFFF0F0A5A5:#131377773C3C'
    ),
    'Hardcore': (
        '#1B1B1D1D1E1E:#F9F926267272:#A6A6E2E22E2E:#FDFD97971F1F:#6666D9D9EFEF:'
        '#9E9E6F6FFEFE:#5E5E71717575:#CCCCCCCCC6C6:#505053535454:#FFFF66669D9D:'
        '#BEBEEDED5F5F:#E6E6DBDB7474:#6666D9D9EFEF:#9E9E6F6FFEFE:#A3A3BABABFBF:'
        '#F8F8F8F8F2F2:#A0A0A0A0A0A0:#121212121212'
    ),
    'Harper': (
        '#010101010101:#F8F8B6B63F3F:#7F7FB5B5E1E1:#D6D6DADA2525:#48489E9E4848:'
        '#B2B29696C6C6:#F5F5BFBFD7D7:#A8A8A4A49D9D:#72726E6E6A6A:#F8F8B6B63F3F:'
        '#7F7FB5B5E1E1:#D6D6DADA2525:#48489E9E4848:#B2B29696C6C6:#F5F5BFBFD7D7:'
        '#FEFEFBFBEAEA:#A8A8A4A49D9D:#010101010101'
    ),
    'Highway': (
        '#000000000000:#CFCF0D0D1717:#121280803333:#FFFFCACA3D3D:#00006A6AB3B3:'
        '#6A6A26267474:#383845456363:#EDEDEDEDEDED:#5C5C4F4F4949:#EFEF7D7D1717:'
        '#B1B1D1D13030:#FFFFF1F11F1F:#4F4FC2C2FDFD:#DEDE00007070:#5C5C4F4F4949:'
        '#FEFEFFFFFEFE:#EDEDEDEDEDED:#212122222424'
    ),
    'Hipster Green': (
        '#000000000000:#B6B620204A4A:#0000A6A60000:#BEBEBEBE0000:#24246D6DB2B2:'
        '#B2B20000B2B2:#0000A6A6B2B2:#BFBFBFBFBFBF:#666666666666:#E5E500000000:'
        '#8686A8A83E3E:#E5E5E5E50000:#00000000FFFF:#E5E50000E5E5:#0000E5E5E5E5:'
        '#E5E5E5E5E5E5:#8484C1C13737:#0F0F0A0A0505'
    ),
    'Homebrew': (
        '#000000000000:#999900000000:#0000A6A60000:#999999990000:#00000000B2B2:'
        '#B2B20000B2B2:#0000A6A6B2B2:#BFBFBFBFBFBF:#666666666666:#E5E500000000:'
        '#0000D9D90000:#E5E5E5E50000:#00000000FFFF:#E5E50000E5E5:#0000E5E5E5E5:'
        '#E5E5E5E5E5E5:#0000FFFF0000:#000000000000'
    ),
    'Hurtado': (
        '#575757575757:#FFFF1B1B0000:#A5A5DFDF5555:#FBFBE7E74A4A:#484863638787:'
        '#FCFC5E5EF0F0:#8585E9E9FEFE:#CBCBCBCBCBCB:#252525252525:#D4D41C1C0000:'
        '#A5A5DFDF5555:#FBFBE7E74949:#8989BDBDFFFF:#BFBF0000C0C0:#8585E9E9FEFE:'
        '#DBDBDBDBDBDB:#DADADBDBDADA:#000000000000'
    ),
    'Hybrid': (
        '#2A2A2E2E3333:#B7B74D4D5050:#B3B3BEBE5A5A:#E3E3B5B55E5E:#6D6D9090B0B0:'
        '#A0A07E7EABAB:#7F7FBEBEB3B3:#B5B5B8B8B6B6:#1D1D1E1E2121:#8C8C2D2D3232:'
        '#787883833131:#E5E589894F4F:#4B4B6B6B8888:#6E6E4F4F7979:#4D4D7B7B7373:'
        '#5A5A61616969:#B7B7BCBCB9B9:#161617171818'
    ),
    'Ic Green Ppl': (
        '#1E1E1E1E1E1E:#FBFB00002929:#32329B9B2424:#64649A9A2525:#14149B9B4545:'
        '#5353B8B82B2B:#2B2BB7B76767:#DFDFFEFEEEEE:#030326260F0F:#A6A6FFFF3E3E:'
        '#9F9FFFFF6D6D:#D1D1FFFF6D6D:#7272FFFFB5B5:#5050FFFF3D3D:#2222FFFF7171:'
        '#DADAEEEED0D0:#D9D9EEEED2D2:#3A3A3C3C3E3E'
    ),
    'Ic Orange Ppl': (
        '#000000000000:#C0C039390000:#A3A3A9A90000:#CACAAEAE0000:#BDBD6C6C0000:'
        '#FBFB5D5D0000:#F7F794940000:#FFFFC8C88A8A:#6A6A4E4E2929:#FFFF8B8B6767:'
        '#F6F6FFFF3F3F:#FFFFE3E36E6E:#FFFFBDBD5454:#FCFC87874F4F:#C5C597975252:'
        '#F9F9F9F9FEFE:#FFFFCBCB8383:#262626262626'
    ),
    'Idle Toes': (
        '#323232323232:#D2D252525252:#7F7FE1E17373:#FFFFC6C66D6D:#40409898FFFF:'
        '#F5F57F7FFFFF:#BEBED6D6FFFF:#EEEEEEEEECEC:#535353535353:#F0F070707070:'
        '#9D9DFFFF9090:#FFFFE4E48B8B:#5E5EB7B7F7F7:#FFFF9D9DFFFF:#DCDCF4F4FFFF:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#323232323232'
    ),
    'Ir Black': (
        '#4F4F4F4F4F4F:#FAFA6C6C5F5F:#A8A8FEFE6060:#FFFFFEFEB6B6:#9696CACAFDFD:'
        '#FAFA7272FCFC:#C6C6C4C4FDFD:#EEEEEDEDEEEE:#7B7B7B7B7B7B:#FCFCB6B6AFAF:'
        '#CECEFFFFABAB:#FFFFFEFECCCC:#B5B5DCDCFEFE:#FBFB9B9BFEFE:#DFDFDFDFFDFD:'
        '#FEFEFFFFFEFE:#F1F1F1F1F1F1:#000000000000'
    ),
    'Jackie Brown': (
        '#2C2C1D1D1616:#EFEF57573434:#2B2BAFAF2B2B:#BDBDBEBE0000:#24246D6DB2B2:'
        '#CFCF5E5EC0C0:#0000ACACEEEE:#BFBFBFBFBFBF:#666666666666:#E5E500000000:'
        '#8686A8A83E3E:#E5E5E5E50000:#00000000FFFF:#E5E50000E5E5:#0000E5E5E5E5:'
        '#E5E5E5E5E5E5:#FFFFCCCC2F2F:#2C2C1C1C1515'
    ),
    'Japanesque': (
        '#343438383535:#CECE3E3E6060:#7B7BB7B75B5B:#E8E8B3B32A2A:#4C4C9999D3D3:'
        '#A5A57F7FC4C4:#38389A9AACAC:#F9F9FAFAF6F6:#58585A5A5858:#D1D18E8EA6A6:'
        '#76767E7E2B2B:#777759592E2E:#131358587979:#5F5F41419090:#7676BBBBCACA:'
        '#B1B1B5B5AEAE:#F7F7F6F6ECEC:#1D1D1D1D1D1D'
    ),
    'Jellybeans': (
        '#929292929292:#E2E273737373:#9393B9B97979:#FFFFBABA7B7B:#9797BEBEDCDC:'
        '#E1E1C0C0FAFA:#000098988E8E:#DEDEDEDEDEDE:#BDBDBDBDBDBD:#FFFFA1A1A1A1:'
        '#BDBDDEDEABAB:#FFFFDCDCA0A0:#B1B1D8D8F6F6:#FBFBDADAFFFF:#1A1AB2B2A8A8:'
        '#FFFFFFFFFFFF:#DEDEDEDEDEDE:#121212121212'
    ),
    'Kibble': (
        '#4D4D4D4D4D4D:#C7C700003131:#2929CFCF1313:#D8D8E3E30E0E:#34344949D1D1:'
        '#84840000FFFF:#07079898ABAB:#E2E2D1D1E3E3:#5A5A5A5A5A5A:#F0F015157878:'
        '#6C6CE0E05C5C:#F3F3F7F79E9E:#9797A4A4F7F7:#C4C49595F0F0:#6868F2F2E0E0:'
        '#FFFFFFFFFFFF:#F7F7F7F7F7F7:#0E0E10100A0A'
    ),
    'Later This Evening': (
        '#2B2B2B2B2B2B:#D3D35A5A5F5F:#AFAFBABA6666:#E5E5D2D28989:#A0A0B9B9D5D5:'
        '#BFBF9292D5D5:#9191BEBEB6B6:#3B3B3C3C3C3C:#444447474747:#D3D322222E2E:'
        '#AAAABBBB3939:#E4E4BDBD3939:#65659999D5D5:#AAAA5252D5D5:#5F5FBFBFADAD:'
        '#C0C0C2C2C2C2:#949494949494:#212121212121'
    ),
    'Lavandula': (
        '#232300004545:#7C7C15152525:#33337E7E6F6F:#7F7F6F6F4949:#4F4F4A4A7F7F:'
        '#59593F3F7E7E:#575776767F7F:#73736E6E7D7D:#37372C2C4646:#DFDF50506666:'
        '#5252E0E0C4C4:#E0E0C2C28686:#8E8E8686DFDF:#A6A67575DFDF:#9A9AD3D3DFDF:'
        '#8C8C9191FAFA:#73736E6E7D7D:#050500001414'
    ),
    'Linux Console': (
        '#000000000000:#aaaa00000000:#0000aaaa0000:#aaaa55550000:#00000000aaaa:'
        '#aaaa0000aaaa:#0000aaaaaaaa:#aaaaaaaaaaaa:#555555555556:#ffff55555555:'
        '#5555ffff5555:#ffffffff5555:#55555555ffff:#ffff5555ffff:#5555ffffffff:'
        '#ffffffffffff:#ffffffffffff:#000000000000'
    ),
    'Liquid Carbon Transparent': (
        '#000000000000:#FFFF2F2F2F2F:#54549A9A6F6F:#CCCCACAC0000:#00009999CCCC:'
        '#CCCC6868C8C8:#7979C4C4CCCC:#BCBCCCCCCCCC:#000000000000:#FFFF2F2F2F2F:'
        '#54549A9A6F6F:#CCCCACAC0000:#00009999CCCC:#CCCC6868C8C8:#7979C4C4CCCC:'
        '#BCBCCCCCCCCC:#AFAFC2C2C2C2:#000000000000'
    ),
    'Liquid Carbon': (
        '#000000000000:#FFFF2F2F2F2F:#54549A9A6F6F:#CCCCACAC0000:#00009999CCCC:'
        '#CCCC6868C8C8:#7979C4C4CCCC:#BCBCCCCCCCCC:#000000000000:#FFFF2F2F2F2F:'
        '#54549A9A6F6F:#CCCCACAC0000:#00009999CCCC:#CCCC6868C8C8:#7979C4C4CCCC:'
        '#BCBCCCCCCCCC:#AFAFC2C2C2C2:#2F2F2F2F2F2F'
    ),
    'Lucario': (
        '#4E4E4E4E4E4E:#FFFF6B6B6060:#FAFAB0B03636:#FFFFFFFFB6B6:#56569696EDED:'
        '#FFFF7373FDFD:#8E8EE4E47878:#EEEEEEEEEEEE:#4F4F4F4F4F4F:#F9F968686060:'
        '#FAFAB0B03636:#FDFDFFFFB8B8:#6B6B9F9FEDED:#FCFC6E6EF9F9:#8E8EE4E47878:'
        '#FFFFFFFFFFFF:#F8F8F8F8F2F2:#2B2B3E3E5050'
    ),
    'Man Page': (
        '#000000000000:#CCCC00000000:#0000A6A60000:#999999990000:#00000000B2B2:'
        '#B2B20000B2B2:#0000A6A6B2B2:#CCCCCCCCCCCC:#666666666666:#E5E500000000:'
        '#0000D9D90000:#E5E5E5E50000:#00000000FFFF:#E5E50000E5E5:#0000E5E5E5E5:'
        '#E5E5E5E5E5E5:#000000000000:#FEFEF4F49C9C'
    ),
    'Mathias': (
        '#000000000000:#E5E522222222:#A6A6E3E32D2D:#FCFC95951E1E:#C4C48D8DFFFF:'
        '#FAFA25257373:#6767D9D9F0F0:#F2F2F2F2F2F2:#555555555555:#FFFF55555555:'
        '#5555FFFF5555:#FFFFFFFF5555:#55555555FFFF:#FFFF5555FFFF:#5555FFFFFFFF:'
        '#FFFFFFFFFFFF:#BBBBBBBBBBBB:#000000000000'
    ),
    'Medallion': (
        '#000000000000:#B5B54C4C0000:#7C7C8A8A1616:#D2D2BDBD2525:#60606B6BAFAF:'
        '#8B8B59599090:#90906B6B2525:#C9C9C1C19999:#5E5E51511818:#FFFF91914848:'
        '#B1B1C9C93A3A:#FFFFE4E44949:#ABABB8B8FFFF:#FEFE9F9FFFFF:#FFFFBBBB5151:'
        '#FEFED5D59797:#CACAC2C29696:#1D1D18180808'
    ),
    'Misterioso': (
        '#000000000000:#FFFF42424242:#7474AFAF6868:#FFFFADAD2929:#33338F8F8686:'
        '#94941313E5E5:#2323D7D7D7D7:#E1E1E1E1E0E0:#555555555555:#FFFF32324242:'
        '#7474CDCD6868:#FFFFB9B92929:#2323D7D7D7D7:#FFFF3737FFFF:#0000EDEDE1E1:'
        '#FFFFFFFFFFFF:#E1E1E1E1E0E0:#2D2D37374343'
    ),
    'Molokai': (
        '#121212121212:#FAFA25257373:#9797E1E12323:#DFDFD4D46060:#0F0F7F7FCFCF:'
        '#87870000FFFF:#4242A7A7CFCF:#BBBBBBBBBBBB:#555555555555:#F5F566669C9C:'
        '#B0B0E0E05E5E:#FEFEF2F26C6C:#0000AFAFFFFF:#AFAF8787FFFF:#5050CDCDFEFE:'
        '#FFFFFFFFFFFF:#BBBBBBBBBBBB:#121212121212'
    ),
    'Mona Lisa': (
        '#34341A1A0D0D:#9B9B28281B1B:#626261613232:#C2C26E6E2727:#51515B5B5C5C:'
        '#9B9B1D1D2929:#585880805656:#F6F6D7D75C5C:#878742422727:#FFFF42423030:'
        '#B3B3B1B16363:#FFFF95956565:#9E9EB2B2B3B3:#FFFF5B5B6A6A:#8989CCCC8E8E:'
        '#FFFFE5E59797:#F6F6D5D56A6A:#11110B0B0D0D'
    ),
    'Monokai Cobalt2': (
        '#1C1C1D1D1919:#D0D01B1B2424:#A7A7D3D32C2C:#D8D8CFCF6767:#6161B8B8D0D0:'
        '#69695A5ABBBB:#D5D538386464:#FEFEFFFFFEFE:#1C1C1D1D1919:#D0D01B1B2424:'
        '#A7A7D3D32C2C:#D8D8CFCF6767:#6161B8B8D0D0:#69695A5ABBBB:#D5D538386464:'
        '#FEFEFFFFFEFE:#FFFFFFFFFFFF:#121226263737'
    ),
    'Monokai Soda': (
        '#191919191919:#F3F300005F5F:#9797E0E02323:#FAFA84841919:#9C9C6464FEFE:'
        '#F3F300005F5F:#5757D1D1EAEA:#C4C4C4C4B5B5:#61615E5E4B4B:#F3F300005F5F:'
        '#9797E0E02323:#DFDFD5D56161:#9C9C6464FEFE:#F3F300005F5F:#5757D1D1EAEA:'
        '#F6F6F6F6EEEE:#C4C4C4C4B5B5:#191919191919'
    ),
    'Monokai': (
        '#1C1C1D1D1919:#D0D01B1B2424:#A7A7D3D32C2C:#D8D8CFCF6767:#6161B8B8D0D0:'
        '#69695A5ABBBB:#D5D538386464:#FEFEFFFFFEFE:#1C1C1D1D1919:#D0D01B1B2424:'
        '#A7A7D3D32C2C:#D8D8CFCF6767:#6161B8B8D0D0:#69695A5ABBBB:#D5D538386464:'
        '#FEFEFFFFFEFE:#F6F6F5F5EEEE:#232325252626'
    ),
    'N0tch2k': (
        '#383838383838:#A9A955555151:#666666666666:#A9A980805151:#65657D7D3E3E:'
        '#767676767676:#C9C9C9C9C9C9:#D0D0B8B8A3A3:#474747474747:#A9A977777575:'
        '#8C8C8C8C8C8C:#A9A991917575:#9898BDBD5E5E:#A3A3A3A3A3A3:#DCDCDCDCDCDC:'
        '#D8D8C8C8BBBB:#A0A0A0A0A0A0:#222222222222'
    ),
    'Neopolitan': (
        '#000000000000:#808000000000:#6161CECE3C3C:#FBFBDEDE2D2D:#25253B3B7676:'
        '#FFFF00008080:#8D8DA6A6CECE:#F8F8F8F8F8F8:#000000000000:#808000000000:'
        '#6161CECE3C3C:#FBFBDEDE2D2D:#25253B3B7676:#FFFF00008080:#8D8DA6A6CECE:'
        '#F8F8F8F8F8F8:#FFFFFFFFFFFF:#27271F1F1919'
    ),
    'Neutron': (
        '#222225252B2B:#B5B53F3F3636:#5A5AB9B97777:#DDDDB5B56666:#6A6A7B7B9292:'
        '#A3A379799D9D:#3F3F9393A8A8:#E6E6E8E8EEEE:#222225252B2B:#B5B53F3F3636:'
        '#5A5AB9B97777:#DDDDB5B56666:#6A6A7B7B9292:#A3A379799D9D:#3F3F9393A8A8:'
        '#EBEBEDEDF2F2:#E6E6E8E8EEEE:#1B1B1D1D2222'
    ),
    'Nightlion V1': (
        '#4C4C4C4C4C4C:#BBBB00000000:#5E5EDEDE8F8F:#F2F2F0F06767:#26266A6AD7D7:'
        '#BBBB0000BBBB:#0000D9D9DFDF:#BBBBBBBBBBBB:#555555555555:#FFFF55555555:'
        '#5555FFFF5555:#FFFFFFFF5555:#55555555FFFF:#FFFF5555FFFF:#5555FFFFFFFF:'
        '#FFFFFFFFFFFF:#BBBBBBBBBBBB:#000000000000'
    ),
    'Nightlion V2': (
        '#4C4C4C4C4C4C:#BBBB00000000:#0303F6F62222:#F2F2F0F06767:#6363D0D0F0F0:'
        '#CECE6F6FDADA:#0000D9D9DFDF:#BBBBBBBBBBBB:#555555555555:#FFFF55555555:'
        '#7D7DF6F61C1C:#FFFFFFFF5555:#6262CACAE7E7:#FFFF9A9AF5F5:#0000CCCCD7D7:'
        '#FFFFFFFFFFFF:#BBBBBBBBBBBB:#171717171717'
    ),
    'Nord': (
        '#3B3B42425252:#BFBF61616A6A:#A3A3BEBE8C8C:#EBEBCBCB8B8B:#8181A1A1C1C1:'
        '#B4B48E8EADAD:#8888C0C0D0D0:#E5E5E9E9F0F0:#4C4C56566A6A:#BFBF61616A6A:'
        '#A3A3BEBE8C8C:#EBEBCBCB8B8B:#8181A1A1C1C1:#B4B48E8EADAD:#8F8FBCBCBBBB:'
        '#ECECEFEFF4F4:#D8D8DEDEE9E9:#2E2E34344040'
    ),
    'Novel': (
        '#000000000000:#CCCC00000000:#000096960000:#D0D06B6B0000:#00000000CCCC:'
        '#CCCC0000CCCC:#00008787CCCC:#CCCCCCCCCCCC:#7F7F7F7F7F7F:#CCCC00000000:'
        '#000096960000:#D0D06B6B0000:#00000000CCCC:#CCCC0000CCCC:#00008686CBCB:'
        '#FFFFFFFFFFFF:#3B3B23232222:#DFDFDBDBC3C3'
    ),
    'Obsidian': (
        '#000000000000:#A5A500000101:#0000BBBB0000:#FEFECCCC2222:#39399B9BDADA:'
        '#BBBB0000BBBB:#0000BBBBBBBB:#BBBBBBBBBBBB:#555555555555:#FFFF00000303:'
        '#9292C7C76363:#FEFEF7F77373:#A0A0D6D6FFFF:#FFFF5555FFFF:#5555FFFFFFFF:'
        '#FFFFFFFFFFFF:#CCCCCCCCCCCC:#272730303232'
    ),
    'Ocean': (
        '#000000000000:#999900000000:#0000A6A60000:#999999990000:#00000000B2B2:'
        '#B2B20000B2B2:#0000A6A6B2B2:#BFBFBFBFBFBF:#666666666666:#E5E500000000:'
        '#0000D9D90000:#E5E5E5E50000:#00000000FFFF:#E5E50000E5E5:#0000E5E5E5E5:'
        '#E5E5E5E5E5E5:#FFFFFFFFFFFF:#22224F4FBCBC'
    ),
    'Ocean Dark': (
        '#2B2B30303B3B:#BFBF61616A6A:#A3A3BEBE8C8C:#EBEBCBCB8B8B:#8F8FA1A1B3B3:'
        '#B4B48E8EADAD:#9696B5B5B4B4:#C0C0C5C5CECE:#656573737E7E:#BFBF61616A6A:'
        '#A3A3BEBE8C8C:#EBEBCBCB8B8B:#8F8FA1A1B3B3:#B4B48E8EADAD:#9696B5B5B4B4:'
        '#EFEFF1F1F5F5:#C0C0C5C5CECE:#2B2B30303B3B'
    ),
    'Ocean Light': (
        '#EFEFF1F1F5F5:#BFBF61616A6A:#A3A3BEBE8C8C:#EBEBCBCB8B8B:#8F8FA1A1B3B3:'
        '#B4B48E8EADAD:#9696B5B5B4B4:#C0C0C5C5CECE:#656573737E7E:#BFBF61616A6A:'
        '#A3A3BEBE8C8C:#EBEBCBCB8B8B:#8F8FA1A1B3B3:#B4B48E8EADAD:#9696B5B5B4B4:'
        '#2B2B30303B3B:#4F4F5B5B6666:#EFEFF1F1F5F5'
    ),
    'Oceanic Next Dark': (
        '#1B1B2B2B3434:#ECEC5f5f6767:#9999C7C79494:#FAFAC8C86363:#66669999CCCC:'
        '#C5C59494C5C5:#5F5FB3B3B3B3:#C0C0C5C5CECE:#656573737E7E:#ECEC5f5f6767:'
        '#9999C7C79494:#FAFAC8C86363:#66669999CCCC:#C5C59494C5C5:#5F5FB3B3B3B3:'
        '#D8D8DEDEE9E9:#C0C0C5C5CECE:#1B1B2B2B3434'
    ),
    'Oceanic Next Light': (
        '#D8D8DEDEE9E9:#ECEC5f5f6767:#9999C7C79494:#FAFAC8C86363:#66669999CCCC:'
        '#C5C59494C5C5:#5F5FB3B3B3B3:#C0C0C5C5CECE:#656573737E7E:#ECEC5f5f6767:'
        '#9999C7C79494:#FAFAC8C86363:#66669999CCCC:#C5C59494C5C5:#5F5FB3B3B3B3:'
        '#1B1B2B2B3434:#4F4F5B5B6666:#D8D8DEDEE9E9'
    ),
    'Ollie': (
        '#000000000000:#ABAB2E2E3030:#3131ABAB6060:#ABAB42420000:#2C2C5656ABAB:'
        '#AFAF84842727:#1F1FA5A5ABAB:#8A8A8D8DABAB:#5A5A36362525:#FFFF3D3D4848:'
        '#3B3BFFFF9999:#FFFF5E5E1E1E:#44448787FFFF:#FFFFC2C21C1C:#1E1EFAFAFFFF:'
        '#5B5B6D6DA7A7:#8A8A8D8DAEAE:#212120202424'
    ),
    'One Dark': (
        '#000000000000:#B0B058586969:#7676A6A66565:#CFCFB0B07373:#4A4AA4A4B8B8:'
        '#A1A16565C1C1:#4A4AA4A4B8B8:#B1B1B1B1B1B1:#4C4C57577272:#B0B058586969:'
        '#7676A6A66565:#CFCFB0B07373:#4A4AA4A4B8B8:#A1A16565C1C1:#4A4AA4A4B8B8:'
        '#DEDEDEDEDEDE:#4C4C57577171:#171718181C1C'
    ),
    'Paul Millr': (
        '#2A2A2A2A2A2A:#FFFF00000000:#7979FFFF0F0F:#E7E7BFBF0000:#38386B6BD7D7:'
        '#B3B34949BEBE:#6666CCCCFFFF:#BBBBBBBBBBBB:#666666666666:#FFFF00008080:'
        '#6666FFFF6666:#F3F3D6D64E4E:#70709A9AEDED:#DBDB6767E6E6:#7979DFDFF2F2:'
        '#FFFFFFFFFFFF:#F2F2F2F2F2F2:#000000000000'
    ),
    'Pencil Dark': (
        '#212121212121:#C3C307077171:#1010A7A77878:#A8A89C9C1414:#00008E8EC4C4:'
        '#52523C3C7979:#2020A5A5BABA:#D9D9D9D9D9D9:#424242424242:#FBFB00007A7A:'
        '#5F5FD7D7AFAF:#F3F3E4E43030:#2020BBBBFCFC:#68685555DEDE:#4F4FB8B8CCCC:'
        '#F1F1F1F1F1F1:#F1F1F1F1F1F1:#212121212121'
    ),
    'Pencil Light': (
        '#212121212121:#C3C307077171:#1010A7A77878:#A8A89C9C1414:#00008E8EC4C4:'
        '#52523C3C7979:#2020A5A5BABA:#D9D9D9D9D9D9:#424242424242:#FBFB00007A7A:'
        '#5F5FD7D7AFAF:#F3F3E4E43030:#2020BBBBFCFC:#68685555DEDE:#4F4FB8B8CCCC:'
        '#F1F1F1F1F1F1:#424242424242:#F1F1F1F1F1F1'
    ),
    'Pnevma': (
        '#2F2F2E2E2D2D:#A3A366666666:#9090A5A57D7D:#D7D7AFAF8787:#7F7FA5A5BDBD:'
        '#C7C79E9EC4C4:#8A8ADBDBB4B4:#D0D0D0D0D0D0:#4A4A48484545:#D7D787878787:'
        '#AFAFBEBEA2A2:#E4E4C9C9AFAF:#A1A1BDBDCECE:#D7D7BEBEDADA:#B1B1E7E7DDDD:'
        '#EFEFEFEFEFEF:#D0D0D0D0D0D0:#1C1C1C1C1C1C'
    ),
    'Pro': (
        '#000000000000:#999900000000:#0000A6A60000:#999999990000:#1F1F0808DBDB:'
        '#B2B20000B2B2:#0000A6A6B2B2:#BFBFBFBFBFBF:#666666666666:#E5E500000000:'
        '#0000D9D90000:#E5E5E5E50000:#00000000FFFF:#E5E50000E5E5:#0000E5E5E5E5:'
        '#E5E5E5E5E5E5:#F2F2F2F2F2F2:#000000000000'
    ),
    'Red Alert': (
        '#000000000000:#D5D52E2E4D4D:#7171BEBE6B6B:#BEBEB8B86B6B:#47479B9BEDED:'
        '#E8E87878D6D6:#6B6BBEBEB8B8:#D6D6D6D6D6D6:#262626262626:#E0E024245353:'
        '#AFAFF0F08B8B:#DFDFDDDDB7B7:#6565A9A9F0F0:#DDDDB7B7DFDF:#B7B7DFDFDDDD:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#767624242323'
    ),
    'Red Sands': (
        '#000000000000:#FFFF3F3F0000:#0000BBBB0000:#E7E7B0B00000:#00007171FFFF:'
        '#BBBB0000BBBB:#0000BBBBBBBB:#BBBBBBBBBBBB:#555555555555:#BBBB00000000:'
        '#0000BBBB0000:#E7E7B0B00000:#00007171AEAE:#FFFF5555FFFF:#5555FFFFFFFF:'
        '#FFFFFFFFFFFF:#D7D7C9C9A7A7:#797924241E1E'
    ),
    'Rippedcasts': (
        '#000000000000:#CDCDAFAF9595:#A7A7FFFF6060:#BFBFBBBB1F1F:#7575A5A5B0B0:'
        '#FFFF7373FDFD:#595964647E7E:#BFBFBFBFBFBF:#666666666666:#EEEECBCBADAD:'
        '#BCBCEEEE6868:#E5E5E5E50000:#8686BDBDC9C9:#E5E50000E5E5:#8C8C9B9BC3C3:'
        '#E5E5E5E5E5E5:#FFFFFFFFFFFF:#2B2B2B2B2B2B'
    ),
    'Royal': (
        '#24241F1F2A2A:#909027274B4B:#232380801C1C:#B4B49D9D2727:#64648080AFAF:'
        '#66664D4D9696:#8A8AAAAABDBD:#515149496565:#31312D2D3C3C:#D4D434346C6C:'
        '#2C2CD8D84545:#FDFDE8E83A3A:#8F8FB9B9F9F9:#A4A47979E2E2:#ABABD3D3EBEB:'
        '#9D9D8B8BBDBD:#505048486868:#101008081414'
    ),
    'Rxvt': (
        '#000000000000:#cdcd00000000:#0000cdcd0000:#cdcdcdcd0000:#00000000cdcd:'
        '#cdcd0000cdcd:#0000cdcdcdcd:#fafaebebd7d7:#404040404040:#ffff00000000:'
        '#0000ffff0000:#ffffffff0000:#00000000ffff:#ffff0000ffff:#0000ffffffff:'
        '#ffffffffffff:#ffffffffffff:#000000000000'
    ),
    'Sea Shells': (
        '#171738384C4C:#D1D150502323:#02027C7C9B9B:#FCFCA0A02F2F:#1E1E49495050:'
        '#6868D3D3F1F1:#5050A3A3B5B5:#DEDEB8B88D8D:#42424B4B5252:#D3D386867777:'
        '#61618C8C9898:#FDFDD2D29E9E:#1B1BBCBCDDDD:#BBBBE3E3EEEE:#8686ABABB3B3:'
        '#FEFEE3E3CDCD:#DEDEB8B88D8D:#080813131A1A'
    ),
    'Seafoam Pastel': (
        '#757575757575:#82825D5D4D4D:#71718C8C6161:#ADADA1A16D6D:#4D4D7B7B8282:'
        '#8A8A71716767:#717193939393:#E0E0E0E0E0E0:#8A8A8A8A8A8A:#CFCF93937979:'
        '#9898D9D9AAAA:#FAFAE7E79D9D:#7979C3C3CFCF:#D6D6B2B2A1A1:#ADADE0E0E0E0:'
        '#E0E0E0E0E0E0:#D3D3E7E7D3D3:#242434343434'
    ),
    'Seti': (
        '#323232323232:#C2C228283232:#8E8EC4C43D3D:#E0E0C6C64F4F:#4343A5A5D5D5:'
        '#8B8B5757B5B5:#8E8EC4C43D3D:#EEEEEEEEEEEE:#323232323232:#C2C228283232:'
        '#8E8EC4C43D3D:#E0E0C6C64F4F:#4343A5A5D5D5:#8B8B5757B5B5:#8E8EC4C43D3D:'
        '#FFFFFFFFFFFF:#CACACECECDCD:#111112121313'
    ),
    'Shaman': (
        '#010120202626:#B1B12F2F2C2C:#0000A9A94040:#5D5D8A8AA9A9:#444499998585:'
        '#000059599C9C:#5C5C7E7E1919:#404055555454:#373743435050:#FFFF42424242:'
        '#2A2AEAEA5E5E:#8D8DD3D3FDFD:#6161D4D4B9B9:#12129898FFFF:#9898CFCF2828:'
        '#5858FAFAD6D6:#404055555555:#000010101414'
    ),
    'Slate': (
        '#212121212121:#E1E1A7A7BFBF:#8080D7D77878:#C4C4C9C9BFBF:#25254A4A4949:'
        '#A3A38080D3D3:#1414ABAB9C9C:#0202C4C4E0E0:#FFFFFFFFFFFF:#FFFFCCCCD8D8:'
        '#BDBDFFFFA8A8:#D0D0CBCBC9C9:#7979AFAFD2D2:#C4C4A7A7D8D8:#8B8BDEDEE0E0:'
        '#E0E0E0E0E0E0:#3434B0B0D2D2:#212121212121'
    ),
    'Smyck': (
        '#000000000000:#B7B741413131:#7D7DA9A90000:#C4C4A4A40000:#6262A3A3C4C4:'
        '#B9B98A8ACCCC:#202073738383:#A0A0A0A0A0A0:#7A7A7A7A7A7A:#D6D683837B7B:'
        '#C4C4F0F03636:#FEFEE1E14D4D:#8D8DCFCFF0F0:#F7F79999FFFF:#6969D9D9CFCF:'
        '#F7F7F7F7F7F7:#F7F7F7F7F7F7:#1B1B1B1B1B1B'
    ),
    'Soft Server': (
        '#000000000000:#A1A168686969:#9999A5A56969:#A2A290906969:#6A6A8F8FA3A3:'
        '#69697171A3A3:#6B6BA4A48F8F:#9999A3A3A2A2:#66666C6C6B6B:#DCDC5B5B5F5F:'
        '#BFBFDEDE5454:#DEDEB3B35F5F:#6262B1B1DFDF:#5F5F6E6EDEDE:#6464E3E39C9C:'
        '#D1D1DFDFDEDE:#9999A3A3A2A2:#242426262626'
    ),
    'Solarized Darcula': (
        '#252529292A2A:#F2F248484040:#626296965555:#B6B688880000:#20207575C7C7:'
        '#79797F7FD4D4:#151596968D8D:#D2D2D8D8D9D9:#252529292A2A:#F2F248484040:'
        '#626296965555:#B6B688880000:#20207575C7C7:#79797F7FD4D4:#151596968D8D:'
        '#D2D2D8D8D9D9:#D2D2D8D8D9D9:#3D3D3F3F4141'
    ),
    'Solarized Dark Higher Contrast': (
        '#000027273131:#D0D01B1B2424:#6B6BBEBE6C6C:#A5A577770505:#20207575C7C7:'
        '#C6C61B1B6E6E:#252591918585:#E9E9E2E2CBCB:#000063638888:#F4F415153B3B:'
        '#5050EEEE8484:#B1B17E7E2828:#17178D8DC7C7:#E1E14D4D8E8E:#0000B2B29E9E:'
        '#FCFCF4F4DCDC:#9B9BC1C1C2C2:#00001E1E2626'
    ),
    'Solarized Dark': (
        '#000027273131:#D0D01B1B2424:#727289890505:#A5A577770505:#20207575C7C7:'
        '#C6C61B1B6E6E:#252591918585:#E9E9E2E2CBCB:#00001E1E2626:#BDBD36361212:'
        '#46465A5A6161:#525267676F6F:#707081818383:#58585656B9B9:#818190908F8F:'
        '#FCFCF4F4DCDC:#707081818383:#00001E1E2626'
    ),
    'Solarized Light': (
        '#000027273131:#D0D01B1B2424:#727289890505:#A5A577770505:#20207575C7C7:'
        '#C6C61B1B6E6E:#252591918585:#E9E9E2E2CBCB:#00001E1E2626:#BDBD36361212:'
        '#46465A5A6161:#525267676F6F:#707081818383:#58585656B9B9:#818190908F8F:'
        '#FCFCF4F4DCDC:#525267676F6F:#FCFCF4F4DCDC'
    ),
    'Space Gray Eighties': (
        '#151517171C1C:#ECEC5F5F6767:#8080A7A76363:#FDFDC2C25353:#54548585C0C0:'
        '#BFBF8383C0C0:#5757C2C2C0C0:#EEEEECECE7E7:#555555555555:#FFFF69697373:'
        '#9393D3D39393:#FFFFD1D15656:#4D4D8383D0D0:#FFFF5555FFFF:#8383E8E8E4E4:'
        '#FFFFFFFFFFFF:#BDBDB9B9AEAE:#212121212121'
    ),
    'Space Gray': (
        '#000000000000:#AFAF4B4B5757:#8787B2B27979:#E5E5C0C07878:#7C7C8F8FA3A3:'
        '#A3A379799696:#8484A6A6A4A4:#B2B2B8B8C2C2:#000000000000:#AFAF4B4B5757:'
        '#8787B2B27979:#E5E5C0C07878:#7C7C8F8FA3A3:#A3A379799696:#8484A6A6A4A4:'
        '#FFFFFEFEFEFE:#B2B2B8B8C2C2:#202023232C2C'
    ),
    'Spacedust': (
        '#6E6E52524646:#E3E35A5A0000:#5C5CABAB9696:#E3E3CDCD7B7B:#0E0E54548B8B:'
        '#E3E35A5A0000:#0606AFAFC7C7:#F0F0F1F1CECE:#67674C4C3131:#FFFF8A8A3939:'
        '#ADADCACAB8B8:#FFFFC7C77777:#6767A0A0CDCD:#FFFF8A8A3939:#8383A6A6B3B3:'
        '#FEFEFFFFF0F0:#ECECEFEFC1C1:#0A0A1E1E2424'
    ),
    'Spixel': (
        '#000000000000:#A4A43E3E6363:#8A8AB5B54444:#F3F39A9A2626:#51518B8BA3A3:'
        '#97977070B3B3:#5B5BA6A6A5A5:#D3D3D7D7CFCF:#707073736D6D:#E8E84A4A8484:'
        '#A7A7E3E34646:#F1F1C5C58B8B:#7373B9B9D6D6:#C5E49865E6E6:#8282D9D9D8D8:'
        '#EEEEEEEEECEC:#FFFFFFFFFFFF:#262626262222'
    ),
    'Spring': (
        '#000000000000:#FFFF4C4C8383:#1F1F8C8C3A3A:#1F1FC9C95A5A:#1C1CD2D2EEEE:'
        '#89895959A8A8:#3E3E99999F9F:#FFFFFEFEFEFE:#000000000000:#FFFF00002121:'
        '#1F1FC2C23131:#D4D4B7B70606:#1515A9A9FDFD:#89895959A8A8:#3E3E99999F9F:'
        '#FFFFFEFEFEFE:#4D4D4D4D4C4C:#FFFFFFFFFFFF'
    ),
    'Square': (
        '#050505050505:#E9E989897C7C:#B6B637377D7D:#ECECEBEBBEBE:#A9A9CDCDEBEB:'
        '#757550507B7B:#C9C9CACAECEC:#F2F2F2F2F2F2:#141414141414:#F9F992928686:'
        '#C3C3F7F78686:#FCFCFBFBCCCC:#B6B6DEDEFBFB:#ADAD7F7FA8A8:#D7D7D9D9FCFC:'
        '#E2E2E2E2E2E2:#ACACACACABAB:#1A1A1A1A1A1A'
    ),
    'Sundried': (
        '#30302B2B2A2A:#A6A646463D3D:#575776764444:#9C9C5F5F2A2A:#48485A5A9898:'
        '#858545455151:#9C9C81814E4E:#C8C8C8C8C8C8:#4D4D4D4D4747:#AAAA00000C0C:'
        '#12128C8C2020:#FCFC6A6A2020:#78789898F7F7:#FCFC8989A0A0:#FAFAD3D38484:'
        '#FFFFFEFEFEFE:#C8C8C8C8C8C8:#1A1A18181818'
    ),
    'Symphonic': (
        '#000000000000:#DCDC32322F2F:#5656DBDB3A3A:#FFFF84840000:#00008484D4D4:'
        '#B7B72929D9D9:#CCCCCCCCFFFF:#FFFFFFFFFFFF:#1B1B1D1D2121:#DCDC32322F2F:'
        '#5656DBDB3A3A:#FFFF84840000:#00008484D4D4:#B7B72929D9D9:#CCCCCCCCFFFF:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#000000000000'
    ),
    'Tango': (
        '#000000000000:#cccc00000000:#4e4e9a9a0606:#c4c4a0a00000:#34346565a4a4:'
        '#757550507b7b:#060698209a9a:#d3d3d7d7cfcf:#555557575353:#efef29292929:'
        '#8a8ae2e23434:#fcfce9e94f4f:#72729f9fcfcf:#adad7f7fa8a8:#3434e2e2e2e2:'
        '#eeeeeeeeecec:#ffffffffffff:#000000000000'
    ),
    'Teerb': (
        '#1C1C1C1C1C1C:#D6D686868686:#AEAED6D68686:#D7D7AFAF8787:#8686AEAED6D6:'
        '#D6D6AEAED6D6:#8A8ADBDBB4B4:#D0D0D0D0D0D0:#1C1C1C1C1C1C:#D6D686868686:'
        '#AEAED6D68686:#E4E4C9C9AFAF:#8686AEAED6D6:#D6D6AEAED6D6:#B1B1E7E7DDDD:'
        '#EFEFEFEFEFEF:#D0D0D0D0D0D0:#262626262626'
    ),
    'Terminal Basic': (
        '#000000000000:#999900000000:#0000A6A60000:#999999990000:#00000000B2B2:'
        '#B2B20000B2B2:#0000A6A6B2B2:#BFBFBFBFBFBF:#666666666666:#E5E500000000:'
        '#0000D9D90000:#E5E5E5E50000:#00000000FFFF:#E5E50000E5E5:#0000E5E5E5E5:'
        '#E5E5E5E5E5E5:#000000000000:#FFFFFFFFFFFF'
    ),
    'Thayer Bright': (
        '#1B1B1D1D1E1E:#F9F926267272:#4D4DF7F74040:#F3F3FDFD2121:#26265656D6D6:'
        '#8C8C5454FEFE:#3737C8C8B4B4:#CCCCCCCCC6C6:#505053535454:#FFFF59599595:'
        '#B6B6E3E35454:#FEFEEDED6C6C:#3F3F7878FFFF:#9E9E6F6FFEFE:#2323CECED4D4:'
        '#F8F8F8F8F2F2:#F8F8F8F8F8F8:#1B1B1D1D1E1E'
    ),
    'Tomorrow Night Blue': (
        '#000000000000:#FFFF9D9DA3A3:#D1D1F1F1A9A9:#FFFFEEEEADAD:#BBBBDADAFFFF:'
        '#EBEBBBBBFFFF:#9999FFFFFFFF:#FFFFFEFEFEFE:#000000000000:#FFFF9C9CA3A3:'
        '#D0D0F0F0A8A8:#FFFFEDEDACAC:#BABADADAFFFF:#EBEBBABAFFFF:#9999FFFFFFFF:'
        '#FFFFFEFEFEFE:#FFFFFEFEFEFE:#000024245151'
    ),
    'Tomorrow Night Bright': (
        '#000000000000:#D5D54E4E5353:#B9B9CACA4949:#E7E7C5C54747:#7979A6A6DADA:'
        '#C3C39797D8D8:#7070C0C0B1B1:#FFFFFEFEFEFE:#000000000000:#D4D44D4D5353:'
        '#B9B9C9C94949:#E6E6C4C44646:#7979A6A6DADA:#C3C39696D7D7:#7070C0C0B1B1:'
        '#FFFFFEFEFEFE:#E9E9E9E9E9E9:#000000000000'
    ),
    'Tomorrow Night Eighties': (
        '#000000000000:#F2F277777979:#9999CCCC9999:#FFFFCCCC6666:#66669999CCCC:'
        '#CCCC9999CCCC:#6666CCCCCCCC:#FFFFFEFEFEFE:#000000000000:#F1F177777979:'
        '#9999CCCC9999:#FFFFCCCC6666:#66669999CCCC:#CCCC9999CCCC:#6666CCCCCCCC:'
        '#FFFFFEFEFEFE:#CCCCCCCCCCCC:#2C2C2C2C2C2C'
    ),
    'Tomorrow Night': (
        '#000000000000:#CCCC66666666:#B5B5BDBD6868:#F0F0C6C67474:#8181A2A2BEBE:'
        '#B2B29393BBBB:#8A8ABEBEB7B7:#FFFFFEFEFEFE:#000000000000:#CCCC66666666:'
        '#B5B5BDBD6868:#F0F0C5C57474:#8080A1A1BDBD:#B2B29494BABA:#8A8ABDBDB6B6:'
        '#FFFFFEFEFEFE:#C5C5C8C8C6C6:#1D1D1F1F2121'
    ),
    'Tomorrow': (
        '#000000000000:#C8C828282828:#71718C8C0000:#EAEAB7B70000:#41417171AEAE:'
        '#89895959A8A8:#3E3E99999F9F:#FFFFFEFEFEFE:#000000000000:#C8C828282828:'
        '#70708B8B0000:#E9E9B6B60000:#41417070AEAE:#89895858A7A7:#3D3D99999F9F:'
        '#FFFFFEFEFEFE:#4D4D4D4D4C4C:#FFFFFFFFFFFF'
    ),
    'Toy Chest': (
        '#2C2C3F3F5757:#BEBE2D2D2626:#191991917171:#DADA8E8E2626:#32325D5D9696:'
        '#8A8A5D5DDBDB:#3535A0A08F8F:#2323D0D08282:#323268688989:#DDDD59594343:'
        '#3030CFCF7B7B:#E7E7D7D74B4B:#3333A5A5D9D9:#ADAD6B6BDCDC:#4141C3C3ADAD:'
        '#D4D4D4D4D4D4:#3030CFCF7B7B:#232336364A4A'
    ),
    'Treehouse': (
        '#323212120000:#B1B127270E0E:#4444A9A90000:#A9A981810B0B:#575784849999:'
        '#969636363C3C:#B2B259591D1D:#77776B6B5353:#424236362525:#EDED5C5C2020:'
        '#5555F2F23737:#F1F1B7B73131:#8585CFCFECEC:#E0E04B4B5A5A:#F0F07D7D1414:'
        '#FFFFC8C80000:#77776B6B5353:#191919191919'
    ),
    'Twilight': (
        '#141414141414:#C0C06C6C4343:#AFAFB9B97979:#C2C2A8A86C6C:#444446464949:'
        '#B4B4BEBE7B7B:#777782828484:#FEFEFFFFD3D3:#262626262626:#DDDD7C7C4C4C:'
        '#CBCBD8D88C8C:#E1E1C4C47D7D:#5A5A5D5D6161:#D0D0DBDB8E8E:#8A8A98989A9A:'
        '#FEFEFFFFD3D3:#FEFEFFFFD3D3:#141414141414'
    ),
    'Urple': (
        '#000000000000:#AFAF42425B5B:#3737A3A31515:#ACAC5B5B4141:#55554D4D9A9A:'
        '#6C6C3B3BA1A1:#808080808080:#878779799C9C:#5C5C31312525:#FFFF63638787:'
        '#2828E5E51F1F:#F0F080806161:#85857979EDED:#A0A05D5DEEEE:#EAEAEAEAEAEA:'
        '#BFBFA3A3FFFF:#868679799A9A:#1B1B1B1B2323'
    ),
    'Vaughn': (
        '#242423234F4F:#707050505050:#6060B4B48A8A:#DFDFAFAF8F8F:#55555555FFFF:'
        '#F0F08C8CC3C3:#8C8CD0D0D3D3:#707090908080:#707090908080:#DCDCA3A3A3A3:'
        '#6060B4B48A8A:#F0F0DFDFAFAF:#55555555FFFF:#ECEC9393D3D3:#9393E0E0E3E3:'
        '#FFFFFFFFFFFF:#DCDCDCDCCCCC:#252523234E4E'
    ),
    'Vibrant Ink': (
        '#878787878787:#FFFF66660000:#CCCCFFFF0404:#FFFFCCCC0000:#4444B3B3CCCC:'
        '#99993333CCCC:#4444B3B3CCCC:#F5F5F5F5F5F5:#555555555555:#FFFF00000000:'
        '#0000FFFF0000:#FFFFFFFF0000:#00000000FFFF:#FFFF0000FFFF:#0000FFFFFFFF:'
        '#E5E5E5E5E5E5:#FFFFFFFFFFFF:#000000000000'
    ),
    'Warm Neon': (
        '#000000000000:#E2E243434545:#3838B1B13939:#DADAE1E14545:#42426060C5C5:'
        '#F8F81F1FFBFB:#2929BABAD3D3:#D0D0B8B8A3A3:#FDFDFCFCFCFC:#E8E86F6F7171:'
        '#9B9BC0C08F8F:#DDDDD9D97979:#7A7A9090D5D5:#F6F67474B9B9:#5E5ED1D1E4E4:'
        '#D8D8C8C8BBBB:#AFAFDADAB6B6:#3F3F3F3F3F3F'
    ),
    'Wez': (
        '#000000000000:#CCCC55555555:#5555CCCC5555:#CDCDCDCD5555:#54545555CBCB:'
        '#CCCC5555CCCC:#7A7ACACACACA:#CCCCCCCCCCCC:#555555555555:#FFFF55555555:'
        '#5555FFFF5555:#FFFFFFFF5555:#55555555FFFF:#FFFF5555FFFF:#5555FFFFFFFF:'
        '#FFFFFFFFFFFF:#B3B3B3B3B3B3:#000000000000'
    ),
    'Wild Cherry': (
        '#000005050606:#D9D940408585:#2A2AB2B25050:#FFFFD1D16F6F:#88883C3CDCDC:'
        '#ECECECECECEC:#C1C1B8B8B7B7:#FFFFF8F8DDDD:#00009C9CC9C9:#DADA6B6BABAB:'
        '#F4F4DBDBA5A5:#EAEAC0C06666:#2F2F8B8BB9B9:#AEAE63636B6B:#FFFF91919D9D:'
        '#E4E483838D8D:#D9D9FAFAFFFF:#1F1F16162626'
    ),
    'Wombat': (
        '#000000000000:#FFFF60605A5A:#B1B1E8E86969:#EAEAD8D89C9C:#5D5DA9A9F6F6:'
        '#E8E86A6AFFFF:#8282FFFFF6F6:#DEDED9D9CECE:#313131313131:#F5F58B8B7F7F:'
        '#DCDCF8F88F8F:#EEEEE5E5B2B2:#A5A5C7C7FFFF:#DDDDAAAAFFFF:#B6B6FFFFF9F9:'
        '#FEFEFFFFFEFE:#DEDED9D9CECE:#171717171717'
    ),
    'Wryan': (
        '#333333333333:#8C8C46466565:#282873737373:#7C7C7C7C9999:#393955557373:'
        '#5E5E46468C8C:#313165658C8C:#89899C9CA1A1:#3D3D3D3D3D3D:#BFBF4D4D8080:'
        '#5353A6A6A6A6:#9E9E9E9ECBCB:#47477A7AB3B3:#7E7E6262B3B3:#60609696BFBF:'
        '#C0C0C0C0C0C0:#999999999393:#101010101010'
    ),
    'Xterm': (
        '#000000000000:#cdcb00000000:#0000cdcb0000:#cdcbcdcb0000:#1e1a908fffff:'
        '#cdcb0000cdcb:#0000cdcbcdcb:#e5e2e5e2e5e2:#4ccc4ccc4ccc:#ffff00000000:'
        '#0000ffff0000:#ffffffff0000:#46458281b4ae:#ffff0000ffff:#0000ffffffff:'
        '#ffffffffffff:#ffffffffffff:#000000000000'
    ),
    'Zenburn': (
        '#4D4D4D4D4D4D:#707050505050:#6060B4B48A8A:#F0F0DFDFAFAF:#505060607070:'
        '#DCDC8C8CC3C3:#8C8CD0D0D3D3:#DCDCDCDCCCCC:#707090908080:#DCDCA3A3A3A3:'
        '#C3C3BFBF9F9F:#E0E0CFCF9F9F:#9494BFBFF3F3:#ECEC9393D3D3:#9393E0E0E3E3:'
        '#FFFFFFFFFFFF:#DCDCDCDCCCCC:#3F3F3F3F3F3F'
    ),
    'Aci': (
        '#363636363636:#FFFF08088383:#8383FFFF0808:#FFFF83830808:#08088383FFFF:'
        '#83830808FFFF:#0808FFFF8383:#B6B6B6B6B6B6:#424242424242:#FFFF1E1E8E8E:'
        '#8E8EFFFF1E1E:#FFFF8E8E1E1E:#1E1E8E8EFFFF:#8E8E1E1EFFFF:#1E1EFFFF8E8E:'
        '#C2C2C2C2C2C2:#0D0D19192626:#B4B4E1E1FDFD'
    ),
    'Aco': (
        '#3F3F3F3F3F3F:#FFFF08088383:#8383FFFF0808:#FFFF83830808:#08088383FFFF:'
        '#83830808FFFF:#0808FFFF8383:#BEBEBEBEBEBE:#474747474747:#FFFF1E1E8E8E:'
        '#8E8EFFFF1E1E:#FFFF8E8E1E1E:#1E1E8E8EFFFF:#8E8E1E1EFFFF:#1E1EFFFF8E8E:'
        '#C4C4C4C4C4C4:#1F1F13130505:#B4B4E1E1FDFD'
    ),
    'Azu': (
        '#000000000000:#ACAC6D6D7474:#7474ACAC6D6D:#ACACA4A46D6D:#6D6D7474ACAC:'
        '#A4A46D6DACAC:#6D6DACACA4A4:#E6E6E6E6E6E6:#262626262626:#D6D6B8B8BCBC:'
        '#BCBCD6D6B8B8:#D6D6D3D3B8B8:#B8B8BCBCD6D6:#D3D3B8B8D6D6:#B8B8D6D6D3D3:'
        '#FFFFFFFFFFFF:#090911111A1A:#D9D9E6E6F2F2'
    ),
    'Bim': (
        '#2C2C24242323:#F5F55757A0A0:#A9A9EEEE5555:#F5F5A2A25555:#5E5EA2A2ECEC:'
        '#A9A95757ECEC:#5E5EEEEEA0A0:#919189898888:#919189898888:#F5F57979B2B2:'
        '#BBBBEEEE7878:#F5F5B3B37878:#8181B3B3ECEC:#BBBB7979ECEC:#8181EEEEB2B2:'
        '#F5F5EEEEECEC:#010128284949:#A9A9BEBED8D8'
    ),
    'Cai': (
        '#000000000000:#CACA27274D4D:#4D4DCACA2727:#CACAA4A42727:#27274D4DCACA:'
        '#A4A42727CACA:#2727CACAA4A4:#808080808080:#808080808080:#E9E98D8DA3A3:'
        '#A3A3E9E98D8D:#E9E9D4D48D8D:#8D8DA3A3E9E9:#D4D48D8DE9E9:#8D8DE9E9D4D4:'
        '#FFFFFFFFFFFF:#090911111A1A:#D9D9E6E6F2F2'
    ),
    'Elementary': (
        '#303030303030:#E1E132321A1A:#6A6AB0B01717:#FFFFC0C00505:#00004F4F9E9E:'
        '#ECEC00004848:#2A2AA7A7E7E7:#F2F2F2F2F2F2:#5D5D5D5D5D5D:#FFFF36361E1E:'
        '#7B7BC9C91F1F:#FFFFD0D00A0A:#00007171FFFF:#FFFF1D1D6262:#4B4BB8B8FDFD:'
        '#A0A02020F0F0:#101010101010:#F2F2F2F2F2F2'
    ),
    'Elic': (
        '#303030303030:#E1E132321A1A:#6A6AB0B01717:#FFFFC0C00505:#72729F9FCFCF:'
        '#ECEC00004848:#F2F2F2F2F2F2:#2A2AA7A7E7E7:#5D5D5D5D5D5D:#FFFF36361E1E:'
        '#7B7BC9C91F1F:#FFFFD0D00A0A:#00007171FFFF:#FFFF1D1D6262:#4B4BB8B8FDFD:'
        '#A0A02020F0F0:#4A4A45453E3E:#F2F2F2F2F2F2'
    ),
    'Elio': (
        '#303030303030:#E1E132321A1A:#6A6AB0B01717:#FFFFC0C00505:#72729F9FCFCF:'
        '#ECEC00004848:#2A2AA7A7E7E7:#F2F2F2F2F2F2:#5D5D5D5D5D5D:#FFFF36361E1E:'
        '#7B7BC9C91F1F:#FFFFD0D00A0A:#00007171FFFF:#FFFF1D1D6262:#4B4BB8B8FDFD:'
        '#A0A02020F0F0:#04041A1A3B3B:#F2F2F2F2F2F2'
    ),
    'Freya': (
        '#070736364242:#DCDC32322F2F:#858599990000:#B5B589890000:#26268B8BD2D2:'
        '#ECEC00004848:#2A2AA1A19898:#9494A3A3A5A5:#58586E6E7575:#CBCB4B4B1616:'
        '#858599990000:#B5B589890000:#26268B8BD2D2:#D3D336368282:#2A2AA1A19898:'
        '#6C6C7171C4C4:#25252E2E3232:#9494A3A3A5A5'
    ),
    'Gruvbox Dark': (
        '#66665C5C5454:#FBFB49493434:#8383A5A59898:#D7D799992121:#B1B162628686:'
        '#454585858888:#B8B8BBBB2626:#D6D65D5D0E0E:#A8A899998484:#FBFB49493434:'
        '#8E8EC0C07C7C:#FAFABDBD2F2F:#D3D386869B9B:#68689D9D6A6A:#989897971A1A:'
        '#FEFE80801919:#EBEBDBDBB2B2:#282828282828'
    ),
    'Hemisu Dark': (
        '#444444444444:#FFFF00005454:#B1B1D6D63030:#9D9D89895E5E:#6767BEBEE3E3:'
        '#B5B57676BCBC:#56569A9A9F9F:#EDEDEDEDEDED:#777777777777:#D6D65E5E7575:'
        '#BABAFFFFAAAA:#ECECE1E1C8C8:#9F9FD3D3E5E5:#DEDEB3B3DFDF:#B6B6E0E0E5E5:'
        '#FFFFFFFFFFFF:#000000000000:#FFFFFFFFFFFF'
    ),
    'Hemisu Light': (
        '#777777777777:#FFFF00005555:#737391910000:#50503D3D1515:#535380809191:'
        '#5B5B34345E5E:#535380809191:#999999999999:#999999999999:#D6D65E5E7676:'
        '#9C9CC7C70000:#949475755555:#9D9DB3B3CDCD:#A1A18484A4A4:#8585B2B2AAAA:'
        '#BABABABABABA:#EFEFEFEFEFEF:#444444444444'
    ),
    'Jup': (
        '#000000000000:#DDDD00006F6F:#6F6FDDDD0000:#DDDD6F6F0000:#00006F6FDDDD:'
        '#6F6F0000DDDD:#0000DDDD6F6F:#F2F2F2F2F2F2:#7D7D7D7D7D7D:#FFFF7474B9B9:'
        '#B9B9FFFF7474:#FFFFB9B97474:#7474B9B9FFFF:#B9B97474FFFF:#7474FFFFB9B9:'
        '#FFFFFFFFFFFF:#757584848080:#232347476A6A'
    ),
    'Mar': (
        '#000000000000:#B5B540407B7B:#7B7BB5B54040:#B5B57B7B4040:#40407B7BB5B5:'
        '#7B7B4040B5B5:#4040B5B57B7B:#F8F8F8F8F8F8:#737373737373:#CDCD7373A0A0:'
        '#A0A0CDCD7373:#CDCDA0A07373:#7373A0A0CDCD:#A0A07373CDCD:#7373CDCDA0A0:'
        '#FFFFFFFFFFFF:#FFFFFFFFFFFF:#232347476A6A'
    ),
    'Material': (
        '#070736364141:#EBEB60606B6B:#C3C3E8E88D8D:#F7F7EBEB9595:#8080CBCBC3C3:'
        '#FFFF24249090:#AEAEDDDDFFFF:#FFFFFFFFFFFF:#00002B2B3636:#EBEB60606B6B:'
        '#C3C3E8E88D8D:#F7F7EBEB9595:#7D7DC6C6BFBF:#6C6C7171C3C3:#343443434D4D:'
        '#FFFFFFFFFFFF:#1E1E28282C2C:#C3C3C7C7D1D1'
    ),
    'Miu': (
        '#000000000000:#B8B87A7A7A7A:#7A7AB8B87A7A:#B8B8B8B87A7A:#7A7A7A7AB8B8:'
        '#B8B87A7AB8B8:#7A7AB8B8B8B8:#D9D9D9D9D9D9:#262626262626:#DBDBBDBDBDBD:'
        '#BDBDDBDBBDBD:#DBDBDBDBBDBD:#BDBDBDBDDBDB:#DBDBBDBDDBDB:#BDBDDBDBDBDB:'
        '#FFFFFFFFFFFF:#0D0D19192626:#D9D9E6E6F2F2'
    ),
    'Monokai dark': (
        '#757571715E5E:#F9F926267272:#A6A6E2E22E2E:#F4F4BFBF7575:#6666D9D9EFEF:'
        '#AEAE8181FFFF:#2A2AA1A19898:#F9F9F8F8F5F5:#272728282222:#F9F926267272:'
        '#A6A6E2E22E2E:#F4F4BFBF7575:#6666D9D9EFEF:#AEAE8181FFFF:#2A2AA1A19898:'
        '#F8F8F8F8F2F2:#272728282222:#F8F8F8F8F2F2'
    ),
    'Nep': (
        '#000000000000:#DDDD6F6F0000:#0000DDDD6F6F:#6F6FDDDD0000:#6F6F0000DDDD:'
        '#DDDD00006F6F:#00006F6FDDDD:#F2F2F2F2F2F2:#7D7D7D7D7D7D:#FFFFB9B97474:'
        '#7474FFFFB9B9:#B9B9FFFF7474:#B9B97474FFFF:#FFFF7474B9B9:#7474B9B9FFFF:'
        '#FFFFFFFFFFFF:#757584848080:#232347476A6A'
    ),
    'One Light': (
        '#000000000000:#DADA3E3E3939:#414193933E3E:#858555550404:#31315E5EEEEE:'
        '#939300009292:#0E0E6F6FADAD:#8E8E8F8F9696:#2A2A2B2B3232:#DADA3E3E3939:'
        '#414193933E3E:#858555550404:#31315E5EEEEE:#939300009292:#0E0E6F6FADAD:'
        '#FFFFFEFEFEFE:#F8F8F8F8F8F8:#2A2A2B2B3232'
    ),
    'Pali': (
        '#0A0A0A0A0A0A:#ABAB8F8F7474:#7474ABAB8F8F:#8F8FABAB7474:#8F8F7474ABAB:'
        '#ABAB74748F8F:#74748F8FABAB:#F2F2F2F2F2F2:#5D5D5D5D5D5D:#FFFF1D1D6262:'
        '#9C9CC3C3AFAF:#FFFFD0D00A0A:#AFAF9C9CC3C3:#FFFF1D1D6262:#4B4BB8B8FDFD:'
        '#A0A02020F0F0:#23232E2E3737:#D9D9E6E6F2F2'
    ),
    'Peppermint': (
        '#353535353535:#E6E645456969:#8989D2D28787:#DADAB7B75252:#43439E9ECFCF:'
        '#D9D96161DCDC:#6464AAAAAFAF:#B3B3B3B3B3B3:#535353535353:#E4E485859A9A:'
        '#A2A2CCCCA1A1:#E1E1E3E38787:#6F6FBBBBE2E2:#E5E58686E7E7:#9696DCDCDADA:'
        '#DEDEDEDEDEDE:#000000000000:#C7C7C7C7C7C7'
    ),
    'Sat': (
        '#000000000000:#DDDD00000707:#0707DDDD0000:#DDDDD6D60000:#00000707DDDD:'
        '#D6D60000DDDD:#0000DDDDD6D6:#F2F2F2F2F2F2:#7D7D7D7D7D7D:#FFFF74747878:'
        '#7878FFFF7474:#FFFFFAFA7474:#74747878FFFF:#FAFA7474FFFF:#7474FFFFFAFA:'
        '#FFFFFFFFFFFF:#757584848080:#232347476A6A'
    ),
    'Shel': (
        '#2C2C24242323:#ABAB24246363:#6C6CA3A32323:#ABAB64642323:#2C2C6464A2A2:'
        '#6C6C2424A2A2:#2C2CA3A36363:#919189898888:#919189898888:#F5F58888B9B9:'
        '#C2C2EEEE8686:#F5F5BABA8686:#8F8FBABAECEC:#C2C28888ECEC:#8F8FEEEEB9B9:'
        '#F5F5EEEEECEC:#2A2A20201F1F:#48488282CDCD'
    ),
    'Tin': (
        '#000000000000:#8D8D53534E4E:#4E4E8D8D5353:#88888D8D4E4E:#53534E4E8D8D:'
        '#8D8D4E4E8888:#4E4E88888D8D:#FFFFFFFFFFFF:#000000000000:#B5B57D7D7878:'
        '#7878B5B57D7D:#B0B0B5B57878:#7D7D7878B5B5:#B5B57878B0B0:#7878B0B0B5B5:'
        '#FFFFFFFFFFFF:#2E2E2E2E3535:#FFFFFFFFFFFF'
    ),
    'Ura': (
        '#000000000000:#C2C21B1B6F6F:#6F6FC2C21B1B:#C2C26F6F1B1B:#1B1B6F6FC2C2:'
        '#6F6F1B1BC2C2:#1B1BC2C26F6F:#808080808080:#808080808080:#EEEE8484B9B9:'
        '#B9B9EEEE8484:#EEEEB9B98484:#8484B9B9EEEE:#B9B98484EEEE:#8484EEEEB9B9:'
        '#E5E5E5E5E5E5:#FEFEFFFFEEEE:#232347476A6A'
    ),
    'Vag': (
        '#303030303030:#A8A871713939:#3939A8A87171:#7171A8A83939:#71713939A8A8:'
        '#A8A839397171:#39397171A8A8:#8A8A8A8A8A8A:#494949494949:#B0B076763B3B:'
        '#3B3BB0B07676:#7676B0B03B3B:#76763B3BB0B0:#B0B03B3B7676:#3B3B7676B0B0:'
        '#CFCFCFCFCFCF:#19191F1F1D1D:#D9D9E6E6F2F2'
    ),
}
