/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.internal.AbstractBindingProcessor;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.BoundProviderFactory;
import com.google.inject.internal.ConstantFactory;
import com.google.inject.internal.ConstructorBindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.ExposedBindingImpl;
import com.google.inject.internal.ExposedKeyFactory;
import com.google.inject.internal.FactoryProxy;
import com.google.inject.internal.Initializable;
import com.google.inject.internal.Initializer;
import com.google.inject.internal.InstanceBindingImpl;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.InternalFactoryToInitializableAdapter;
import com.google.inject.internal.LinkedBindingImpl;
import com.google.inject.internal.LinkedProviderBindingImpl;
import com.google.inject.internal.ProcessedBindingData;
import com.google.inject.internal.ProviderInstanceBindingImpl;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.Scoping;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.util.Set;

final class BindingProcessor
extends AbstractBindingProcessor {
    private final Initializer initializer;

    BindingProcessor(Errors errors, Initializer initializer, ProcessedBindingData bindingData) {
        super(errors, bindingData);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        Class<T> rawType = command.getKey().getTypeLiteral().getRawType();
        if (Void.class.equals(rawType)) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getUserSuppliedProvider() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        return (Boolean)command.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)command){

            @Override
            public Boolean visit(ConstructorBinding<? extends T> binding2) {
                this.prepareBinding();
                try {
                    ConstructorBindingImpl onInjector = ConstructorBindingImpl.create(BindingProcessor.this.injector, this.key, binding2.getConstructor(), this.source, this.scoping, BindingProcessor.this.errors, false, false);
                    this.scheduleInitialization(onInjector);
                    BindingProcessor.this.putBinding(onInjector);
                }
                catch (ErrorsException e2) {
                    BindingProcessor.this.errors.merge(e2.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            public Boolean visit(InstanceBinding<? extends T> binding2) {
                this.prepareBinding();
                Set<InjectionPoint> injectionPoints = binding2.getInjectionPoints();
                Object instance = binding2.getInstance();
                Initializable ref2 = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, binding2, this.source, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref2);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, injectionPoints, instance));
                return true;
            }

            @Override
            public Boolean visit(ProviderInstanceBinding<? extends T> binding2) {
                this.prepareBinding();
                javax.inject.Provider provider = binding2.getUserSuppliedProvider();
                Set<InjectionPoint> injectionPoints = binding2.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider, null, this.source, injectionPoints);
                InternalFactoryToInitializableAdapter factory = new InternalFactoryToInitializableAdapter(initializable, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding2));
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, provider, injectionPoints));
                return true;
            }

            @Override
            public Boolean visit(ProviderKeyBinding<? extends T> binding2) {
                this.prepareBinding();
                Key providerKey = binding2.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding2));
                BindingProcessor.this.bindingData.addCreationListener(boundProviderFactory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, boundProviderFactory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, providerKey));
                return true;
            }

            @Override
            public Boolean visit(LinkedKeyBinding<? extends T> binding2) {
                this.prepareBinding();
                Key linkedKey = binding2.getLinkedKey();
                if (this.key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding();
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, this.key, linkedKey, this.source);
                BindingProcessor.this.bindingData.addCreationListener(factory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, linkedKey));
                return true;
            }

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargetted) {
                return false;
            }

            @Override
            public Boolean visit(ExposedBinding<? extends T> binding2) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ConvertedConstantBinding<? extends T> binding2) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ProviderBinding<? extends T> binding2) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding2) {
                throw new IllegalStateException("BindingProcessor should override all visitations");
            }
        });
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key2 : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key2);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key2) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key2, privateElements);
        this.bindingData.addCreationListener(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>(this.injector, privateElements.getExposedSource(key2), key2, exposedKeyFactory, privateElements));
    }
}

