/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MonarchActionMessage
extends DOMMessage {
    private final Monarch.MonarchAction action;
    private final StringTemplate template;
    private final String monarchKey;
    private String tax;
    private String resultString;

    public MonarchActionMessage(Monarch.MonarchAction action, StringTemplate template, String monarchKey) {
        super(MonarchActionMessage.getXMLElementTagName());
        this.action = action;
        this.template = template;
        this.monarchKey = monarchKey;
        this.tax = null;
        this.resultString = null;
    }

    public MonarchActionMessage(Game game, Element element) {
        super(MonarchActionMessage.getXMLElementTagName());
        this.action = Enum.valueOf(Monarch.MonarchAction.class, element.getAttribute("action"));
        this.monarchKey = element.getAttribute("monarch");
        this.tax = element.getAttribute("tax");
        this.resultString = element.getAttribute("result");
        NodeList children = element.getChildNodes();
        if (children.getLength() == 1) {
            this.template = StringTemplate.label(" ");
            this.template.readFromXMLElement((Element)children.item(0));
        } else {
            this.template = null;
        }
    }

    public Monarch.MonarchAction getAction() {
        return this.action;
    }

    public StringTemplate getTemplate() {
        return this.template;
    }

    public String getMonarchKey() {
        return this.monarchKey;
    }

    public int getTax() {
        try {
            return Integer.parseInt(this.tax);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public MonarchActionMessage setTax(int tax) {
        this.tax = Integer.toString(tax);
        return this;
    }

    public boolean getResult() {
        return Boolean.parseBoolean(this.resultString);
    }

    public MonarchActionMessage setResult(boolean accept) {
        this.resultString = Boolean.toString(accept);
        return this;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        return server.getInGameController().monarchAction(serverPlayer, this.action, this.getResult());
    }

    @Override
    public Element toXMLElement() {
        Element result = MonarchActionMessage.createMessage(MonarchActionMessage.getXMLElementTagName(), "action", this.action.toString(), "monarch", this.monarchKey);
        if (this.tax != null) {
            result.setAttribute("tax", this.tax);
        }
        if (this.resultString != null) {
            result.setAttribute("result", this.resultString);
        }
        if (this.template != null) {
            result.appendChild(this.template.toXMLElement(result.getOwnerDocument()));
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "monarchAction";
    }
}

