/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.XmlStreamParsingException;
import org.openstreetmap.josm.spi.preferences.AbstractSetting;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class PreferencesReader {
    private final SortedMap<String, Setting<?>> settings = new TreeMap();
    private XMLStreamReader parser;
    private int version;
    private final Reader reader;
    private final File file;
    private final boolean defaults;

    public PreferencesReader(File file, boolean defaults) {
        this.defaults = defaults;
        this.reader = null;
        this.file = file;
    }

    public PreferencesReader(Reader reader, boolean defaults) {
        this.defaults = defaults;
        this.reader = reader;
        this.file = null;
    }

    public static void validateXML(File f) throws IOException, SAXException {
        try (BufferedReader in = Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8);){
            PreferencesReader.validateXML(in);
        }
    }

    public static void validateXML(Reader in) throws IOException, SAXException {
        try (CachedFile cf = new CachedFile("resource://data/preferences.xsd");
             InputStream xsdStream = cf.getInputStream();){
            Schema schema = Utils.newXmlSchemaFactory().newSchema(new StreamSource(xsdStream));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(in));
        }
    }

    public SortedMap<String, Setting<?>> getSettings() {
        return this.settings;
    }

    public int getVersion() {
        return this.version;
    }

    public void parse() throws XMLStreamException, IOException {
        if (this.reader != null) {
            this.parser = XMLInputFactory.newInstance().createXMLStreamReader(this.reader);
            this.doParse();
        } else {
            try (BufferedReader in = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);){
                this.parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
                this.doParse();
            }
        }
    }

    private void doParse() throws XMLStreamException {
        int event = this.parser.getEventType();
        while (true) {
            if (event == 1) {
                String localName;
                String topLevelElementName = this.defaults ? "preferences-defaults" : "preferences";
                if (!topLevelElementName.equals(localName = this.parser.getLocalName())) {
                    throw new XMLStreamException(I18n.tr("Expected element ''{0}'', but got ''{1}''", topLevelElementName, localName), this.parser.getLocation());
                }
                try {
                    this.version = Integer.parseInt(this.parser.getAttributeValue(null, "version"));
                }
                catch (NumberFormatException e) {
                    Logging.log(Logging.LEVEL_DEBUG, e);
                }
                this.parseRoot();
            } else if (event == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            event = this.parser.next();
        }
        this.parser.close();
    }

    private void parseRoot() throws XMLStreamException {
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                String localName;
                switch (localName = this.parser.getLocalName()) {
                    case "tag": {
                        StringSetting setting = this.defaults && this.isNil() ? new StringSetting(null) : new StringSetting(Optional.ofNullable(this.parser.getAttributeValue(null, "value")).orElseThrow(() -> new XMLStreamException(I18n.tr("value expected", new Object[0]), this.parser.getLocation())));
                        if (this.defaults) {
                            setting.setTime(Math.round(Double.parseDouble(this.parser.getAttributeValue(null, "time"))));
                        }
                        this.settings.put(this.parser.getAttributeValue(null, "key"), setting);
                        this.jumpToEnd();
                        break;
                    }
                    case "list": 
                    case "lists": 
                    case "maps": {
                        this.parseToplevelList();
                        break;
                    }
                    default: {
                        this.throwException("Unexpected element: " + localName);
                        break;
                    }
                }
                continue;
            }
            if (event == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                this.jumpToEnd();
                continue;
            }
            if (event == 2) break;
        }
    }

    private void parseToplevelList() throws XMLStreamException {
        String key = this.parser.getAttributeValue(null, "key");
        Long time = null;
        if (this.defaults) {
            time = Math.round(Double.parseDouble(this.parser.getAttributeValue(null, "time")));
        }
        String name = this.parser.getLocalName();
        ArrayList<String> entries = null;
        ArrayList<List<String>> lists = null;
        ArrayList<Map<String, String>> maps = null;
        if (this.defaults && this.isNil()) {
            AbstractSetting setting;
            switch (name) {
                case "lists": {
                    setting = new ListListSetting(null);
                    break;
                }
                case "maps": {
                    setting = new MapListSetting(null);
                    break;
                }
                default: {
                    setting = new ListSetting(null);
                }
            }
            setting.setTime(time);
            this.settings.put(key, setting);
            this.jumpToEnd();
        } else {
            AbstractSetting setting;
            while (true) {
                int event;
                if ((event = this.parser.next()) == 1) {
                    String localName;
                    switch (localName = this.parser.getLocalName()) {
                        case "entry": {
                            if (entries == null) {
                                entries = new ArrayList<String>();
                            }
                            entries.add(this.parser.getAttributeValue(null, "value"));
                            this.jumpToEnd();
                            break;
                        }
                        case "list": {
                            if (lists == null) {
                                lists = new ArrayList<List<String>>();
                            }
                            lists.add(this.parseInnerList());
                            break;
                        }
                        case "map": {
                            if (maps == null) {
                                maps = new ArrayList<Map<String, String>>();
                            }
                            maps.add(this.parseMap());
                            break;
                        }
                        default: {
                            this.throwException("Unexpected element: " + localName);
                            break;
                        }
                    }
                    continue;
                }
                if (event == 2) break;
            }
            if (entries != null) {
                setting = new ListSetting(Collections.unmodifiableList(entries));
            } else if (lists != null) {
                setting = new ListListSetting(Collections.unmodifiableList(lists));
            } else if (maps != null) {
                setting = new MapListSetting(Collections.unmodifiableList(maps));
            } else {
                switch (name) {
                    case "lists": {
                        setting = new ListListSetting(Collections.emptyList());
                        break;
                    }
                    case "maps": {
                        setting = new MapListSetting(Collections.emptyList());
                        break;
                    }
                    default: {
                        setting = new ListSetting(Collections.emptyList());
                    }
                }
            }
            if (this.defaults) {
                setting.setTime(time);
            }
            this.settings.put(key, setting);
        }
    }

    private List<String> parseInnerList() throws XMLStreamException {
        ArrayList<String> entries = new ArrayList<String>();
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                if ("entry".equals(this.parser.getLocalName())) {
                    entries.add(this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (event == 2) break;
        }
        return Collections.unmodifiableList(entries);
    }

    private Map<String, String> parseMap() throws XMLStreamException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                if ("tag".equals(this.parser.getLocalName())) {
                    map.put(this.parser.getAttributeValue(null, "key"), this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (event == 2) break;
        }
        return Collections.unmodifiableMap(map);
    }

    private boolean isNil() {
        String nil = this.parser.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        return "true".equals(nil) || "1".equals(nil);
    }

    private void throwException(String msg) throws XmlStreamParsingException {
        throw new XmlStreamParsingException(msg, this.parser.getLocation());
    }
}

