/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadMembersAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.relation.SelectMembersAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.CopyAllKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.HelpAction;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesCellRenderer;
import org.openstreetmap.josm.gui.dialogs.properties.SearchBasedRowFilter;
import org.openstreetmap.josm.gui.dialogs.properties.TagEditHelper;
import org.openstreetmap.josm.gui.dialogs.properties.TaginfoAction;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.CompileSearchTextDecorator;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
MainLayerManager.ActiveLayerChangeListener,
DataSetListenerAdapter.Listener {
    public static final JPanel pluginHook = new JPanel();
    private final ReadOnlyTableModel tagData = new ReadOnlyTableModel();
    private final PropertiesCellRenderer cellRenderer = new PropertiesCellRenderer();
    private final transient TableRowSorter<ReadOnlyTableModel> tagRowSorter = new TableRowSorter<ReadOnlyTableModel>(this.tagData);
    private final JosmTextField tagTableFilter;
    private final DefaultTableModel membershipData = new ReadOnlyTableModel();
    private final JTable tagTable = new JTable(this.tagData);
    private final JTable membershipTable = new JTable(this.membershipData);
    private final JPanel bothTables = new JPanel(new GridBagLayout());
    private final JPopupMenu tagMenu = new JPopupMenu();
    private final JPopupMenu membershipMenu = new JPopupMenu();
    private final JPopupMenu blankSpaceMenu = new JPopupMenu();
    private final transient PopupMenuHandler tagMenuHandler = new PopupMenuHandler(this.tagMenu);
    private final transient PopupMenuHandler membershipMenuHandler = new PopupMenuHandler(this.membershipMenu);
    private final transient PopupMenuHandler blankSpaceMenuHandler = new PopupMenuHandler(this.blankSpaceMenu);
    private final transient Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private final transient TagEditHelper editHelper = new TagEditHelper(this.tagTable, this.tagData, this.valueCount);
    private final transient DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private final HelpAction helpAction = new HelpAction(this.tagTable, this.editHelper::getDataKey, this.editHelper::getDataValues, this.membershipTable, x -> (Relation)this.membershipData.getValueAt(x, 0));
    private final TaginfoAction taginfoAction = new TaginfoAction(this.tagTable, this.editHelper::getDataKey, this.editHelper::getDataValues, this.membershipTable, x -> (Relation)this.membershipData.getValueAt(x, 0));
    private final PasteValueAction pasteValueAction = new PasteValueAction();
    private final CopyValueAction copyValueAction = new CopyValueAction(this.tagTable, this.editHelper::getDataKey, Main.main::getInProgressSelection);
    private final CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction(this.tagTable, this.editHelper::getDataKey, Main.main::getInProgressSelection);
    private final CopyAllKeyValueAction copyAllKeyValueAction = new CopyAllKeyValueAction(this.tagTable, this.editHelper::getDataKey, Main.main::getInProgressSelection);
    private final SearchAction searchActionSame = new SearchAction(true);
    private final SearchAction searchActionAny = new SearchAction(false);
    private final AddAction addAction = new AddAction();
    private final EditAction editAction = new EditAction();
    private final DeleteAction deleteAction = new DeleteAction();
    private final JosmAction[] josmActions = new JosmAction[]{this.addAction, this.editAction, this.deleteAction};
    private final SelectInRelationListAction setRelationSelectionAction = new SelectInRelationListAction();
    private final SelectRelationAction selectRelationAction = new SelectRelationAction(false);
    private final SelectRelationAction addRelationToSelectionAction = new SelectRelationAction(true);
    private final DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
    private final DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
    private final SelectMembersAction selectMembersAction = new SelectMembersAction(false);
    private final SelectMembersAction addMembersToSelectionAction = new SelectMembersAction(true);
    private final transient HighlightHelper highlightHelper = new HighlightHelper();
    private final SideButton btnAdd = new SideButton(this.addAction);
    private final SideButton btnEdit = new SideButton(this.editAction);
    private final SideButton btnDel = new SideButton(this.deleteAction);
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Select objects for which to change tags.", new Object[0]) + "</p></html>");
    private final PreferenceChangedListener preferenceListener = e -> {
        if (MainApplication.getLayerManager().getActiveDataSet() != null) {
            this.updateSelection();
        }
    };
    private final transient TaggingPresetHandler presetHandler = new TaggingPresetCommandHandler();

    public PropertiesDialog() {
        super(I18n.tr("Tags/Memberships", new Object[0]), "propertiesdialog", I18n.tr("Tags for selected objects.", new Object[0]), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Tags/Memberships", new Object[0])), 80, 5007), 150, true);
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Dialog/TagsMembership"));
        this.setupTagsMenu();
        this.buildTagsTable();
        this.setupMembershipMenu();
        this.buildMembershipTable();
        this.tagTableFilter = this.setupFilter();
        boolean top = Config.getPref().getBoolean("properties.presets.top", true);
        if (top) {
            this.bothTables.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double epsilon = Double.MIN_VALUE;
            this.bothTables.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(epsilon, epsilon));
        }
        this.bothTables.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        this.bothTables.add((Component)this.tagTableFilter, GBC.eol().fill(2));
        this.bothTables.add((Component)this.tagTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.tagTable, GBC.eol().fill(1));
        this.bothTables.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!top) {
            this.bothTables.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        this.setupBlankSpaceMenu();
        this.setupKeyboardShortcuts();
        this.tagTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.tagTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        JScrollPane scrollPane = (JScrollPane)this.createLayout(this.bothTables, true, Arrays.asList(this.btnAdd, this.btnEdit, this.btnDel));
        MouseClickWatch mouseClickWatch = new MouseClickWatch();
        this.tagTable.addMouseListener(mouseClickWatch);
        this.membershipTable.addMouseListener(mouseClickWatch);
        scrollPane.addMouseListener(mouseClickWatch);
        this.selectSth.setPreferredSize(scrollPane.getSize());
        this.presets.setSize(scrollPane.getSize());
        this.editHelper.loadTagsIfNeeded();
        Config.getPref().addKeyPreferenceChangeListener("display.discardable-keys", this.preferenceListener);
    }

    private void buildTagsTable() {
        this.tagData.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        this.tagTable.setSelectionMode(2);
        this.tagTable.getTableHeader().setReorderingAllowed(false);
        this.tagTable.getColumnModel().getColumn(0).setCellRenderer(this.cellRenderer);
        this.tagTable.getColumnModel().getColumn(1).setCellRenderer(this.cellRenderer);
        this.tagTable.setRowSorter(this.tagRowSorter);
        RemoveHiddenSelection removeHiddenSelection = new RemoveHiddenSelection();
        this.tagTable.getSelectionModel().addListSelectionListener(removeHiddenSelection);
        this.tagRowSorter.addRowSorterListener(removeHiddenSelection);
        this.tagRowSorter.setComparator(0, AlphanumComparator.getInstance());
        this.tagRowSorter.setComparator(1, (o1, o2) -> {
            if (o1 instanceof Map && o2 instanceof Map) {
                String v1 = ((Map)o1).size() == 1 ? (String)((Map)o1).keySet().iterator().next() : I18n.tr("<different>", new Object[0]);
                String v2 = ((Map)o2).size() == 1 ? (String)((Map)o2).keySet().iterator().next() : I18n.tr("<different>", new Object[0]);
                return AlphanumComparator.getInstance().compare(v1, v2);
            }
            return AlphanumComparator.getInstance().compare(String.valueOf(o1), String.valueOf(o2));
        });
    }

    private void buildMembershipTable() {
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of", new Object[0]), I18n.tr("Role", new Object[0]), I18n.tr("Position", new Object[0])});
        this.membershipTable.setSelectionMode(2);
        TableColumnModel mod = this.membershipTable.getColumnModel();
        this.membershipTable.getTableHeader().setReorderingAllowed(false);
        mod.getColumn(0).setCellRenderer(new MemberOfCellRenderer());
        mod.getColumn(1).setCellRenderer(new RoleCellRenderer());
        mod.getColumn(2).setCellRenderer(new PositionCellRenderer());
        mod.getColumn(2).setPreferredWidth(20);
        mod.getColumn(1).setPreferredWidth(40);
        mod.getColumn(0).setPreferredWidth(200);
    }

    private void setupBlankSpaceMenu() {
        if (Config.getPref().getBoolean("properties.menu.add_edit_delete", true)) {
            this.blankSpaceMenuHandler.addAction(this.addAction);
            BlankSpaceMenuLauncher launcher = new BlankSpaceMenuLauncher(this.blankSpaceMenu);
            this.bothTables.addMouseListener(launcher);
            this.tagTable.addMouseListener(launcher);
        }
    }

    private void setupMembershipMenu() {
        if (Config.getPref().getBoolean("properties.menu.add_edit_delete", true)) {
            this.membershipMenuHandler.addAction(this.editAction);
            this.membershipMenuHandler.addAction(this.deleteAction);
            this.membershipMenu.addSeparator();
        }
        this.membershipMenuHandler.addAction(this.setRelationSelectionAction);
        this.membershipMenuHandler.addAction(this.selectRelationAction);
        this.membershipMenuHandler.addAction(this.addRelationToSelectionAction);
        this.membershipMenuHandler.addAction(this.selectMembersAction);
        this.membershipMenuHandler.addAction(this.addMembersToSelectionAction);
        this.membershipMenu.addSeparator();
        this.membershipMenuHandler.addAction(this.downloadMembersAction);
        this.membershipMenuHandler.addAction(this.downloadSelectedIncompleteMembersAction);
        this.membershipMenu.addSeparator();
        this.membershipMenu.add(this.helpAction);
        this.membershipMenu.add(this.taginfoAction);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(this.membershipMenu){

            @Override
            protected int checkTableSelection(JTable table, Point p) {
                int row = super.checkTableSelection(table, p);
                ArrayList<Relation> rels = new ArrayList<Relation>();
                for (int i : table.getSelectedRows()) {
                    rels.add((Relation)table.getValueAt(i, 0));
                }
                PropertiesDialog.this.membershipMenuHandler.setPrimitives(rels);
                return row;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (MainApplication.isDisplayingMapView() && (row = PropertiesDialog.this.membershipTable.rowAtPoint(e.getPoint())) >= 0 && PropertiesDialog.this.highlightHelper.highlightOnly((Relation)PropertiesDialog.this.membershipTable.getValueAt(row, 0))) {
                    MainApplication.getMap().mapView.repaint();
                }
                super.mouseClicked(e);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                PropertiesDialog.this.highlightHelper.clear();
            }
        });
    }

    private void setupTagsMenu() {
        if (Config.getPref().getBoolean("properties.menu.add_edit_delete", true)) {
            this.tagMenu.add(this.addAction);
            this.tagMenu.add(this.editAction);
            this.tagMenu.add(this.deleteAction);
            this.tagMenu.addSeparator();
        }
        this.tagMenu.add(this.pasteValueAction);
        this.tagMenu.add(this.copyValueAction);
        this.tagMenu.add(this.copyKeyValueAction);
        this.tagMenu.add(this.copyAllKeyValueAction);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.searchActionAny);
        this.tagMenu.add(this.searchActionSame);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.helpAction);
        this.tagMenu.add(this.taginfoAction);
        this.tagTable.addMouseListener(new PopupMenuLauncher(this.tagMenu));
    }

    public void setFilter(SearchCompiler.Match filter) {
        this.tagRowSorter.setRowFilter(new SearchBasedRowFilter(filter));
    }

    private void setupKeyboardShortcuts() {
        InputMapUtils.addEnterActionWhenAncestor(this.tagTable, this.editAction);
        InputMapUtils.addEnterActionWhenAncestor(this.membershipTable, this.editAction);
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(155, 0), "onTableInsert");
        this.tagTable.getActionMap().put("onTableInsert", this.addAction);
        InputMapUtils.unassignCtrlShiftUpDown(this.tagTable, 1);
        InputMapUtils.unassignPageUpDown(this.tagTable, 1);
        this.tagTable.setTransferHandler(null);
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(67, 128), "onCopy");
        this.tagTable.getActionMap().put("onCopy", this.copyKeyValueAction);
        InputMapUtils.enableEnter(this.btnAdd);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", this.deleteAction);
        this.getInputMap(1).put(this.helpAction.getKeyStroke(), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    private JosmTextField setupFilter() {
        DisableShortcutsOnFocusGainedTextField f = new DisableShortcutsOnFocusGainedTextField();
        f.setToolTipText(I18n.tr("Tag filter", new Object[0]));
        CompileSearchTextDecorator decorator = CompileSearchTextDecorator.decorate(f);
        f.addPropertyChangeListener("filter", evt -> this.setFilter(decorator.getMatch()));
        return f;
    }

    private void editMembership(int row) {
        Relation relation = (Relation)this.membershipData.getValueAt(row, 0);
        MainApplication.getMap().relationListDialog.selectRelation(relation);
        OsmDataLayer layer = MainApplication.getLayerManager().getActiveDataLayer();
        if (!layer.isLocked()) {
            RelationEditor.getEditor(layer, relation, ((MemberInfo)this.membershipData.getValueAt(row, 1)).role).setVisible(true);
        }
    }

    private static int findViewRow(JTable table, TableModel model, Object value) {
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getValueAt(i, 0).equals(value)) continue;
            return table.convertRowIndexToView(i);
        }
        return -1;
    }

    private void updateSelection() {
        this.selectionChanged(null);
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        for (JosmAction action : this.josmActions) {
            MainApplication.registerActionShortcut(action);
        }
        this.updateSelection();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        for (JosmAction action : this.josmActions) {
            MainApplication.unregisterActionShortcut(action);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && MainApplication.getLayerManager().getActiveDataSet() != null) {
            this.updateSelection();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Config.getPref().removeKeyPreferenceChangeListener("display.discardable-keys", this.preferenceListener);
        Container parent = pluginHook.getParent();
        if (parent != null) {
            parent.remove(pluginHook);
        }
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        int selectedIndex;
        if (!this.isVisible()) {
            return;
        }
        if (this.tagTable == null) {
            return;
        }
        if (this.tagTable.getCellEditor() != null) {
            this.tagTable.getCellEditor().cancelCellEditing();
        }
        Collection newSel = Optional.ofNullable(Main.main.getInProgressSelection()).orElseGet(Collections::emptyList);
        Relation selectedRelation = null;
        String selectedTag = this.editHelper.getChangedKey();
        if (selectedTag == null && this.tagTable.getSelectedRowCount() == 1) {
            selectedTag = this.editHelper.getDataKey(this.tagTable.getSelectedRow());
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            selectedRelation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.tagData.setRowCount(0);
        boolean displayDiscardableKeys = Config.getPref().getBoolean("display.discardable-keys", false);
        HashMap<String, Integer> keyCount = new HashMap<String, Integer>();
        HashMap<String, String> tags = new HashMap<String, String>();
        this.valueCount.clear();
        EnumSet<TaggingPresetType> types = EnumSet.noneOf(TaggingPresetType.class);
        for (OsmPrimitive osmPrimitive : newSel) {
            types.add(TaggingPresetType.forPrimitive(osmPrimitive));
            for (String string : osmPrimitive.keySet()) {
                Map<Object, Object> v;
                if (!displayDiscardableKeys && AbstractPrimitive.getDiscardableKeys().contains(string)) continue;
                String string2 = osmPrimitive.get(string);
                keyCount.put(string, keyCount.containsKey(string) ? (Integer)keyCount.get(string) + 1 : 1);
                if (this.valueCount.containsKey(string)) {
                    v.put(string2, (v = this.valueCount.get(string)).containsKey(string2) ? (Integer)v.get(string2) + 1 : 1);
                    continue;
                }
                v = new TreeMap<String, Integer>();
                v.put(string2, 1);
                this.valueCount.put(string, v);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            int count = 0;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                count += ((Integer)entry2.getValue()).intValue();
            }
            if (count < newSel.size()) {
                ((Map)entry.getValue()).put("", newSel.size() - count);
            }
            this.tagData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            tags.put((String)entry.getKey(), ((Map)entry.getValue()).size() == 1 ? (String)((Map)entry.getValue()).keySet().iterator().next() : I18n.tr("<different>", new Object[0]));
        }
        this.membershipData.setRowCount(0);
        HashMap<Relation, MemberInfo> roles = new HashMap<Relation, MemberInfo>();
        for (OsmPrimitive primitive : newSel) {
            for (OsmPrimitive osmPrimitive : primitive.getReferrers(true)) {
                if (!(osmPrimitive instanceof Relation) || osmPrimitive.isIncomplete() || osmPrimitive.isDeleted()) continue;
                Relation r = (Relation)osmPrimitive;
                MemberInfo mi = Optional.ofNullable((MemberInfo)roles.get(r)).orElseGet(() -> new MemberInfo(newSel));
                roles.put(r, mi);
                int i = 1;
                for (RelationMember m : r.getMembers()) {
                    if (m.getMember() == primitive) {
                        mi.add(m, i);
                    }
                    ++i;
                }
            }
        }
        ArrayList arrayList = new ArrayList(roles.keySet());
        arrayList.sort((o1, o2) -> {
            int comp = Boolean.compare(o1.isDisabledAndHidden(), o2.isDisabledAndHidden());
            return comp != 0 ? comp : DefaultNameFormatter.getInstance().getRelationComparator().compare((IRelation<?>)o1, (IRelation<?>)o2);
        });
        for (Relation relation : arrayList) {
            this.membershipData.addRow(new Object[]{relation, roles.get(relation)});
        }
        this.presets.updatePresets(types, tags, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        DataSet ds = Main.main.getActiveDataSet();
        boolean bl = ds != null && ds.isLocked();
        boolean bl2 = !newSel.isEmpty();
        boolean hasTags = bl2 && this.tagData.getRowCount() > 0;
        boolean hasMemberships = bl2 && this.membershipData.getRowCount() > 0;
        this.addAction.setEnabled(!bl && bl2);
        this.editAction.setEnabled(!bl && (hasTags || hasMemberships));
        this.deleteAction.setEnabled(!bl && (hasTags || hasMemberships));
        this.tagTable.setVisible(hasTags);
        this.tagTable.getTableHeader().setVisible(hasTags);
        this.tagTableFilter.setVisible(hasTags);
        this.selectSth.setVisible(!bl2);
        pluginHook.setVisible(bl2);
        if (selectedTag != null && (selectedIndex = PropertiesDialog.findViewRow(this.tagTable, this.tagData, selectedTag)) != -1) {
            this.tagTable.changeSelection(selectedIndex, 0, false, false);
        } else if (selectedRelation != null && (selectedIndex = PropertiesDialog.findViewRow(this.membershipTable, this.membershipData, selectedRelation)) != -1) {
            this.membershipTable.changeSelection(selectedIndex, 0, false, false);
        } else if (hasTags) {
            this.tagTable.changeSelection(0, 0, false, false);
        } else if (hasMemberships) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.tagData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            if (newSel.size() > 1) {
                this.setTitle(I18n.tr("Objects: {2} / Tags: {0} / Memberships: {1}", this.tagData.getRowCount(), this.membershipData.getRowCount(), newSel.size()));
            } else {
                this.setTitle(I18n.tr("Tags: {0} / Memberships: {1}", this.tagData.getRowCount(), this.membershipData.getRowCount()));
            }
        } else {
            this.setTitle(I18n.tr("Tags/Memberships", new Object[0]));
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (e.getSource().getEditLayer() == null) {
            this.editHelper.saveTagsIfNeeded();
        }
        this.updateSelection();
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateSelection();
    }

    public PopupMenuHandler getPropertyPopupMenuHandler() {
        return this.tagMenuHandler;
    }

    public Tag getSelectedProperty() {
        int row = this.tagTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        Map<String, Integer> map = this.editHelper.getDataValues(row);
        return new Tag(this.editHelper.getDataKey(row), map.size() > 1 ? "" : map.keySet().iterator().next());
    }

    public PopupMenuHandler getMembershipPopupMenuHandler() {
        return this.membershipMenuHandler;
    }

    public IRelation<?> getSelectedMembershipRelation() {
        int row = this.membershipTable.getSelectedRow();
        return row > -1 ? (IRelation)this.membershipData.getValueAt(row, 0) : null;
    }

    public void addCustomPropertiesCellRenderer(TableCellRenderer renderer) {
        this.cellRenderer.addCustomRenderer(renderer);
    }

    public void removeCustomPropertiesCellRenderer(TableCellRenderer renderer) {
        this.cellRenderer.removeCustomRenderer(renderer);
    }

    static SearchSetting createSearchSetting(String key, Collection<OsmPrimitive> sel, boolean sameType) {
        String sep = "";
        StringBuilder s = new StringBuilder();
        TreeSet<String> consideredTokens = new TreeSet<String>();
        for (OsmPrimitive p : sel) {
            String token;
            String val = p.get(key);
            if (val == null || !sameType && consideredTokens.contains(val)) continue;
            String t = "";
            if (!sameType) {
                t = "";
            } else if (p instanceof Node) {
                t = "type:node ";
            } else if (p instanceof Way) {
                t = "type:way ";
            } else if (p instanceof Relation) {
                t = "type:relation ";
            }
            if (!consideredTokens.add(token = t + val)) continue;
            s.append(sep).append('(').append(t).append(SearchCompiler.buildSearchStringForTag(key, val)).append(')');
            sep = " OR ";
        }
        SearchSetting ss = new SearchSetting();
        ss.text = s.toString();
        ss.caseSensitive = true;
        return ss;
    }

    private class RemoveHiddenSelection
    implements ListSelectionListener,
    RowSorterListener {
        private RemoveHiddenSelection() {
        }

        void removeHiddenSelection() {
            try {
                PropertiesDialog.this.tagRowSorter.convertRowIndexToModel(PropertiesDialog.this.tagTable.getSelectedRow());
            }
            catch (IndexOutOfBoundsException ignore) {
                Logging.trace(ignore);
                Logging.trace("Clearing tagTable selection");
                PropertiesDialog.this.tagTable.clearSelection();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            this.removeHiddenSelection();
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            this.removeHiddenSelection();
        }
    }

    class SearchAction
    extends AbstractAction {
        private final boolean sameType;

        SearchAction(boolean sameType) {
            this.sameType = sameType;
            if (sameType) {
                this.putValue("Name", I18n.tr("Search Key/Value/Type", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag, restrict to type (i.e., node/way/relation)", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Search Key/Value", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag", new Object[0]));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String key = PropertiesDialog.this.editHelper.getDataKey(PropertiesDialog.this.tagTable.getSelectedRow());
            Collection<OsmPrimitive> sel = Main.main.getInProgressSelection();
            if (sel.isEmpty()) {
                return;
            }
            SearchSetting ss = PropertiesDialog.createSearchSetting(key, sel, this.sameType);
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(ss);
        }
    }

    class PasteValueAction
    extends AbstractAction {
        PasteValueAction() {
            this.putValue("Name", I18n.tr("Paste Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Paste the value of the selected tag from clipboard", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String key = PropertiesDialog.this.editHelper.getDataKey(PropertiesDialog.this.tagTable.getSelectedRow());
            Collection<OsmPrimitive> sel = Main.main.getInProgressSelection();
            String clipboard = ClipboardUtils.getClipboardStringContent();
            if (sel.isEmpty() || clipboard == null || sel.iterator().next().getDataSet().isLocked()) {
                return;
            }
            MainApplication.undoRedo.add(new ChangePropertyCommand(sel, key, Utils.strip(clipboard)));
        }
    }

    class EditAction
    extends JosmAction
    implements ListSelectionListener {
        EditAction() {
            super(I18n.tr("Edit", new Object[0]), "dialogs/edit", I18n.tr("Edit the value of the selected key for all objects", new Object[0]), Shortcut.registerShortcut("properties:edit", I18n.tr("Edit Tags", new Object[0]), 83, 5004), false);
            this.updateEnabledState();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            try {
                if (PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) {
                    int row = PropertiesDialog.this.tagTable.getSelectedRow();
                    PropertiesDialog.this.editHelper.editTag(row, false);
                } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                    PropertiesDialog.this.editMembership(row);
                }
            }
            finally {
                this.setEnabled(true);
            }
        }

        @Override
        protected void updateEnabledState() {
            DataSet ds = Main.main.getActiveDataSet();
            this.setEnabled(ds != null && !ds.isLocked() && (PropertiesDialog.this.tagTable != null && PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) ^ (PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends JosmAction {
        AddAction() {
            super(I18n.tr("Add", new Object[0]), "dialogs/add", I18n.tr("Add a new key/value pair to all objects", new Object[0]), Shortcut.registerShortcut("properties:add", I18n.tr("Add Tag", new Object[0]), 65, 5004), false);
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            try {
                PropertiesDialog.this.editHelper.addTag();
                PropertiesDialog.this.btnAdd.requestFocusInWindow();
            }
            finally {
                this.setEnabled(true);
            }
        }
    }

    class DeleteAction
    extends JosmAction
    implements ListSelectionListener {
        private static final String DELETE_FROM_RELATION_PREF = "delete_from_relation";

        DeleteAction() {
            super(I18n.tr("Delete", new Object[0]), "dialogs/delete", I18n.tr("Delete the selected key in all objects", new Object[0]), Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Tags", new Object[0]), 68, 5010), false);
            this.updateEnabledState();
        }

        protected void deleteTags(int ... rows) {
            HashMap<String, String> tags = new HashMap<String, String>(rows.length);
            int nextKeyIndex = rows[0];
            for (int row : rows) {
                String key = PropertiesDialog.this.editHelper.getDataKey(row);
                if (row == nextKeyIndex + 1) {
                    nextKeyIndex = row;
                }
                tags.put(key, null);
            }
            String nextKey = null;
            int rowCount = PropertiesDialog.this.tagData.getRowCount();
            if (rowCount > rows.length) {
                nextKeyIndex = nextKeyIndex == rows[rows.length - 1] ? (nextKeyIndex + 1 < rowCount ? nextKeyIndex + 1 : rows[0] - 1) : ++nextKeyIndex;
                nextKey = (String)PropertiesDialog.this.tagData.getValueAt(nextKeyIndex, 0);
            }
            Collection<OsmPrimitive> sel = Main.main.getInProgressSelection();
            MainApplication.undoRedo.add(new ChangePropertyCommand(sel, tags));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (nextKey != null) {
                PropertiesDialog.this.tagTable.changeSelection(PropertiesDialog.findViewRow(PropertiesDialog.this.tagTable, PropertiesDialog.this.tagData, nextKey), 0, false, false);
            }
        }

        protected void deleteFromRelation(int row) {
            Relation cur = (Relation)PropertiesDialog.this.membershipData.getValueAt(row, 0);
            Relation nextRelation = null;
            int rowCount = PropertiesDialog.this.membershipTable.getRowCount();
            if (rowCount > 1) {
                nextRelation = (Relation)PropertiesDialog.this.membershipData.getValueAt(row + 1 < rowCount ? row + 1 : row - 1, 0);
            }
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Change relation", new Object[0]), I18n.tr("Delete from relation", new Object[0]), I18n.tr("Cancel", new Object[0]));
            ed.setButtonIcons("dialogs/delete", "cancel");
            ed.setContent(I18n.tr("Really delete selection from relation {0}?", cur.getDisplayName(DefaultNameFormatter.getInstance())));
            ed.toggleEnable(DELETE_FROM_RELATION_PREF);
            if (ed.showDialog().getValue() != 1) {
                return;
            }
            Relation rel = new Relation(cur);
            for (OsmPrimitive primitive : Main.main.getInProgressSelection()) {
                rel.removeMembersFor(primitive);
            }
            MainApplication.undoRedo.add(new ChangeCommand(cur, rel));
            PropertiesDialog.this.tagTable.clearSelection();
            if (nextRelation != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.findViewRow(PropertiesDialog.this.membershipTable, PropertiesDialog.this.membershipData, nextRelation), 0, false, false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() > 0) {
                int[] rows = PropertiesDialog.this.tagTable.getSelectedRows();
                this.deleteTags(rows);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                ConditionalOptionPaneUtil.startBulkOperation(DELETE_FROM_RELATION_PREF);
                int[] rows = PropertiesDialog.this.membershipTable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.deleteFromRelation(rows[i]);
                }
                ConditionalOptionPaneUtil.endBulkOperation(DELETE_FROM_RELATION_PREF);
            }
        }

        @Override
        protected final void updateEnabledState() {
            DataSet ds = Main.main.getActiveDataSet();
            this.setEnabled(ds != null && !ds.isLocked() && (PropertiesDialog.this.tagTable != null && PropertiesDialog.this.tagTable.getSelectedRowCount() >= 1 || PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    public static class ReadOnlyTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    static class MemberInfo {
        private final List<RelationMember> role = new ArrayList<RelationMember>();
        private Set<OsmPrimitive> members = new HashSet<OsmPrimitive>();
        private List<Integer> position = new ArrayList<Integer>();
        private Collection<OsmPrimitive> selection;
        private String positionString;
        private String roleString;

        MemberInfo(Collection<OsmPrimitive> selection) {
            this.selection = selection;
        }

        void add(RelationMember r, Integer p) {
            this.role.add(r);
            this.members.add(r.getMember());
            this.position.add(p);
        }

        String getPositionString() {
            if (this.positionString == null) {
                this.positionString = Utils.getPositionListString(this.position);
                if (this.selection.stream().anyMatch(p -> !this.members.contains(p))) {
                    this.positionString = this.positionString + ",\u2717";
                }
                this.members = null;
                this.position = null;
                this.selection = null;
            }
            return Utils.shortenString(this.positionString, 20);
        }

        String getRoleString() {
            if (this.roleString == null) {
                for (RelationMember r : this.role) {
                    if (this.roleString == null) {
                        this.roleString = r.getRole();
                        continue;
                    }
                    if (this.roleString.equals(r.getRole())) continue;
                    this.roleString = I18n.tr("<different>", new Object[0]);
                    break;
                }
            }
            return this.roleString;
        }

        public String toString() {
            return "MemberInfo{roles='" + this.roleString + '\'' + ", positions='" + this.positionString + '\'' + '}';
        }
    }

    public class MouseClickWatch
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                if (e.getSource() == PropertiesDialog.this.tagTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.tagTable.clearSelection();
                }
            } else if (e.getSource() == PropertiesDialog.this.tagTable) {
                int row = PropertiesDialog.this.tagTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    boolean focusOnKey = PropertiesDialog.this.tagTable.columnAtPoint(e.getPoint()) == 0;
                    PropertiesDialog.this.editHelper.editTag(row, focusOnKey);
                } else {
                    PropertiesDialog.this.editHelper.addTag();
                    PropertiesDialog.this.btnAdd.requestFocusInWindow();
                }
            } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                int row = PropertiesDialog.this.membershipTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    PropertiesDialog.this.editMembership(row);
                }
            } else {
                PropertiesDialog.this.editHelper.addTag();
                PropertiesDialog.this.btnAdd.requestFocusInWindow();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == PropertiesDialog.this.tagTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.tagTable.clearSelection();
            }
        }
    }

    static final class TaggingPresetCommandHandler
    implements TaggingPresetHandler {
        TaggingPresetCommandHandler() {
        }

        @Override
        public void updateTags(List<Tag> tags) {
            Command command = TaggingPreset.createCommand(this.getSelection(), tags);
            if (command != null) {
                MainApplication.undoRedo.add(command);
            }
        }

        @Override
        public Collection<OsmPrimitive> getSelection() {
            return Main.main == null ? Collections.emptyList() : Main.main.getInProgressSelection();
        }
    }

    static final class BlankSpaceMenuLauncher
    extends PopupMenuLauncher {
        BlankSpaceMenuLauncher(JPopupMenu menu) {
            super(menu);
        }

        @Override
        protected boolean checkSelection(Component component, Point p) {
            if (component instanceof JTable) {
                return ((JTable)component).rowAtPoint(p) == -1;
            }
            return true;
        }
    }

    static final class PositionCellRenderer
    extends DefaultTableCellRenderer {
        PositionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                label.setText(((MemberInfo)table.getValueAt(row, 1)).getPositionString());
                if (isDisabledAndHidden) {
                    label.setFont(label.getFont().deriveFont(2));
                }
            }
            return c;
        }
    }

    static final class RoleCellRenderer
    extends DefaultTableCellRenderer {
        RoleCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                label.setText(((MemberInfo)value).getRoleString());
                if (isDisabledAndHidden) {
                    label.setFont(label.getFont().deriveFont(2));
                }
            }
            return c;
        }
    }

    static final class MemberOfCellRenderer
    extends DefaultTableCellRenderer {
        MemberOfCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            if (value == null) {
                return this;
            }
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                Relation r = (Relation)value;
                label.setText(r.getDisplayName(DefaultNameFormatter.getInstance()));
                if (r.isDisabledAndHidden()) {
                    label.setFont(label.getFont().deriveFont(2));
                }
            }
            return c;
        }
    }
}

