/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.DLSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.util.ByteArrayOutputStream;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ASN1 {
    private static Map<Ruby, Map<String, ASN1ObjectIdentifier>> SYM_TO_OID = new WeakHashMap<Ruby, Map<String, ASN1ObjectIdentifier>>(8);
    private static Map<Ruby, Map<ASN1ObjectIdentifier, String>> OID_TO_SYM = new WeakHashMap<Ruby, Map<ASN1ObjectIdentifier, String>>(8);
    private static Map<Ruby, Map<ASN1ObjectIdentifier, Integer>> OID_TO_NID = new WeakHashMap<Ruby, Map<ASN1ObjectIdentifier, Integer>>(8);
    private static Map<Ruby, Map<Integer, ASN1ObjectIdentifier>> NID_TO_OID = new WeakHashMap<Ruby, Map<Integer, ASN1ObjectIdentifier>>(8);
    private static Map<Ruby, Map<Integer, String>> NID_TO_SN = new WeakHashMap<Ruby, Map<Integer, String>>(8);
    private static Map<Ruby, Map<Integer, String>> NID_TO_LN = new WeakHashMap<Ruby, Map<Integer, String>>(8);
    private static final Object[][] ASN1_INFO = new Object[][]{{"EOC", null, "EndOfContent"}, {"BOOLEAN", DERBoolean.class, "Boolean"}, {"INTEGER", DERInteger.class, "Integer"}, {"BIT_STRING", DERBitString.class, "BitString"}, {"OCTET_STRING", DEROctetString.class, "OctetString"}, {"NULL", DERNull.class, "Null"}, {"OBJECT", DERObjectIdentifier.class, "ObjectId"}, {"OBJECT_DESCRIPTOR", null, null}, {"EXTERNAL", null, null}, {"REAL", null, null}, {"ENUMERATED", DEREnumerated.class, "Enumerated"}, {"EMBEDDED_PDV", null, null}, {"UTF8STRING", DERUTF8String.class, "UTF8String"}, {"RELATIVE_OID", null, null}, {"[UNIVERSAL 14]", null, null}, {"[UNIVERSAL 15]", null, null}, {"SEQUENCE", DERSequence.class, "Sequence"}, {"SET", DERSet.class, "Set"}, {"NUMERICSTRING", DERNumericString.class, "NumericString"}, {"PRINTABLESTRING", DERPrintableString.class, "PrintableString"}, {"T61STRING", DERT61String.class, "T61String"}, {"VIDEOTEXSTRING", null, "VideotexString"}, {"IA5STRING", DERIA5String.class, "IA5String"}, {"UTCTIME", DERUTCTime.class, "UTCTime"}, {"GENERALIZEDTIME", DERGeneralizedTime.class, "GeneralizedTime"}, {"GRAPHICSTRING", null, "GraphicString"}, {"ISO64STRING", null, "ISO64String"}, {"GENERALSTRING", DERGeneralString.class, "GeneralString"}, {"UNIVERSALSTRING", DERUniversalString.class, "UniversalString"}, {"CHARACTER_STRING", null, null}, {"BMPSTRING", DERBMPString.class, "BMPString"}};
    private static final Map<Class<?>, Integer> JCLASS_TO_ID = new HashMap(24, 1.0f);
    private static final Map<String, Integer> RCLASS_TO_ID = new HashMap<String, Integer>(28, 1.0f);
    private static final int EOC = 0;
    private static final int BIT_STRING = 3;
    private static final int OCTET_STRING = 4;
    private static final int SEQUENCE = 16;
    private static final int SET = 17;

    private static synchronized void initMaps(Ruby runtime) {
        int size2 = 200;
        float fact = 1.0f;
        SYM_TO_OID.put(runtime, new HashMap(200, 1.0f));
        OID_TO_SYM.put(runtime, new HashMap(200, 1.0f));
        OID_TO_NID.put(runtime, new HashMap(200, 1.0f));
        NID_TO_OID.put(runtime, new HashMap(200, 1.0f));
        NID_TO_SN.put(runtime, new HashMap(200, 1.0f));
        NID_TO_LN.put(runtime, new HashMap(200, 1.0f));
        ASN1.defaultObjects(runtime);
    }

    private static void defaultObjects(Ruby runtime) {
        ASN1.addObject(runtime, 0, null, null, "1.2.840.113549.1.12.1");
        ASN1.addObject(runtime, 1, null, "rsadsi", "1.2.840.113549");
        ASN1.addObject(runtime, 2, null, "pkcs", "1.2.840.113549.1");
        ASN1.addObject(runtime, 3, "MD2", "md2", "1.2.840.113549.2.2");
        ASN1.addObject(runtime, 4, "MD5", "md5", "1.2.840.113549.2.5");
        ASN1.addObject(runtime, 5, "RC4", "rc4", "1.2.840.113549.3.4");
        ASN1.addObject(runtime, 6, null, "rsaEncryption", "1.2.840.113549.1.1.1");
        ASN1.addObject(runtime, 7, "RSA-MD2", "md2WithRSAEncryption", "1.2.840.113549.1.1.2");
        ASN1.addObject(runtime, 8, "RSA-MD5", "md5WithRSAEncryption", "1.2.840.113549.1.1.4");
        ASN1.addObject(runtime, 9, "PBE-MD2-DES", "pbeWithMD2AndDES-CBC", "1.2.840.113549.1.5.1");
        ASN1.addObject(runtime, 10, "PBE-MD5-DES", "pbeWithMD5AndDES-CBC", "1.2.840.113549.1.5.3");
        ASN1.addObject(runtime, 11, null, "X500", "2.5");
        ASN1.addObject(runtime, 12, null, "X509", "2.5.4");
        ASN1.addObject(runtime, 13, "CN", "commonName", "2.5.4.3");
        ASN1.addObject(runtime, 14, "C", "countryName", "2.5.4.6");
        ASN1.addObject(runtime, 15, "L", "localityName", "2.5.4.7");
        ASN1.addObject(runtime, 16, "ST", "stateOrProvinceName", "2.5.4.8");
        ASN1.addObject(runtime, 17, "O", "organizationName", "2.5.4.10");
        ASN1.addObject(runtime, 18, "OU", "organizationalUnitName", "2.5.4.11");
        ASN1.addObject(runtime, 19, "RSA", "rsa", "2.5.8.1.1");
        ASN1.addObject(runtime, 20, null, "pkcs7", "1.2.840.113549.1.7");
        ASN1.addObject(runtime, 21, null, "pkcs7-data", "1.2.840.113549.1.7.1");
        ASN1.addObject(runtime, 22, null, "pkcs7-signedData", "1.2.840.113549.1.7.2");
        ASN1.addObject(runtime, 23, null, "pkcs7-envelopedData", "1.2.840.113549.1.7.3");
        ASN1.addObject(runtime, 24, null, "pkcs7-signedAndEnvelopedData", "1.2.840.113549.1.7.4");
        ASN1.addObject(runtime, 25, null, "pkcs7-digestData", "1.2.840.113549.1.7.5");
        ASN1.addObject(runtime, 26, null, "pkcs7-encryptedData", "1.2.840.113549.1.7.6");
        ASN1.addObject(runtime, 27, null, "pkcs3", "1.2.840.113549.1.3");
        ASN1.addObject(runtime, 28, null, "dhKeyAgreement", "1.2.840.113549.1.3.1");
        ASN1.addObject(runtime, 29, "DES-ECB", "des-ecb", "1.3.14.3.2.6");
        ASN1.addObject(runtime, 30, "DES-CFB", "des-cfb", "1.3.14.3.2.9");
        ASN1.addObject(runtime, 31, "DES-CBC", "des-cbc", "1.3.14.3.2.7");
        ASN1.addObject(runtime, 32, "DES-EDE", "des-ede", "1.3.14.3.2.17");
        ASN1.addObject(runtime, 33, "DES-EDE3", "des-ede3", null);
        ASN1.addObject(runtime, 34, "IDEA-CBC", "idea-cbc", "1.3.6.1.4.1.188.7.1.1.2");
        ASN1.addObject(runtime, 35, "IDEA-CFB", "idea-cfb", null);
        ASN1.addObject(runtime, 36, "IDEA-ECB", "idea-ecb", null);
        ASN1.addObject(runtime, 37, "RC2-CBC", "rc2-cbc", "1.2.840.113549.3.2");
        ASN1.addObject(runtime, 38, "RC2-ECB", "rc2-ecb", null);
        ASN1.addObject(runtime, 39, "RC2-CFB", "rc2-cfb", null);
        ASN1.addObject(runtime, 40, "RC2-OFB", "rc2-ofb", null);
        ASN1.addObject(runtime, 41, "SHA", "sha", "1.3.14.3.2.18");
        ASN1.addObject(runtime, 42, "RSA-SHA", "shaWithRSAEncryption", "1.3.14.3.2.15");
        ASN1.addObject(runtime, 43, "DES-EDE-CBC", "des-ede-cbc", null);
        ASN1.addObject(runtime, 44, "DES-EDE3-CBC", "des-ede3-cbc", "1.2.840.113549.3.7");
        ASN1.addObject(runtime, 45, "DES-OFB", "des-ofb", "1.3.14.3.2.8");
        ASN1.addObject(runtime, 46, "IDEA-OFB", "idea-ofb", null);
        ASN1.addObject(runtime, 47, null, "pkcs9", "1.2.840.113549.1.9");
        ASN1.addObject(runtime, 48, null, "emailAddress", "1.2.840.113549.1.9.1");
        ASN1.addObject(runtime, 49, null, "unstructuredName", "1.2.840.113549.1.9.2");
        ASN1.addObject(runtime, 50, null, "contentType", "1.2.840.113549.1.9.3");
        ASN1.addObject(runtime, 51, null, "messageDigest", "1.2.840.113549.1.9.4");
        ASN1.addObject(runtime, 52, null, "signingTime", "1.2.840.113549.1.9.5");
        ASN1.addObject(runtime, 53, null, "countersignature", "1.2.840.113549.1.9.6");
        ASN1.addObject(runtime, 54, null, "challengePassword", "1.2.840.113549.1.9.7");
        ASN1.addObject(runtime, 55, null, "unstructuredAddress", "1.2.840.113549.1.9.8");
        ASN1.addObject(runtime, 56, null, "extendedCertificateAttributes", "1.2.840.113549.1.9.9");
        ASN1.addObject(runtime, 57, "Netscape", "Netscape Communications Corp.", "2.16.840.1.113730");
        ASN1.addObject(runtime, 58, "nsCertExt", "Netscape Certificate Extension", "2.16.840.1.113730.1");
        ASN1.addObject(runtime, 59, "nsDataType", "Netscape Data Type", "2.16.840.1.113730.2");
        ASN1.addObject(runtime, 60, "DES-EDE-CFB", "des-ede-cfb", null);
        ASN1.addObject(runtime, 61, "DES-EDE3-CFB", "des-ede3-cfb", null);
        ASN1.addObject(runtime, 62, "DES-EDE-OFB", "des-ede-ofb", null);
        ASN1.addObject(runtime, 63, "DES-EDE3-OFB", "des-ede3-ofb", null);
        ASN1.addObject(runtime, 64, "SHA1", "sha1", "1.3.14.3.2.26");
        ASN1.addObject(runtime, 65, "RSA-SHA1", "sha1WithRSAEncryption", "1.2.840.113549.1.1.5");
        ASN1.addObject(runtime, 66, "DSA-SHA", "dsaWithSHA", "1.3.14.3.2.13");
        ASN1.addObject(runtime, 67, "DSA-old", "dsaEncryption-old", "1.3.14.3.2.12");
        ASN1.addObject(runtime, 68, "PBE-SHA1-RC2-64", "pbeWithSHA1AndRC2-CBC", "1.2.840.113549.1.5.11");
        ASN1.addObject(runtime, 69, null, "PBKDF2", "1.2.840.113549.1.5.12");
        ASN1.addObject(runtime, 70, "DSA-SHA1-old", "dsaWithSHA1-old", "1.3.14.3.2.27");
        ASN1.addObject(runtime, 71, "nsCertType", "Netscape Cert Type", "2.16.840.1.113730.1.1");
        ASN1.addObject(runtime, 72, "nsBaseUrl", "Netscape Base Url", "2.16.840.1.113730.1.2");
        ASN1.addObject(runtime, 73, "nsRevocationUrl", "Netscape Revocation Url", "2.16.840.1.113730.1.3");
        ASN1.addObject(runtime, 74, "nsCaRevocationUrl", "Netscape CA Revocation Url", "2.16.840.1.113730.1.4");
        ASN1.addObject(runtime, 75, "nsRenewalUrl", "Netscape Renewal Url", "2.16.840.1.113730.1.7");
        ASN1.addObject(runtime, 76, "nsCaPolicyUrl", "Netscape CA Policy Url", "2.16.840.1.113730.1.8");
        ASN1.addObject(runtime, 77, "nsSslServerName", "Netscape SSL Server Name", "2.16.840.1.113730.1.12");
        ASN1.addObject(runtime, 78, "nsComment", "Netscape Comment", "2.16.840.1.113730.1.13");
        ASN1.addObject(runtime, 79, "nsCertSequence", "Netscape Certificate Sequence", "2.16.840.1.113730.2.5");
        ASN1.addObject(runtime, 80, "DESX-CBC", "desx-cbc", null);
        ASN1.addObject(runtime, 81, "id-ce", null, "2.5.29");
        ASN1.addObject(runtime, 82, "subjectKeyIdentifier", "X509v3 Subject Key Identifier", "2.5.29.14");
        ASN1.addObject(runtime, 83, "keyUsage", "X509v3 Key Usage", "2.5.29.15");
        ASN1.addObject(runtime, 84, "privateKeyUsagePeriod", "X509v3 Private Key Usage Period", "2.5.29.16");
        ASN1.addObject(runtime, 85, "subjectAltName", "X509v3 Subject Alternative Name", "2.5.29.17");
        ASN1.addObject(runtime, 86, "issuerAltName", "X509v3 Issuer Alternative Name", "2.5.29.18");
        ASN1.addObject(runtime, 87, "basicConstraints", "X509v3 Basic Constraints", "2.5.29.19");
        ASN1.addObject(runtime, 88, "crlNumber", "X509v3 CRL Number", "2.5.29.20");
        ASN1.addObject(runtime, 89, "certificatePolicies", "X509v3 Certificate Policies", "2.5.29.32");
        ASN1.addObject(runtime, 90, "authorityKeyIdentifier", "X509v3 Authority Key Identifier", "2.5.29.35");
        ASN1.addObject(runtime, 91, "BF-CBC", "bf-cbc", "1.3.6.1.4.1.3029.1.2");
        ASN1.addObject(runtime, 92, "BF-ECB", "bf-ecb", null);
        ASN1.addObject(runtime, 93, "BF-CFB", "bf-cfb", null);
        ASN1.addObject(runtime, 94, "BF-OFB", "bf-ofb", null);
        ASN1.addObject(runtime, 95, "MDC2", "mdc2", "2.5.8.3.101");
        ASN1.addObject(runtime, 96, "RSA-MDC2", "mdc2withRSA", "2.5.8.3.100");
        ASN1.addObject(runtime, 97, "RC4-40", "rc4-40", null);
        ASN1.addObject(runtime, 98, "RC2-40-CBC", "rc2-40-cbc", null);
        ASN1.addObject(runtime, 99, "G", "givenName", "2.5.4.42");
        ASN1.addObject(runtime, 100, "S", "surname", "2.5.4.4");
        ASN1.addObject(runtime, 101, "I", "initials", "2.5.4.43");
        ASN1.addObject(runtime, 102, "UID", "uniqueIdentifier", "2.5.4.45");
        ASN1.addObject(runtime, 103, "crlDistributionPoints", "X509v3 CRL Distribution Points", "2.5.29.31");
        ASN1.addObject(runtime, 104, "RSA-NP-MD5", "md5WithRSA", "1.3.14.3.2.3");
        ASN1.addObject(runtime, 105, null, "serialNumber", "2.5.4.5");
        ASN1.addObject(runtime, 106, "T", "title", "2.5.4.12");
        ASN1.addObject(runtime, 107, "D", "description", "2.5.4.13");
        ASN1.addObject(runtime, 108, "CAST5-CBC", "cast5-cbc", "1.2.840.113533.7.66.10");
        ASN1.addObject(runtime, 109, "CAST5-ECB", "cast5-ecb", null);
        ASN1.addObject(runtime, 110, "CAST5-CFB", "cast5-cfb", null);
        ASN1.addObject(runtime, 111, "CAST5-OFB", "cast5-ofb", null);
        ASN1.addObject(runtime, 112, null, "pbeWithMD5AndCast5CBC", "1.2.840.113533.7.66.12");
        ASN1.addObject(runtime, 113, "DSA-SHA1", "dsaWithSHA1", "1.2.840.10040.4.3");
        ASN1.addObject(runtime, 114, "MD5-SHA1", "md5-sha1", null);
        ASN1.addObject(runtime, 115, "RSA-SHA1-2", "sha1WithRSA", "1.3.14.3.2.29");
        ASN1.addObject(runtime, 116, "DSA", "dsaEncryption", "1.2.840.10040.4.1");
        ASN1.addObject(runtime, 117, "RIPEMD160", "ripemd160", "1.3.36.3.2.1");
        ASN1.addObject(runtime, 118, "RSA-RIPEMD160", "ripemd160WithRSA", "1.3.36.3.3.1.2");
        ASN1.addObject(runtime, 119, "RC5-CBC", "rc5-cbc", "1.2.840.113549.3.8");
        ASN1.addObject(runtime, 120, "RC5-ECB", "rc5-ecb", null);
        ASN1.addObject(runtime, 121, "RC5-CFB", "rc5-cfb", null);
        ASN1.addObject(runtime, 122, "RC5-OFB", "rc5-ofb", null);
        ASN1.addObject(runtime, 123, "RLE", "run length compression", "1.1.1.1.666.1");
        ASN1.addObject(runtime, 124, "ZLIB", "zlib compression", "1.1.1.1.666.2");
        ASN1.addObject(runtime, 125, "extendedKeyUsage", "X509v3 Extended Key Usage", "2.5.29.37");
        ASN1.addObject(runtime, 126, "PKIX", null, "1.3.6.1.5.5.7");
        ASN1.addObject(runtime, 127, "id-kp", null, "1.3.6.1.5.5.7.3");
        ASN1.addObject(runtime, 128, "serverAuth", "TLS Web Server Authentication", "1.3.6.1.5.5.7.3.1");
        ASN1.addObject(runtime, 129, "clientAuth", "TLS Web Client Authentication", "1.3.6.1.5.5.7.3.2");
        ASN1.addObject(runtime, 130, "codeSigning", "Code Signing", "1.3.6.1.5.5.7.3.3");
        ASN1.addObject(runtime, 131, "emailProtection", "E-mail Protection", "1.3.6.1.5.5.7.3.4");
        ASN1.addObject(runtime, 132, "timeStamping", "Time Stamping", "1.3.6.1.5.5.7.3.8");
        ASN1.addObject(runtime, 133, "msCodeInd", "Microsoft Individual Code Signing", "1.3.6.1.4.1.311.2.1.21");
        ASN1.addObject(runtime, 134, "msCodeCom", "Microsoft Commercial Code Signing", "1.3.6.1.4.1.311.2.1.22");
        ASN1.addObject(runtime, 135, "msCTLSign", "Microsoft Trust List Signing", "1.3.6.1.4.1.311.10.3.1");
        ASN1.addObject(runtime, 136, "msSGC", "Microsoft Server Gated Crypto", "1.3.6.1.4.1.311.10.3.3");
        ASN1.addObject(runtime, 137, "msEFS", "Microsoft Encrypted File System", "1.3.6.1.4.1.311.10.3.4");
        ASN1.addObject(runtime, 138, "nsSGC", "Netscape Server Gated Crypto", "2.16.840.1.113730.4.1");
        ASN1.addObject(runtime, 139, "deltaCRL", "X509v3 Delta CRL Indicator", "2.5.29.27");
        ASN1.addObject(runtime, 140, "CRLReason", "CRL Reason Code", "2.5.29.21");
        ASN1.addObject(runtime, 141, "invalidityDate", "Invalidity Date", "2.5.29.24");
        ASN1.addObject(runtime, 142, "SXNetID", "Strong Extranet ID", "1.3.101.1.4.1");
        ASN1.addObject(runtime, 143, "PBE-SHA1-RC4-128", "pbeWithSHA1And128BitRC4", "1.2.840.113549.1.12.1.1");
        ASN1.addObject(runtime, 144, "PBE-SHA1-RC4-40", "pbeWithSHA1And40BitRC4", "1.2.840.113549.1.12.1.2");
        ASN1.addObject(runtime, 145, "PBE-SHA1-3DES", "pbeWithSHA1And3-KeyTripleDES-CBC", "1.2.840.113549.1.12.1.3");
        ASN1.addObject(runtime, 146, "PBE-SHA1-2DES", "pbeWithSHA1And2-KeyTripleDES-CBC", "1.2.840.113549.1.12.1.4");
        ASN1.addObject(runtime, 147, "PBE-SHA1-RC2-128", "pbeWithSHA1And128BitRC2-CBC", "1.2.840.113549.1.12.1.5");
        ASN1.addObject(runtime, 148, "PBE-SHA1-RC2-40", "pbeWithSHA1And40BitRC2-CBC", "1.2.840.113549.1.12.1.6");
        ASN1.addObject(runtime, 149, null, "keyBag", "1.2.840.113549.1.12.10.1.1");
        ASN1.addObject(runtime, 150, null, "pkcs8ShroudedKeyBag", "1.2.840.113549.1.12.10.1.2");
        ASN1.addObject(runtime, 151, null, "certBag", "1.2.840.113549.1.12.10.1.3");
        ASN1.addObject(runtime, 152, null, "crlBag", "1.2.840.113549.1.12.10.1.4");
        ASN1.addObject(runtime, 153, null, "secretBag", "1.2.840.113549.1.12.10.1.5");
        ASN1.addObject(runtime, 154, null, "safeContentsBag", "1.2.840.113549.1.12.10.1.6");
        ASN1.addObject(runtime, 155, null, "PBES2", "1.2.840.113549.1.5.13");
        ASN1.addObject(runtime, 156, null, "PBMAC1", "1.2.840.113549.1.5.14");
        ASN1.addObject(runtime, 157, null, "hmacWithSHA1", "1.2.840.113549.2.7");
        ASN1.addObject(runtime, 158, "id-qt-cps", "Policy Qualifier CPS", "1.3.6.1.5.5.7.2.1");
        ASN1.addObject(runtime, 159, "id-qt-unotice", "Policy Qualifier User Notice", "1.3.6.1.5.5.7.2.2");
        ASN1.addObject(runtime, 160, "RC2-64-CBC", "rc2-64-cbc", null);
        ASN1.addObject(runtime, 161, "SMIME-CAPS", "S/MIME Capabilities", "1.2.840.113549.1.9.15");
        ASN1.addObject(runtime, 162, "PBE-MD2-RC2-64", "pbeWithMD2AndRC2-CBC", "1.2.840.113549.1.5.4");
        ASN1.addObject(runtime, 163, "PBE-MD5-RC2-64", "pbeWithMD5AndRC2-CBC", "1.2.840.113549.1.5.6");
        ASN1.addObject(runtime, 164, "PBE-SHA1-DES", "pbeWithSHA1AndDES-CBC", "1.2.840.113549.1.5.10");
        ASN1.addObject(runtime, 165, "msExtReq", "Microsoft Extension Request", "1.3.6.1.4.1.311.2.1.14");
        ASN1.addObject(runtime, 166, "extReq", "Extension Request", "1.2.840.113549.1.9.14");
        ASN1.addObject(runtime, 167, "name", "name", "2.5.4.41");
        ASN1.addObject(runtime, 168, "dnQualifier", "dnQualifier", "2.5.4.46");
        ASN1.addObject(runtime, 169, "id-pe", null, "1.3.6.1.5.5.7.1");
        ASN1.addObject(runtime, 170, "id-ad", null, "1.3.6.1.5.5.7.48");
        ASN1.addObject(runtime, 171, "authorityInfoAccess", "Authority Information Access", "1.3.6.1.5.5.7.1.1");
        ASN1.addObject(runtime, 172, "OCSP", "OCSP", "1.3.6.1.5.5.7.48.1");
        ASN1.addObject(runtime, 173, "caIssuers", "CA Issuers", "1.3.6.1.5.5.7.48.2");
        ASN1.addObject(runtime, 174, "OCSPSigning", "OCSP Signing", "1.3.6.1.5.5.7.3.9");
        ASN1.addObject(runtime, 175, "AES-128-EBC", "aes-128-ebc", "2.16.840.1.101.3.4.1.1");
        ASN1.addObject(runtime, 176, "AES-128-CBC", "aes-128-cbc", "2.16.840.1.101.3.4.1.2");
        ASN1.addObject(runtime, 177, "AES-128-OFB", "aes-128-ofb", "2.16.840.1.101.3.4.1.3");
        ASN1.addObject(runtime, 178, "AES-128-CFB", "aes-128-cfb", "2.16.840.1.101.3.4.1.4");
        ASN1.addObject(runtime, 179, "AES-192-EBC", "aes-192-ebc", "2.16.840.1.101.3.4.1.21");
        ASN1.addObject(runtime, 180, "AES-192-CBC", "aes-192-cbc", "2.16.840.1.101.3.4.1.22");
        ASN1.addObject(runtime, 181, "AES-192-OFB", "aes-192-ofb", "2.16.840.1.101.3.4.1.23");
        ASN1.addObject(runtime, 182, "AES-192-CFB", "aes-192-cfb", "2.16.840.1.101.3.4.1.24");
        ASN1.addObject(runtime, 183, "AES-256-EBC", "aes-256-ebc", "2.16.840.1.101.3.4.1.41");
        ASN1.addObject(runtime, 184, "AES-256-CBC", "aes-256-cbc", "2.16.840.1.101.3.4.1.42");
        ASN1.addObject(runtime, 185, "AES-256-OFB", "aes-256-ofb", "2.16.840.1.101.3.4.1.43");
        ASN1.addObject(runtime, 186, "AES-256-CFB", "aes-256-cfb", "2.16.840.1.101.3.4.1.44");
        ASN1.addObject(runtime, 672, "SHA256", "sha256", "2.16.840.1.101.3.4.2.1");
        ASN1.addObject(runtime, 660, "street", "streetAddress", "2.5.4.9");
        ASN1.addObject(runtime, 391, "DC", "domainComponent", "0.9.2342.19200300.100.1.25");
    }

    private static void addObject(Ruby runtime, int nid, String sn2, String ln2, String oid2) {
        if (oid2 != null && (sn2 != null || ln2 != null)) {
            ASN1ObjectIdentifier objectId = new ASN1ObjectIdentifier(oid2);
            if (sn2 != null) {
                ASN1.symToOid(runtime).put(sn2.toLowerCase(), objectId);
            }
            if (ln2 != null) {
                ASN1.symToOid(runtime).put(ln2.toLowerCase(), objectId);
            }
            ASN1.oidToSym(runtime).put(objectId, sn2 == null ? ln2 : sn2);
            ASN1.oidToNid(runtime).put(objectId, nid);
            ASN1.nidToOid(runtime).put(nid, objectId);
            ASN1.nidToSn(runtime).put(nid, sn2);
            ASN1.nidToLn(runtime).put(nid, ln2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, ASN1ObjectIdentifier> symToOid(Ruby runtime) {
        Map<String, ASN1ObjectIdentifier> map = SYM_TO_OID.get(runtime);
        if (map != null) return map;
        Class<ASN1> clazz = ASN1.class;
        synchronized (ASN1.class) {
            map = SYM_TO_OID.get(runtime);
            if (map != null) return map;
            ASN1.initMaps(runtime);
            return SYM_TO_OID.get(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<ASN1ObjectIdentifier, String> oidToSym(Ruby runtime) {
        Map<ASN1ObjectIdentifier, String> map = OID_TO_SYM.get(runtime);
        if (map != null) return map;
        Class<ASN1> clazz = ASN1.class;
        synchronized (ASN1.class) {
            map = OID_TO_SYM.get(runtime);
            if (map != null) return map;
            ASN1.initMaps(runtime);
            return OID_TO_SYM.get(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Integer, ASN1ObjectIdentifier> nidToOid(Ruby runtime) {
        Map<Integer, ASN1ObjectIdentifier> map = NID_TO_OID.get(runtime);
        if (map != null) return map;
        Class<ASN1> clazz = ASN1.class;
        synchronized (ASN1.class) {
            map = NID_TO_OID.get(runtime);
            if (map != null) return map;
            ASN1.initMaps(runtime);
            return NID_TO_OID.get(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<ASN1ObjectIdentifier, Integer> oidToNid(Ruby runtime) {
        Map<ASN1ObjectIdentifier, Integer> map = OID_TO_NID.get(runtime);
        if (map != null) return map;
        Class<ASN1> clazz = ASN1.class;
        synchronized (ASN1.class) {
            map = OID_TO_NID.get(runtime);
            if (map != null) return map;
            ASN1.initMaps(runtime);
            return OID_TO_NID.get(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Integer, String> nidToSn(Ruby runtime) {
        Map<Integer, String> map = NID_TO_SN.get(runtime);
        if (map != null) return map;
        Class<ASN1> clazz = ASN1.class;
        synchronized (ASN1.class) {
            map = NID_TO_SN.get(runtime);
            if (map != null) return map;
            ASN1.initMaps(runtime);
            return NID_TO_SN.get(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Integer, String> nidToLn(Ruby runtime) {
        Map<Integer, String> map = NID_TO_LN.get(runtime);
        if (map != null) return map;
        Class<ASN1> clazz = ASN1.class;
        synchronized (ASN1.class) {
            map = NID_TO_LN.get(runtime);
            if (map != null) return map;
            ASN1.initMaps(runtime);
            return NID_TO_LN.get(runtime);
        }
    }

    static String ln2oid(Ruby runtime, String ln2) {
        Map<String, ASN1ObjectIdentifier> map = ASN1.symToOid(runtime);
        ASN1ObjectIdentifier val = map.get(ln2);
        if (val == null) {
            throw new NullPointerException("oid not found for ln = '" + ln2 + "' (" + runtime + ")");
        }
        return val.getId();
    }

    static Integer oid2nid(Ruby runtime, ASN1ObjectIdentifier oid2) {
        return ASN1.oidToNid(runtime).get(oid2);
    }

    static String o2a(Ruby runtime, ASN1ObjectIdentifier oid2) {
        return ASN1.o2a(runtime, oid2, false);
    }

    static String o2a(Ruby runtime, ASN1ObjectIdentifier oid2, boolean silent) {
        Integer nid = ASN1.oidToNid(runtime).get(oid2);
        if (nid != null) {
            String name2 = ASN1.nid2ln(runtime, nid, false);
            return name2 == null ? ASN1.nid2sn(runtime, nid, false) : name2;
        }
        nid = ASN1Registry.oid2nid(oid2);
        if (nid == null) {
            if (silent) {
                return null;
            }
            throw new NullPointerException("nid not found for oid = '" + oid2 + "' (" + runtime + ")");
        }
        String name3 = ASN1.nid2ln(runtime, nid, false);
        if (name3 != null) {
            return name3;
        }
        return ASN1.nid2sn(runtime, nid, true);
    }

    static String oid2name(Ruby runtime, ASN1ObjectIdentifier oid2, boolean silent) {
        Integer nid = ASN1.oidToNid(runtime).get(oid2);
        if (nid != null) {
            String name2 = ASN1.nid2sn(runtime, nid, false);
            return name2 == null ? ASN1.nid2ln(runtime, nid, false) : name2;
        }
        nid = ASN1Registry.oid2nid(oid2);
        if (nid == null) {
            if (silent) {
                return null;
            }
            throw new NullPointerException("nid not found for oid = '" + oid2 + "' (" + runtime + ")");
        }
        String name3 = ASN1.nid2sn(runtime, nid, false);
        if (name3 != null) {
            return name3;
        }
        return ASN1.nid2ln(runtime, nid, true);
    }

    static String oid2name(Ruby runtime, String oid2) {
        return ASN1.oid2name(runtime, new ASN1ObjectIdentifier(oid2), false);
    }

    static String nid2sn(Ruby runtime, Integer nid) {
        return ASN1.nid2sn(runtime, nid, true);
    }

    private static String nid2sn(Ruby runtime, Integer nid, boolean fallback) {
        String ln2 = ASN1.nidToSn(runtime).get(nid);
        if (ln2 == null && fallback) {
            return ASN1Registry.nid2sn(nid);
        }
        return ln2;
    }

    static String nid2ln(Ruby runtime, Integer nid) {
        return ASN1.nid2ln(runtime, nid, true);
    }

    private static String nid2ln(Ruby runtime, Integer nid, boolean fallback) {
        String ln2 = ASN1.nidToLn(runtime).get(nid);
        if (ln2 == null && fallback) {
            return ASN1Registry.nid2ln(nid);
        }
        return ln2;
    }

    static String oid2Sym(Ruby runtime, ASN1ObjectIdentifier oid2) {
        return ASN1.oid2Sym(runtime, oid2, false);
    }

    static String oid2Sym(Ruby runtime, ASN1ObjectIdentifier oid2, boolean fallback) {
        String sym = ASN1.getSymLookup(runtime).get(oid2);
        return sym == null && fallback ? ASN1Registry.oid2sym(oid2) : sym;
    }

    static ASN1ObjectIdentifier sym2Oid(Ruby runtime, String name2) {
        return ASN1.getOIDLookup(runtime).get(name2);
    }

    private static Map<String, ASN1ObjectIdentifier> getOIDLookup(Ruby runtime) {
        return ASN1.symToOid(runtime);
    }

    private static Map<ASN1ObjectIdentifier, String> getSymLookup(Ruby runtime) {
        return ASN1.oidToSym(runtime);
    }

    private static Integer typeId(Class<?> type) {
        Integer id2 = null;
        while (type != Object.class && id2 == null) {
            id2 = JCLASS_TO_ID.get(type);
            if (id2 != null) continue;
            type = type.getSuperclass();
        }
        return id2;
    }

    static Integer typeId(ASN1Encodable obj) {
        return ASN1.typeId(obj.getClass());
    }

    private static Integer typeId(RubyClass metaClass) {
        String name2 = metaClass.getRealClass().getBaseName();
        Integer id2 = RCLASS_TO_ID.get(name2);
        return id2 == null ? null : id2;
    }

    static Class<? extends ASN1Encodable> typeClass(RubyClass metaClass) {
        Integer tag = ASN1.typeId(metaClass);
        if (tag == null) {
            return null;
        }
        return (Class)ASN1_INFO[tag][1];
    }

    static Class<? extends ASN1Encodable> typeClass(int typeId) {
        return (Class)ASN1_INFO[typeId][1];
    }

    static ASN1Encodable typeInstance(Class<? extends ASN1Encodable> type, Object value2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method getInstance;
        block5: {
            getInstance = null;
            try {
                getInstance = type.getMethod("getInstance", Object.class);
            }
            catch (NoSuchMethodException e) {
                Class<? extends ASN1Encodable> superType = type.getSuperclass();
                try {
                    if (superType != Object.class) {
                        getInstance = type.getSuperclass().getMethod("getInstance", Object.class);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (getInstance != null) break block5;
                throw e;
            }
        }
        return (ASN1Encodable)getInstance.invoke(null, value2);
    }

    public static void createASN1(Ruby runtime, RubyModule OpenSSL2) {
        RubyModule ASN12 = OpenSSL2.defineModuleUnder("ASN1");
        RubyClass OpenSSLError = OpenSSL2.getClass("OpenSSLError");
        ASN12.defineClassUnder("ASN1Error", OpenSSLError, OpenSSLError.getAllocator());
        ASN12.defineAnnotatedMethods(ASN1.class);
        RubyArray UNIVERSAL_TAG_NAME = runtime.newArray(ASN1_INFO.length);
        for (int i2 = 0; i2 < ASN1_INFO.length; ++i2) {
            String name2 = (String)ASN1_INFO[i2][0];
            if (name2.charAt(0) != '[') {
                UNIVERSAL_TAG_NAME.append((IRubyObject)runtime.newString(name2));
                ASN12.setConstant(name2, (IRubyObject)runtime.newFixnum(i2));
                continue;
            }
            UNIVERSAL_TAG_NAME.append(runtime.getNil());
        }
        ASN12.setConstant("UNIVERSAL_TAG_NAME", (IRubyObject)UNIVERSAL_TAG_NAME);
        ThreadContext context2 = runtime.getCurrentContext();
        ObjectAllocator asn1DataAllocator = ASN1Data.ALLOCATOR;
        RubyClass _ASN1Data = ASN12.defineClassUnder("ASN1Data", runtime.getObject(), asn1DataAllocator);
        _ASN1Data.addReadWriteAttribute(context2, "value");
        _ASN1Data.addReadWriteAttribute(context2, "tag");
        _ASN1Data.addReadWriteAttribute(context2, "tag_class");
        _ASN1Data.defineAnnotatedMethods(ASN1Data.class);
        ObjectAllocator primitiveAllocator = Primitive.ALLOCATOR;
        RubyClass Primitive2 = ASN12.defineClassUnder("Primitive", _ASN1Data, primitiveAllocator);
        Primitive2.addReadWriteAttribute(context2, "tagging");
        Primitive2.addReadAttribute(context2, "infinite_length");
        Primitive2.defineAnnotatedMethods(Primitive.class);
        ObjectAllocator constructiveAllocator = Constructive.ALLOCATOR;
        RubyClass Constructive2 = ASN12.defineClassUnder("Constructive", _ASN1Data, constructiveAllocator);
        Constructive2.includeModule((IRubyObject)runtime.getModule("Enumerable"));
        Constructive2.addReadWriteAttribute(context2, "tagging");
        Constructive2.addReadWriteAttribute(context2, "infinite_length");
        Constructive2.defineAnnotatedMethods(Constructive.class);
        ASN12.defineClassUnder("Boolean", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("Integer", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("Null", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("Object", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("Enumerated", Primitive2, primitiveAllocator);
        RubyClass BitString = ASN12.defineClassUnder("BitString", Primitive2, primitiveAllocator);
        BitString.addReadWriteAttribute(context2, "unused_bits");
        ASN12.defineClassUnder("OctetString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("UTF8String", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("NumericString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("PrintableString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("T61String", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("VideotexString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("IA5String", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("GraphicString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("ISO64String", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("GeneralString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("UniversalString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("BMPString", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("UTCTime", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("GeneralizedTime", Primitive2, primitiveAllocator);
        ASN12.defineClassUnder("EndOfContent", Primitive2, primitiveAllocator);
        RubyClass ObjectId2 = ASN12.defineClassUnder("ObjectId", Primitive2, primitiveAllocator);
        ObjectId2.defineAnnotatedMethods(ObjectId.class);
        ASN12.defineClassUnder("Sequence", Constructive2, Constructive2.getAllocator());
        ASN12.defineClassUnder("Set", Constructive2, Constructive2.getAllocator());
    }

    static ASN1ObjectIdentifier getObjectID(Ruby runtime, String nameOrOid) throws IllegalArgumentException {
        String name2 = nameOrOid.toLowerCase();
        ASN1ObjectIdentifier objectId = ASN1.getOIDLookup(runtime).get(name2);
        if (objectId != null) {
            return objectId;
        }
        String objectIdStr = ASN1Registry.getOIDLookup().get(name2);
        if (objectIdStr != null) {
            return ASN1.toObjectID(objectIdStr, false);
        }
        return new ASN1ObjectIdentifier(nameOrOid);
    }

    static ASN1ObjectIdentifier toObjectID(String oid2, boolean silent) throws IllegalArgumentException {
        try {
            return new ASN1ObjectIdentifier(oid2);
        }
        catch (IllegalArgumentException e) {
            if (silent) {
                return null;
            }
            throw e;
        }
    }

    @JRubyMethod(name={"Boolean"}, module=true, rest=true)
    public static IRubyObject fact_Boolean(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "Boolean", args);
    }

    @JRubyMethod(name={"Integer"}, module=true, rest=true)
    public static IRubyObject fact_Integer(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "Integer", args);
    }

    @JRubyMethod(name={"Enumerated"}, module=true, rest=true)
    public static IRubyObject fact_Enumerated(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "Enumerated", args);
    }

    @JRubyMethod(name={"BitString"}, module=true, rest=true)
    public static IRubyObject fact_BitString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "BitString", args);
    }

    @JRubyMethod(name={"OctetString"}, module=true, rest=true)
    public static IRubyObject fact_OctetString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "OctetString", args);
    }

    @JRubyMethod(name={"UTF8String"}, module=true, rest=true)
    public static IRubyObject fact_UTF8String(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "UTF8String", args);
    }

    @JRubyMethod(name={"NumericString"}, module=true, rest=true)
    public static IRubyObject fact_NumericString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "NumericString", args);
    }

    @JRubyMethod(name={"PrintableString"}, module=true, rest=true)
    public static IRubyObject fact_PrintableString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "PrintableString", args);
    }

    @JRubyMethod(name={"T61String"}, module=true, rest=true)
    public static IRubyObject fact_T61String(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "T61String", args);
    }

    @JRubyMethod(name={"VideotexString"}, module=true, rest=true)
    public static IRubyObject fact_VideotexString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "VideotexString", args);
    }

    @JRubyMethod(name={"IA5String"}, module=true, rest=true)
    public static IRubyObject fact_IA5String(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "IA5String", args);
    }

    @JRubyMethod(name={"GraphicString"}, module=true, rest=true)
    public static IRubyObject fact_GraphicString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "GraphicString", args);
    }

    @JRubyMethod(name={"ISO64String"}, module=true, rest=true)
    public static IRubyObject fact_ISO64String(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "ISO64String", args);
    }

    @JRubyMethod(name={"GeneralString"}, module=true, rest=true)
    public static IRubyObject fact_GeneralString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "GeneralString", args);
    }

    @JRubyMethod(name={"UniversalString"}, module=true, rest=true)
    public static IRubyObject fact_UniversalString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "UniversalString", args);
    }

    @JRubyMethod(name={"BMPString"}, module=true, rest=true)
    public static IRubyObject fact_BMPString(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "BMPString", args);
    }

    @JRubyMethod(name={"Nul"}, module=true, rest=true)
    public static IRubyObject fact_Null(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "Null", args);
    }

    @JRubyMethod(name={"ObjectId"}, module=true, rest=true)
    public static IRubyObject fact_ObjectId(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "ObjectId", args);
    }

    @JRubyMethod(name={"UTCTime"}, module=true, rest=true)
    public static IRubyObject fact_UTCTime(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "UTCTime", args);
    }

    @JRubyMethod(name={"GeneralizedTime"}, module=true, rest=true)
    public static IRubyObject fact_GeneralizedTime(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "GeneralizedTime", args);
    }

    @JRubyMethod(name={"Sequence"}, module=true, rest=true)
    public static IRubyObject fact_Sequence(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "Sequence", args);
    }

    @JRubyMethod(name={"Set"}, module=true, rest=true)
    public static IRubyObject fact_Set(ThreadContext context2, IRubyObject self, IRubyObject[] args) {
        return ASN1.newInstance(context2, self, "Set", args);
    }

    private static IRubyObject newInstance(ThreadContext context2, IRubyObject parent, String className, IRubyObject[] args) {
        return ((RubyModule)parent).getClass(className).newInstance(context2, args, Block.NULL_BLOCK);
    }

    static IRubyObject decodeObject(ThreadContext context2, RubyModule ASN12, ASN1Encodable obj) throws IOException, IllegalArgumentException {
        Ruby runtime = context2.runtime;
        if (obj instanceof ASN1Integer) {
            BN val = BN.newBN(runtime, ((ASN1Integer)obj).getValue());
            return ASN12.getClass("Integer").newInstance(context2, (IRubyObject)val, Block.NULL_BLOCK);
        }
        if (obj instanceof DERInteger) {
            BN val = BN.newBN(runtime, ((DERInteger)obj).getValue());
            return ASN12.getClass("Integer").newInstance(context2, (IRubyObject)val, Block.NULL_BLOCK);
        }
        if (obj instanceof DERBitString) {
            DERBitString derObj = (DERBitString)obj;
            RubyString str = runtime.newString(new ByteList(derObj.getBytes(), false));
            IRubyObject bitString = ASN12.getClass("BitString").newInstance(context2, (IRubyObject)str, Block.NULL_BLOCK);
            bitString.callMethod(context2, "unused_bits=", (IRubyObject)runtime.newFixnum(derObj.getPadBits()));
            return bitString;
        }
        if (obj instanceof ASN1String) {
            ByteList bytes;
            String type;
            Integer typeId = ASN1.typeId(obj.getClass());
            String string = type = typeId == null ? null : (String)ASN1_INFO[typeId][2];
            if (obj instanceof DERUTF8String) {
                if (type == null) {
                    type = "UTF8String";
                }
                bytes = new ByteList(((DERUTF8String)obj).getString().getBytes("UTF-8"), false);
            } else {
                if (type == null) {
                    if (obj instanceof DERNumericString) {
                        type = "NumericString";
                    } else if (obj instanceof DERPrintableString) {
                        type = "PrintableString";
                    } else if (obj instanceof DERIA5String) {
                        type = "IA5String";
                    } else if (obj instanceof DERT61String) {
                        type = "T61String";
                    } else if (obj instanceof DERGeneralString) {
                        type = "GeneralString";
                    } else if (obj instanceof DERUniversalString) {
                        type = "UniversalString";
                    } else if (obj instanceof DERBMPString) {
                        type = "BMPString";
                    } else {
                        throw new IllegalArgumentException("could not handle ASN1 string type: " + obj + " (" + obj.getClass().getName() + ")");
                    }
                }
                bytes = ByteList.create((CharSequence)((ASN1String)obj).getString());
            }
            return ASN12.getClass(type).newInstance(context2, (IRubyObject)runtime.newString(bytes), Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1OctetString) {
            ByteList octets = new ByteList(((ASN1OctetString)obj).getOctets(), false);
            return ASN12.getClass("OctetString").newInstance(context2, (IRubyObject)runtime.newString(octets), Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1Null) {
            return ASN12.getClass("Null").newInstance(context2, runtime.getNil(), Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1Boolean) {
            boolean val = ((ASN1Boolean)obj).isTrue();
            return ASN12.getClass("Boolean").newInstance(context2, (IRubyObject)runtime.newBoolean(val), Block.NULL_BLOCK);
        }
        if (obj instanceof DERBoolean) {
            boolean val = ((DERBoolean)obj).isTrue();
            return ASN12.getClass("Boolean").newInstance(context2, (IRubyObject)runtime.newBoolean(val), Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1UTCTime) {
            Date adjustedTime;
            try {
                adjustedTime = ((ASN1UTCTime)obj).getAdjustedDate();
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            RubyTime time2 = RubyTime.newTime((Ruby)runtime, (long)adjustedTime.getTime());
            return ASN12.getClass("UTCTime").newInstance(context2, (IRubyObject)time2, Block.NULL_BLOCK);
        }
        if (obj instanceof DERUTCTime) {
            Date adjustedTime;
            try {
                adjustedTime = ((DERUTCTime)obj).getAdjustedDate();
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            RubyTime time3 = RubyTime.newTime((Ruby)runtime, (long)adjustedTime.getTime());
            return ASN12.getClass("UTCTime").newInstance(context2, (IRubyObject)time3, Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1GeneralizedTime) {
            Date generalTime;
            try {
                generalTime = ((ASN1GeneralizedTime)obj).getDate();
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            RubyTime time4 = RubyTime.newTime((Ruby)runtime, (long)generalTime.getTime());
            return ASN12.getClass("GeneralizedTime").newInstance(context2, (IRubyObject)time4, Block.NULL_BLOCK);
        }
        if (obj instanceof DERGeneralizedTime) {
            Date generalTime;
            try {
                generalTime = ((DERGeneralizedTime)obj).getDate();
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            RubyTime time5 = RubyTime.newTime((Ruby)runtime, (long)generalTime.getTime());
            return ASN12.getClass("GeneralizedTime").newInstance(context2, (IRubyObject)time5, Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1ObjectIdentifier) {
            String objId = ((ASN1ObjectIdentifier)obj).getId();
            return ASN12.getClass("ObjectId").newInstance(context2, (IRubyObject)runtime.newString(objId), Block.NULL_BLOCK);
        }
        if (obj instanceof DERObjectIdentifier) {
            String objId = ((DERObjectIdentifier)obj).getId();
            return ASN12.getClass("ObjectId").newInstance(context2, (IRubyObject)runtime.newString(objId), Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject taggedObj = (ASN1TaggedObject)obj;
            IRubyObject val = ASN1.decodeObject(context2, ASN12, (ASN1Encodable)taggedObj.getObject());
            RubyFixnum tag = runtime.newFixnum(taggedObj.getTagNo());
            RubySymbol tag_class = runtime.newSymbol("CONTEXT_SPECIFIC");
            RubyArray valArr = runtime.newArray(val);
            return ASN12.getClass("ASN1Data").newInstance(context2, new IRubyObject[]{valArr, tag, tag_class}, Block.NULL_BLOCK);
        }
        if (obj instanceof DERApplicationSpecific) {
            DERApplicationSpecific appSpecific = (DERApplicationSpecific)obj;
            RubyFixnum tag = runtime.newFixnum(appSpecific.getApplicationTag());
            RubySymbol tag_class = runtime.newSymbol("APPLICATION");
            ASN1Sequence sequence = (ASN1Sequence)appSpecific.getObject(16);
            RubyArray valArr = ASN1.decodeObjects(context2, ASN12, sequence.getObjects());
            return ASN12.getClass("ASN1Data").newInstance(context2, new IRubyObject[]{valArr, tag, tag_class}, Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1Sequence) {
            RubyArray arr = ASN1.decodeObjects(context2, ASN12, ((ASN1Sequence)obj).getObjects());
            return ASN12.getClass("Sequence").newInstance(context2, (IRubyObject)arr, Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1Set) {
            RubyArray arr = ASN1.decodeObjects(context2, ASN12, ((ASN1Set)obj).getObjects());
            return ASN12.getClass("Set").newInstance(context2, (IRubyObject)arr, Block.NULL_BLOCK);
        }
        if (obj instanceof ASN1Enumerated) {
            RubyInteger value2 = RubyBignum.bignorm((Ruby)runtime, (BigInteger)((ASN1Enumerated)obj).getValue());
            return ASN12.getClass("Enumerated").newInstance(context2, (IRubyObject)value2, Block.NULL_BLOCK);
        }
        throw new IllegalArgumentException("unable to decode object: " + obj + " (" + (obj == null ? "" : obj.getClass().getName()) + ")");
    }

    private static RubyArray decodeObjects(ThreadContext context2, RubyModule ASN12, Enumeration<ASN1Encodable> e) throws IOException {
        RubyArray arr = context2.runtime.newArray();
        while (e.hasMoreElements()) {
            arr.append(ASN1.decodeObject(context2, ASN12, e.nextElement()));
        }
        return arr;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject decode(ThreadContext context2, IRubyObject self, IRubyObject obj) {
        try {
            return ASN1.decodeImpl(context2, (RubyModule)self, obj);
        }
        catch (IOException e) {
            throw ASN1.newASN1Error(context2.runtime, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            OpenSSL.debugStackTrace(context2.runtime, e);
            throw context2.runtime.newArgumentError(e.getMessage());
        }
    }

    static IRubyObject decodeImpl(ThreadContext context2, IRubyObject obj) throws IOException, IllegalArgumentException {
        return ASN1.decodeImpl(context2, ASN1._ASN1(context2.runtime), obj);
    }

    static IRubyObject decodeImpl(ThreadContext context2, RubyModule ASN12, IRubyObject obj) throws IOException, IllegalArgumentException {
        obj = OpenSSL.to_der_if_possible(context2, obj);
        BytesInputStream in = new BytesInputStream(obj.asString().getByteList());
        IRubyObject decoded = ASN1.decodeImpl(context2, ASN12, in);
        if (in.available() > 0) {
            int read2 = in.readCount();
            throw new IOException("Type mismatch. Total bytes read: " + read2 + " Bytes available: " + in.available());
        }
        return decoded;
    }

    private static IRubyObject decodeImpl(ThreadContext context2, RubyModule ASN12, BytesInputStream in) throws IOException, IllegalArgumentException {
        Integer tag = ASN1.getConstructiveTag(in.bytes(), in.offset());
        IRubyObject decoded = ASN1.decodeObject(context2, ASN12, (ASN1Encodable)ASN1.readObject(in));
        if (tag != null) {
            List<IRubyObject> value2 = null;
            if (tag == 16) {
                return Constructive.setInfiniteLength(context2, decoded);
            }
            if (tag == 17) {
                return Constructive.setInfiniteLength(context2, decoded);
            }
            String type = "Constructive";
            if (value2 == null) {
                value2 = Collections.singletonList(decoded);
            }
            return Constructive.newInfiniteConstructive(context2, type, value2, tag);
        }
        return decoded;
    }

    @JRubyMethod(meta=true, required=1)
    public static IRubyObject decode_all(ThreadContext context2, IRubyObject self, IRubyObject obj) {
        obj = OpenSSL.to_der_if_possible(context2, obj);
        BytesInputStream in = new BytesInputStream(obj.asString().getByteList());
        RubyModule ASN12 = ASN1._ASN1(context2.runtime);
        RubyArray arr = context2.runtime.newArray();
        while (in.available() > 0) {
            try {
                in.mark(0);
                arr.append(ASN1.decodeImpl(context2, ASN12, in));
            }
            catch (IOException e) {
                throw ASN1.newASN1Error(context2.runtime, e.getMessage());
            }
            catch (IllegalArgumentException e) {
                OpenSSL.debugStackTrace(context2.runtime, e);
                throw context2.runtime.newArgumentError(e.getMessage());
            }
        }
        return arr;
    }

    @JRubyMethod(meta=true, required=1)
    public static IRubyObject traverse(ThreadContext context2, IRubyObject self, IRubyObject arg) {
        OpenSSL.warn(context2, "WARNING: unimplemented method called: ASN1#traverse");
        return context2.runtime.getNil();
    }

    public static RaiseException newASN1Error(Ruby runtime, String message) {
        return Utils.newError(runtime, ASN1._ASN1(runtime).getClass("ASN1Error"), message, false);
    }

    static RubyModule _ASN1(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("ASN1");
    }

    static ASN1Primitive readObject(byte[] bytes) throws IOException {
        return new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes)).readObject();
    }

    private static ASN1Primitive readObject(InputStream bytes) throws IOException {
        return new ASN1InputStream(bytes).readObject();
    }

    private static Integer getConstructiveTag(byte[] asn1, int offset) {
        int tag = asn1[offset] & 0xFF;
        if ((tag & 0x20) != 0) {
            int length;
            int tagNo = tag & 0x1F;
            if (tagNo == 31) {
                byte b;
                tagNo = 0;
                if (((b = asn1[++offset]) & 0x7F) == 0) {
                    return null;
                }
                while (b >= 0 && (b & 0x80) != 0) {
                    tagNo |= b & 0x7F;
                    tagNo <<= 7;
                    b = asn1[++offset];
                }
                if (b < 0) {
                    return null;
                }
                tagNo |= b & 0x7F;
            }
            if ((length = asn1[++offset] & 0xFF) != 128) {
                return null;
            }
            if ((tag & 0x40) != 0) {
                // empty if block
            }
            if ((tag & 0x80) != 0) {
                // empty if block
            }
            switch (tagNo) {
                case 16: {
                    return 16;
                }
                case 17: {
                    return 17;
                }
                case 4: {
                    return 4;
                }
            }
            return 0;
        }
        return null;
    }

    static /* synthetic */ Object[][] access$300() {
        return ASN1_INFO;
    }

    static {
        for (int i2 = 0; i2 < ASN1_INFO.length; ++i2) {
            Object[] info = ASN1_INFO[i2];
            if (info[1] != null) {
                JCLASS_TO_ID.put((Class)info[1], i2);
            }
            if (info[2] == null) continue;
            RCLASS_TO_ID.put((String)info[2], i2);
        }
    }

    public static class Constructive
    extends ASN1Data {
        private static final long serialVersionUID = -7166662655104776828L;
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Constructive(runtime, klass);
            }
        };

        public Constructive(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        @JRubyMethod(required=1, optional=3, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
            Primitive.initializeImpl(context2, this, args);
            return this;
        }

        static Constructive newInfiniteConstructive(ThreadContext context2, String type, List<IRubyObject> value2, int defaultTag) {
            Ruby runtime = context2.runtime;
            RubyClass klass = ASN1._ASN1(context2.runtime).getClass(type);
            Constructive self = new Constructive(runtime, klass);
            RubyArray values = runtime.newArray(value2.size());
            for (IRubyObject val : value2) {
                values.append(val);
            }
            self.setInstanceVariable("@tag", (IRubyObject)runtime.newFixnum(defaultTag));
            self.setInstanceVariable("@value", (IRubyObject)values);
            self.setInstanceVariable("@tag_class", (IRubyObject)runtime.newSymbol("UNIVERSAL"));
            self.setInstanceVariable("@tagging", context2.nil);
            return Constructive.setInfiniteLength(context2, (IRubyObject)self);
        }

        static Constructive setInfiniteLength(ThreadContext context2, IRubyObject constructive) {
            Constructive instance = (Constructive)constructive;
            Primitive eoc = Primitive.newEndOfContent(context2);
            IRubyObject value2 = instance.value(context2);
            if (value2 instanceof RubyArray) {
                ((RubyArray)value2).append((IRubyObject)eoc);
            } else {
                value2.callMethod(context2, "<<", (IRubyObject)eoc);
            }
            instance.setInstanceVariable("@infinite_length", (IRubyObject)context2.runtime.getTrue());
            return instance;
        }

        private boolean rawConstructive() {
            return "Constructive".equals(this.getClassBaseName());
        }

        private boolean isSequence() {
            return "Sequence".equals(this.getClassBaseName());
        }

        private boolean isSet() {
            return "Set".equals(this.getClassBaseName());
        }

        private boolean isInfiniteLength() {
            return this.getInstanceVariable("@infinite_length").isTrue();
        }

        @Override
        boolean isExplicitTagging() {
            IRubyObject tagging = this.getInstanceVariable("@tagging");
            if (tagging.isNil()) {
                return true;
            }
            return "EXPLICIT".equals(tagging.toString());
        }

        @Override
        boolean isImplicitTagging() {
            return "IMPLICIT".equals(this.getInstanceVariable("@tagging").toString());
        }

        @Override
        ASN1Encodable toASN1(ThreadContext context2) {
            if (this.isInfiniteLength()) {
                return super.toASN1(context2);
            }
            if (this.isSequence()) {
                return new DERSequence(this.toASN1EncodableVector(context2));
            }
            if (this.isSet()) {
                return new DLSet(this.toASN1EncodableVector(context2));
            }
            switch (this.getTag(context2)) {
                case 4: {
                    ASN1EncodableVector values = this.toASN1EncodableVector(context2);
                    ASN1OctetString[] octets = new ASN1OctetString[values.size()];
                    for (int i2 = 0; i2 < values.size(); ++i2) {
                        octets[i2] = (ASN1OctetString)values.get(i2).toASN1Primitive();
                    }
                    return new BEROctetString(octets);
                }
                case 16: {
                    return new DERSequence(this.toASN1EncodableVector(context2));
                }
                case 17: {
                    return new DLSet(this.toASN1EncodableVector(context2));
                }
            }
            throw new UnsupportedOperationException(this.inspect().toString());
        }

        @Override
        @JRubyMethod
        public IRubyObject to_der(ThreadContext context2) {
            if (this.rawConstructive() && !this.isInfiniteLength() && !super.value(context2).isNil()) {
                Ruby runtime = context2.runtime;
                throw ASN1.newASN1Error(runtime, "Constructive shall only be used with infinite length");
            }
            return super.to_der(context2);
        }

        @Override
        byte[] toDER(ThreadContext context2) throws IOException {
            if (this.isInfiniteLength()) {
                if (this.isSequence()) {
                    return this.sequenceToDER(context2);
                }
                if (this.isSet()) {
                    return this.setToDER(context2);
                }
                switch (this.getTag(context2)) {
                    case 4: {
                        return this.octetStringToDER(context2);
                    }
                    case 3: {
                        return this.bitStringToDER(context2);
                    }
                    case 16: {
                        return this.sequenceToDER(context2);
                    }
                    case 17: {
                        return this.setToDER(context2);
                    }
                }
                throw new UnsupportedOperationException(this.inspect().toString());
            }
            return super.toDER(context2);
        }

        private byte[] bitStringToDER(ThreadContext context2) throws IOException {
            ASN1EncodableVector values = this.toASN1EncodableVector(context2);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(35);
            out.write(128);
            for (int i2 = 0; i2 < values.size(); ++i2) {
                out.write(values.get(i2).toASN1Primitive().getEncoded());
            }
            out.write(0);
            out.write(0);
            return out.toByteArray();
        }

        private byte[] octetStringToDER(ThreadContext context2) throws IOException {
            ASN1EncodableVector values = this.toASN1EncodableVector(context2);
            ASN1OctetString[] octets = new ASN1OctetString[values.size()];
            for (int i2 = 0; i2 < values.size(); ++i2) {
                octets[i2] = (ASN1OctetString)values.get(i2).toASN1Primitive();
            }
            return new BEROctetString(octets).getEncoded();
        }

        private byte[] sequenceToDER(ThreadContext context2) throws IOException {
            ASN1EncodableVector values = this.toASN1EncodableVector(context2);
            ByteArrayOutputStream out = new ByteArrayOutputStream(64);
            BERSequenceGenerator sequenceGenerator = new BERSequenceGenerator((OutputStream)out);
            for (int i2 = 0; i2 < values.size(); ++i2) {
                ASN1Encodable value2 = values.get(i2);
                if (value2 instanceof InternalEncodable) {
                    byte[] nested = ((InternalEncodable)value2).entry.toDER(context2);
                    out.write(nested, 0, nested.length);
                    continue;
                }
                sequenceGenerator.addObject(values.get(i2));
            }
            sequenceGenerator.close();
            return out.toByteArray();
        }

        private byte[] setToDER(ThreadContext context2) throws IOException {
            ASN1EncodableVector values = this.toASN1EncodableVector(context2);
            return new BERSet(values).toASN1Primitive().getEncoded();
        }

        private ASN1EncodableVector toASN1EncodableVector(ThreadContext context2) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            IRubyObject value2 = this.value(context2);
            if (value2 instanceof RubyArray) {
                RubyArray val = (RubyArray)value2;
                for (int i2 = 0; i2 < val.size() && !Constructive.addEntry(context2, vec, val.entry(i2)); ++i2) {
                }
            } else {
                RubyFixnum idx;
                IRubyObject entry;
                int size2 = RubyInteger.num2int((IRubyObject)value2.callMethod(context2, "size"));
                for (int i3 = 0; i3 < size2 && !Constructive.addEntry(context2, vec, entry = value2.callMethod(context2, "[]", (IRubyObject)(idx = context2.runtime.newFixnum(i3)))); ++i3) {
                }
            }
            return vec;
        }

        public ASN1Primitive toASN1Primitive() {
            throw new UnsupportedOperationException();
        }

        private static boolean addEntry(ThreadContext context2, ASN1EncodableVector vec, IRubyObject entry) {
            try {
                if (entry instanceof Constructive) {
                    Constructive constructive = (Constructive)entry;
                    if (constructive.isInfiniteLength() || constructive.rawConstructive()) {
                        vec.add((ASN1Encodable)new InternalEncodable((Constructive)entry));
                    } else {
                        vec.add(constructive.toASN1(context2));
                    }
                } else if (entry instanceof ASN1Data) {
                    ASN1Data data = (ASN1Data)entry;
                    if (data.isEOC()) {
                        return true;
                    }
                    vec.add(data.toASN1(context2));
                } else {
                    vec.add(((ASN1Data)ASN1.decodeImpl(context2, entry)).toASN1(context2));
                }
                return false;
            }
            catch (IOException e) {
                throw Utils.newIOError(context2.runtime, e);
            }
        }

        @JRubyMethod
        public IRubyObject each(ThreadContext context2, Block block) {
            IRubyObject value2 = this.value(context2);
            if (value2 instanceof RubyArray) {
                RubyArray val = (RubyArray)value2;
                for (int i2 = 0; i2 < val.size(); ++i2) {
                    block.yield(context2, val.entry(i2));
                }
            } else {
                value2.callMethod(context2, "each", NULL_ARRAY, block);
            }
            return context2.runtime.getNil();
        }

        @JRubyMethod
        public IRubyObject size(ThreadContext context2) {
            IRubyObject value2 = this.value(context2);
            if (value2 instanceof RubyArray) {
                RubyArray val = (RubyArray)value2;
                return context2.runtime.newFixnum(val.size());
            }
            return value2.callMethod(context2, "size");
        }

        @Override
        protected void print(int indent) {
            PrintStream out = this.getRuntime().getOut();
            Constructive.printIndent(out, indent);
            out.print(this.getMetaClass().getRealClass().getBaseName());
            out.println(": ");
            Constructive.printArray(out, indent, (RubyArray)this.value(this.getRuntime().getCurrentContext()));
        }

        private static class InternalEncodable
        implements ASN1Encodable {
            final Constructive entry;

            InternalEncodable(Constructive entry) {
                this.entry = entry;
            }

            public ASN1Primitive toASN1Primitive() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class Primitive
    extends ASN1Data {
        private static final long serialVersionUID = 8489625559339190259L;
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Primitive(runtime, klass);
            }
        };

        public Primitive(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        @Override
        @JRubyMethod
        public IRubyObject to_der(ThreadContext context2) {
            if (this.value(context2).isNil()) {
                throw context2.runtime.newTypeError("nil value");
            }
            return super.to_der(context2);
        }

        @JRubyMethod(required=0, optional=4, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
            Primitive.initializeImpl(context2, this, args);
            return this;
        }

        static void initializeImpl(ThreadContext context2, ASN1Data self, IRubyObject[] args) {
            String baseName;
            IRubyObject tag;
            Ruby runtime = context2.runtime;
            int len = args.length;
            IRubyObject value2 = len == 0 ? runtime.getNil() : args[0];
            IRubyObject tagging = runtime.getNil();
            IRubyObject tag_class = runtime.getNil();
            if (len > 1) {
                tag = args[1];
                if (len > 2) {
                    tagging = args[2];
                    if (len > 3) {
                        tag_class = args[3];
                    }
                }
                if (tag.isNil()) {
                    throw ASN1.newASN1Error(runtime, "must specify tag number");
                }
                if (tagging.isNil()) {
                    tagging = runtime.newSymbol("EXPLICIT");
                }
                if (!(tagging instanceof RubySymbol)) {
                    throw ASN1.newASN1Error(runtime, "invalid tag default");
                }
                if (tag_class.isNil()) {
                    tag_class = runtime.newSymbol("CONTEXT_SPECIFIC");
                }
                if (!(tag_class instanceof RubySymbol)) {
                    throw ASN1.newASN1Error(runtime, "invalid tag class");
                }
                if (tagging.toString().equals("IMPLICIT") && RubyNumeric.fix2int((IRubyObject)tag) > MAX_TAG_VALUE) {
                    throw ASN1.newASN1Error(runtime, "tag number for Universal too large");
                }
            } else {
                tag = self.defaultTag();
                tag_class = runtime.newSymbol("UNIVERSAL");
            }
            if ("ObjectId".equals(baseName = self.getMetaClass().getRealClass().getBaseName())) {
                String name2;
                try {
                    name2 = ASN1.oid2Sym(runtime, ASN1.getObjectID(runtime, value2.toString()), true);
                }
                catch (IllegalArgumentException e) {
                    throw runtime.newTypeError(e.getMessage());
                }
                if (name2 != null) {
                    value2 = runtime.newString(name2);
                }
            }
            self.setInstanceVariable("@tag", tag);
            self.setInstanceVariable("@value", value2);
            self.setInstanceVariable("@tag_class", tag_class);
            self.setInstanceVariable("@tagging", tagging);
            self.setInstanceVariable("@infinite_length", (IRubyObject)runtime.getFalse());
        }

        @Override
        boolean isExplicitTagging() {
            return "EXPLICIT".equals(this.getInstanceVariable("@tagging").toString());
        }

        @Override
        boolean isImplicitTagging() {
            IRubyObject tagging = this.getInstanceVariable("@tagging");
            if (tagging.isNil()) {
                return true;
            }
            return "IMPLICIT".equals(tagging.toString());
        }

        @Override
        boolean isEOC() {
            return "EndOfContent".equals(this.getClassBaseName());
        }

        @Override
        byte[] toDER(ThreadContext context2) throws IOException {
            if (this.isEOC()) {
                return new byte[]{0, 0};
            }
            return this.toASN1(context2).toASN1Primitive().getEncoded("DER");
        }

        static Primitive newInstance(ThreadContext context2, String type, IRubyObject value2) {
            RubyClass klass = ASN1._ASN1(context2.runtime).getClass(type);
            Primitive self = new Primitive(context2.runtime, klass);
            if (value2 != null) {
                self.setInstanceVariable("@value", value2);
            }
            return self;
        }

        static Primitive newEndOfContent(ThreadContext context2) {
            return Primitive.newInstance(context2, "EndOfContent", null);
        }

        @Override
        ASN1Encodable toASN1(ThreadContext context2) {
            Class<? extends ASN1Encodable> type = ASN1.typeClass(this.getMetaClass());
            if (type == null) {
                int tag = this.getTag(context2);
                if (tag == 0) {
                    return null;
                }
                if (this.isExplicitTagging()) {
                    type = ASN1.typeClass(tag);
                }
                if (type == null) {
                    throw new IllegalArgumentException("no type for: " + this.getMetaClass() + " or tag: " + this.getTag(context2));
                }
            }
            IRubyObject val = this.callMethod(context2, "value");
            if (type == ASN1ObjectIdentifier.class || type == DERObjectIdentifier.class) {
                return ASN1.getObjectID(context2.runtime, val.toString());
            }
            if (type == DERNull.class || type == ASN1Null.class) {
                return DERNull.INSTANCE;
            }
            if (ASN1Boolean.class.isAssignableFrom(type)) {
                return ASN1Boolean.getInstance((boolean)val.isTrue());
            }
            if (type == DERBoolean.class) {
                return DERBoolean.getInstance((boolean)val.isTrue());
            }
            if (type == DERUTCTime.class) {
                if (val instanceof RubyTime) {
                    return new DERUTCTime(((RubyTime)val).getJavaDate());
                }
                return DERUTCTime.getInstance((Object)val.asString().getBytes());
            }
            if (type == DERGeneralizedTime.class) {
                if (val instanceof RubyTime) {
                    return new DERGeneralizedTime(((RubyTime)val).getJavaDate());
                }
                return DERGeneralizedTime.getInstance((Object)val.asString().getBytes());
            }
            if (type == DERInteger.class) {
                return new DERInteger(Primitive.bigIntegerValue(val));
            }
            if (ASN1Integer.class.isAssignableFrom(type)) {
                return new ASN1Integer(Primitive.bigIntegerValue(val));
            }
            if (type == DEREnumerated.class) {
                return new DEREnumerated(Primitive.bigIntegerValue(val));
            }
            if (type == ASN1Enumerated.class) {
                return new ASN1Enumerated(Primitive.bigIntegerValue(val));
            }
            if (ASN1OctetString.class.isAssignableFrom(type)) {
                return new DEROctetString(val.asString().getBytes());
            }
            if (type == DERBitString.class) {
                byte[] bs = val.asString().getBytes();
                int unused = 0;
                for (int i2 = bs.length - 1; i2 > -1; --i2) {
                    if (bs[i2] == 0) {
                        unused += 8;
                        continue;
                    }
                    byte v2 = bs[i2];
                    int x = 8;
                    while (v2 != 0) {
                        v2 = (byte)(v2 << 1);
                        --x;
                    }
                    unused += x;
                    break;
                }
                return new DERBitString(bs, unused);
            }
            if (type == DERIA5String.class) {
                return new DERIA5String(val.asString().toString());
            }
            if (type == DERUTF8String.class) {
                return new DERUTF8String(val.asString().toString());
            }
            if (type == DERBMPString.class) {
                return new DERBMPString(val.asString().toString());
            }
            if (type == DERUniversalString.class) {
                return new DERUniversalString(val.asString().getBytes());
            }
            if (type == DERGeneralString.class) {
                return DERGeneralString.getInstance((Object)val.asString().getBytes());
            }
            if (type == DERVisibleString.class) {
                return DERVisibleString.getInstance((Object)val.asString().getBytes());
            }
            if (type == DERNumericString.class) {
                return DERNumericString.getInstance((Object)val.asString().getBytes());
            }
            if (val instanceof RubyString) {
                try {
                    return ASN1.typeInstance(type, ((RubyString)val).getBytes());
                }
                catch (Exception e) {
                    OpenSSL.debugStackTrace(context2.runtime, e);
                    throw Primitive.createNativeRaiseException(context2, e);
                }
            }
            if (OpenSSL.isDebug(context2.runtime)) {
                OpenSSL.debug((Object)((Object)this) + " toASN1() could not handle class " + this.getMetaClass() + " and value " + val.inspect() + " (" + val.getClass().getName() + ")");
            }
            OpenSSL.warn(context2, "WARNING: unimplemented method called: ASN1Data#toASN1 (" + type + ")");
            return null;
        }

        private static BigInteger bigIntegerValue(IRubyObject val) {
            if (val instanceof RubyInteger) {
                return ((RubyInteger)val).getBigIntegerValue();
            }
            if (val instanceof BN) {
                ((BN)val).getValue();
            }
            return new BigInteger(val.asString().getBytes());
        }

        @Override
        protected void print(int indent) {
            PrintStream out = this.getRuntime().getOut();
            Primitive.printIndent(out, indent);
            out.print(this.getMetaClass().getRealClass().getBaseName());
            out.print(": ");
            out.println(this.value().callMethod(this.getRuntime().getCurrentContext(), "inspect").toString());
        }
    }

    public static class ASN1Data
    extends RubyObject {
        private static final long serialVersionUID = 6117598347932209839L;
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ASN1Data(runtime, klass);
            }
        };
        static final int MAX_TAG_VALUE = ASN1.access$300().length;

        public ASN1Data(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject value2, IRubyObject tag, IRubyObject tag_class) {
            this.checkTag(context2.runtime, tag, tag_class, "UNIVERSAL");
            this.callMethod(context2, "tag=", tag);
            this.callMethod(context2, "value=", value2);
            this.callMethod(context2, "tag_class=", tag_class);
            return this;
        }

        private void checkTag(Ruby runtime, IRubyObject tag, IRubyObject tagClass, String expected) {
            if (!(tagClass instanceof RubySymbol)) {
                throw ASN1.newASN1Error(runtime, "invalid tag class");
            }
            if (tagClass.toString().equals(expected) && RubyNumeric.fix2int((IRubyObject)tag) > MAX_TAG_VALUE) {
                throw ASN1.newASN1Error(runtime, "tag number for :" + expected + " too large");
            }
        }

        boolean isEOC() {
            return false;
        }

        boolean isExplicitTagging() {
            return !this.isImplicitTagging();
        }

        boolean isImplicitTagging() {
            return true;
        }

        int getTag(ThreadContext context2) {
            return RubyNumeric.fix2int((IRubyObject)this.callMethod(context2, "tag"));
        }

        ASN1Encodable toASN1(ThreadContext context2) {
            return this.toASN1TaggedObject(context2);
        }

        final ASN1TaggedObject toASN1TaggedObject(ThreadContext context2) {
            int tag = this.getTag(context2);
            IRubyObject val = this.callMethod(context2, "value");
            if (val instanceof RubyArray) {
                RubyArray arr = (RubyArray)val;
                if (arr.size() > 1) {
                    IRubyObject obj;
                    ASN1Encodable data;
                    ASN1EncodableVector vec = new ASN1EncodableVector();
                    IRubyObject[] iRubyObjectArray = arr.toJavaArray();
                    int n = iRubyObjectArray.length;
                    for (int j = 0; j < n && (data = ((ASN1Data)(obj = iRubyObjectArray[j])).toASN1(context2)) != null; ++j) {
                        vec.add(data);
                    }
                    return new DERTaggedObject(this.isExplicitTagging(), tag, (ASN1Encodable)new DERSequence(vec));
                }
                if (arr.size() == 1) {
                    ASN1Encodable data = ((ASN1Data)arr.entry(0)).toASN1(context2);
                    return new DERTaggedObject(this.isExplicitTagging(), tag, data);
                }
                throw new IllegalStateException("empty array detected");
            }
            return new DERTaggedObject(this.isExplicitTagging(), tag, ((ASN1Data)val).toASN1(context2));
        }

        @JRubyMethod
        public IRubyObject to_der(ThreadContext context2) {
            try {
                byte[] encoded = this.toDER(context2);
                return context2.runtime.newString(new ByteList(encoded, false));
            }
            catch (IOException e) {
                throw ASN1.newASN1Error(context2.runtime, e.getMessage());
            }
        }

        byte[] toDER(ThreadContext context2) throws IOException {
            return this.toASN1(context2).toASN1Primitive().getEncoded("DER");
        }

        protected IRubyObject defaultTag() {
            Integer id2 = ASN1.typeId(this.getMetaClass());
            if (id2 == null) {
                return this.getRuntime().getNil();
            }
            return this.getRuntime().newFixnum(id2.intValue());
        }

        final IRubyObject value() {
            return this.value(this.getRuntime().getCurrentContext());
        }

        IRubyObject value(ThreadContext context2) {
            return this.callMethod(context2, "value");
        }

        final String getClassBaseName() {
            return this.getMetaClass().getBaseName();
        }

        public String toString() {
            return this.value().toString();
        }

        protected final void print() {
            this.print(0);
        }

        protected void print(int indent) {
            PrintStream out = this.getRuntime().getOut();
            ASN1Data.printIndent(out, indent);
            IRubyObject value2 = this.value();
            out.println("ASN1Data: ");
            if (value2 instanceof RubyArray) {
                ASN1Data.printArray(out, indent, (RubyArray)value2);
            } else {
                ((ASN1Data)value2).print(indent + 1);
            }
        }

        static void printIndent(PrintStream out, int indent) {
            for (int i2 = 0; i2 < indent; ++i2) {
                out.print(" ");
            }
        }

        static void printArray(PrintStream out, int indent, RubyArray array) {
            for (int i2 = 0; i2 < array.size(); ++i2) {
                ((ASN1Data)array.entry(i2)).print(indent + 1);
            }
        }

        static RaiseException createNativeRaiseException(ThreadContext context2, Throwable e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            return RaiseException.createNativeRaiseException((Ruby)context2.runtime, (Throwable)cause);
        }
    }

    private static class BytesInputStream
    extends ByteArrayInputStream {
        private BytesInputStream(ByteList bytes) {
            super(bytes.unsafeBytes(), bytes.getBegin(), bytes.getRealSize());
        }

        final byte[] bytes() {
            return this.buf;
        }

        final int readCount() {
            return this.pos - this.mark;
        }

        final int position() {
            return this.pos;
        }

        final int offset() {
            return this.mark;
        }
    }

    public static class ObjectId {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(meta=true, rest=true)
        public static IRubyObject register(IRubyObject self, IRubyObject[] args) {
            Ruby runtime = self.getRuntime();
            ASN1ObjectIdentifier derOid = new ASN1ObjectIdentifier(args[0].toString());
            String a1 = args[1].toString();
            String a2 = args[2].toString();
            Class<ASN1> clazz = ASN1.class;
            synchronized (ASN1.class) {
                Map sym2oid = ASN1.getOIDLookup(runtime);
                sym2oid.put(a1.toLowerCase(), derOid);
                sym2oid.put(a2.toLowerCase(), derOid);
                ASN1.getSymLookup(runtime).put(derOid, a1);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return runtime.getTrue();
            }
        }

        @JRubyMethod(name={"sn", "short_name"})
        public static RubyString sn(ThreadContext context2, IRubyObject self) {
            return ObjectId.name(context2, self.callMethod(context2, "value"), false);
        }

        @JRubyMethod(name={"ln", "long_name"})
        public static RubyString ln(ThreadContext context2, IRubyObject self) {
            return ObjectId.name(context2, self.callMethod(context2, "value"), true);
        }

        @JRubyMethod
        public static RubyString oid(ThreadContext context2, IRubyObject self) {
            Ruby runtime = context2.runtime;
            return runtime.newString(ASN1.getObjectID(runtime, self.callMethod(context2, "value").toString()).getId());
        }

        private static RubyString name(ThreadContext context2, IRubyObject value2, boolean longName) {
            Ruby runtime = context2.runtime;
            String oid2 = value2.toString();
            Integer nid = null;
            try {
                nid = ASN1.oid2nid(runtime, ASN1.getObjectID(runtime, oid2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (nid != null) {
                String val;
                String string = val = longName ? ASN1.nid2ln(runtime, nid) : ASN1.nid2sn(runtime, nid);
                if (val != null) {
                    return runtime.newString(val);
                }
            }
            return value2.asString();
        }
    }
}

