/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Optional;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.owl.model.user.Orcid;
import org.protege.editor.owl.model.user.OrcidPreferencesManager;
import org.protege.editor.owl.model.user.UserNamePreferencesManager;
import org.protege.editor.owl.model.user.UserPreferences;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class UserPreferencesPanel
extends OWLPreferencesPanel {
    private final AugmentedJTextField userNameField = new AugmentedJTextField(40, "Enter user name");
    private final AugmentedJTextField orcidField = new AugmentedJTextField(22, "e.g. 0000-0002-1825-0097");
    private final JRadioButton useLoggedInUserNameButton = new JRadioButton("<html><body>Use system logged in user name (<b>" + System.getProperty("user.name") + "</b>)</body></html>");
    private final JRadioButton userSuppliedUserNameButton = new JRadioButton("Use supplied user name:");

    public void initialise() throws Exception {
        this.layoutUserInterface();
        this.updateFromPreferences();
    }

    private void updateFromPreferences() {
        Preferences preferences = UserPreferences.get();
        UserNamePreferencesManager userNameMan = new UserNamePreferencesManager(preferences);
        if (userNameMan.getUserName().isPresent()) {
            this.userSuppliedUserNameButton.setSelected(true);
            this.userNameField.setText(userNameMan.getUserName().get());
        } else {
            this.useLoggedInUserNameButton.setSelected(true);
            this.userNameField.setText("");
            this.userNameField.setEnabled(false);
        }
        OrcidPreferencesManager orcidMan = new OrcidPreferencesManager(preferences);
        if (orcidMan.getOrcid().isPresent()) {
            this.orcidField.setText(orcidMan.getOrcid().get().getValue());
        } else {
            this.orcidField.setText("");
        }
    }

    private void layoutUserInterface() {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        panel.addGroup("User name");
        panel.addGroupComponent((JComponent)this.useLoggedInUserNameButton);
        panel.addGroupComponent((JComponent)this.userSuppliedUserNameButton);
        ButtonGroup userNameButtonGroup = new ButtonGroup();
        userNameButtonGroup.add(this.useLoggedInUserNameButton);
        userNameButtonGroup.add(this.userSuppliedUserNameButton);
        panel.addVerticalPadding();
        panel.addIndentedGroupComponent((JComponent)this.userNameField);
        this.userSuppliedUserNameButton.addActionListener(e -> this.userNameField.setEnabled(true));
        this.useLoggedInUserNameButton.addActionListener(e -> this.userNameField.setEnabled(false));
        panel.addSeparator();
        panel.addGroup("ORCID");
        panel.addGroupComponent((JComponent)this.orcidField);
        this.orcidField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserPreferencesPanel.this.updateOrcidField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserPreferencesPanel.this.updateOrcidField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserPreferencesPanel.this.updateOrcidField();
            }
        });
    }

    private void updateOrcidField() {
        Optional<Orcid> enteredOrcid = this.getEnteredOrcid();
        if (enteredOrcid.isPresent() || this.orcidField.getText().isEmpty()) {
            this.orcidField.clearErrorMessage();
        } else {
            this.orcidField.setErrorMessage("Invalid ORCID");
        }
    }

    public void applyChanges() {
        Preferences preferences = UserPreferences.get();
        UserNamePreferencesManager userNameMan = new UserNamePreferencesManager(preferences);
        if (this.userSuppliedUserNameButton.isSelected() && !this.getEnteredUserName().isEmpty()) {
            userNameMan.setUserName(this.getEnteredUserName());
        } else {
            userNameMan.clearUserName();
        }
        OrcidPreferencesManager orcidMan = new OrcidPreferencesManager(preferences);
        Optional<Orcid> enteredOrcid = this.getEnteredOrcid();
        if (enteredOrcid.isPresent()) {
            orcidMan.setOrcid(enteredOrcid.get());
        } else {
            orcidMan.clearOrcid();
        }
    }

    private Optional<Orcid> getEnteredOrcid() {
        try {
            return Optional.of(new Orcid(this.orcidField.getText().trim()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private String getEnteredUserName() {
        return this.userNameField.getText().trim();
    }

    public void dispose() throws Exception {
    }
}

