// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 *
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 **/
public interface Locator extends com.zeroc.Ice.Object
{
    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param current The Current object for the invocation.
     * @return The proxy, or null if the object is not active.
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     **/
    java.util.concurrent.CompletionStage<com.zeroc.Ice.ObjectPrx> findObjectByIdAsync(Identity id, com.zeroc.Ice.Current current)
        throws ObjectNotFoundException;

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     **/
    java.util.concurrent.CompletionStage<com.zeroc.Ice.ObjectPrx> findAdapterByIdAsync(String id, com.zeroc.Ice.Current current)
        throws AdapterNotFoundException;

    /**
     * Get the locator registry.
     * @param current The Current object for the invocation.
     * @return The locator registry.
     **/
    LocatorRegistryPrx getRegistry(com.zeroc.Ice.Current current);

    static final String[] _iceIds =
    {
        "::Ice::Locator",
        "::Ice::Object"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::Locator";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findObjectById(Locator obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        Identity iceP_id;
        iceP_id = Identity.ice_read(istr);
        inS.endReadParams();
        return inS.setResultFuture(obj.findObjectByIdAsync(iceP_id, current), (ostr, ret) ->
            {
                ostr.writeProxy(ret);
            });
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findAdapterById(Locator obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        return inS.setResultFuture(obj.findAdapterByIdAsync(iceP_id, current), (ostr, ret) ->
            {
                ostr.writeProxy(ret);
            });
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getRegistry(Locator obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        LocatorRegistryPrx ret = obj.getRegistry(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    final static String[] _iceOps =
    {
        "findAdapterById",
        "findObjectById",
        "getRegistry",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_findAdapterById(this, in, current);
            }
            case 1:
            {
                return _iceD_findObjectById(this, in, current);
            }
            case 2:
            {
                return _iceD_getRegistry(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
