/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.criterion.KeyInfoGenerationProfileCriterion;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.impl.AlgorithmRuntimeSupportedPredicate;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEncryptionParametersResolver
extends AbstractSecurityParametersResolver<EncryptionParameters>
implements EncryptionParametersResolver {
    private Logger log = LoggerFactory.getLogger(BasicEncryptionParametersResolver.class);
    private AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
    private boolean autoGenerateDataEncryptionCredential;

    public AlgorithmRegistry getAlgorithmRegistry() {
        if (this.algorithmRegistry == null) {
            return AlgorithmSupport.getGlobalAlgorithmRegistry();
        }
        return this.algorithmRegistry;
    }

    public void setAlgorithmRegistry(@Nonnull AlgorithmRegistry registry) {
        this.algorithmRegistry = (AlgorithmRegistry)Constraint.isNotNull((Object)registry, (String)"AlgorithmRegistry was null");
    }

    public boolean isAutoGenerateDataEncryptionCredential() {
        return this.autoGenerateDataEncryptionCredential;
    }

    public void setAutoGenerateDataEncryptionCredential(boolean flag) {
        this.autoGenerateDataEncryptionCredential = flag;
    }

    @Nonnull
    public Iterable<EncryptionParameters> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        EncryptionParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return Collections.singletonList(params);
        }
        return Collections.emptyList();
    }

    @Nullable
    public EncryptionParameters resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        Constraint.isNotNull((Object)criteria, (String)"CriteriaSet was null");
        Constraint.isNotNull((Object)criteria.get(EncryptionConfigurationCriterion.class), (String)"Resolver requires an instance of EncryptionConfigurationCriterion");
        Predicate<String> whitelistBlacklistPredicate = this.getWhitelistBlacklistPredicate(criteria);
        EncryptionParameters params = new EncryptionParameters();
        this.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
        if (params.getDataEncryptionCredential() != null) {
            params.setDataKeyInfoGenerator(this.resolveDataKeyInfoGenerator(criteria, params.getDataEncryptionCredential()));
        }
        if (params.getKeyTransportEncryptionCredential() != null) {
            params.setKeyTransportKeyInfoGenerator(this.resolveKeyTransportKeyInfoGenerator(criteria, params.getKeyTransportEncryptionCredential()));
        }
        boolean encryptionOptional = false;
        EncryptionOptionalCriterion encryptionOptionalCrit = (EncryptionOptionalCriterion)criteria.get(EncryptionOptionalCriterion.class);
        if (encryptionOptionalCrit != null) {
            encryptionOptional = encryptionOptionalCrit.isEncryptionOptional();
        }
        if (this.validate(params, encryptionOptional)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    protected void logResult(@Nonnull EncryptionParameters params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved EncryptionParameters:");
            Key keyTransportKey = CredentialSupport.extractEncryptionKey((Credential)params.getKeyTransportEncryptionCredential());
            if (keyTransportKey != null) {
                this.log.debug("\tKey transport credential with key algorithm: {}", (Object)keyTransportKey.getAlgorithm());
            } else {
                this.log.debug("\tKey transport credential: null");
            }
            this.log.debug("\tKey transport algorithm URI: {}", (Object)params.getKeyTransportEncryptionAlgorithm());
            if (params.getRSAOAEPParameters() != null) {
                this.log.debug("\t\tKey transport RSA OAEP digest method URI: {}", (Object)params.getRSAOAEPParameters().getDigestMethod());
                this.log.debug("\t\tKey transport RSA OAEP MGF URI: {}", (Object)params.getRSAOAEPParameters().getMaskGenerationFunction());
                this.log.debug("\t\tKey transport RSA OAEP OAEPparams: {}", (Object)params.getRSAOAEPParameters().getOAEPParams());
            }
            this.log.debug("\tKey transport KeyInfoGenerator: {}", (Object)(params.getKeyTransportKeyInfoGenerator() != null ? "present" : "null"));
            Key dataKey = CredentialSupport.extractEncryptionKey((Credential)params.getDataEncryptionCredential());
            if (dataKey != null) {
                this.log.debug("\tData encryption credential with key algorithm: {}", (Object)dataKey.getAlgorithm());
            } else {
                this.log.debug("\tData encryption credential: null");
            }
            this.log.debug("\tData encryption algorithm URI: {}", (Object)params.getDataEncryptionAlgorithm());
            this.log.debug("\tData encryption KeyInfoGenerator: {}", (Object)(params.getDataKeyInfoGenerator() != null ? "present" : "null"));
        }
    }

    protected boolean validate(@Nonnull EncryptionParameters params) {
        return this.validate(params, false);
    }

    protected boolean validate(@Nonnull EncryptionParameters params, boolean encryptionOptional) {
        if (params.getKeyTransportEncryptionCredential() == null && params.getDataEncryptionCredential() == null) {
            String msg = "Validation failure: Failed to resolve both a data and a key encryption credential";
            if (encryptionOptional) {
                this.log.debug(msg);
            } else {
                this.log.warn(msg);
            }
            return false;
        }
        if (params.getKeyTransportEncryptionCredential() != null && params.getKeyTransportEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve key encryption algorithm URI for credential";
            if (encryptionOptional) {
                this.log.debug(msg);
            } else {
                this.log.warn(msg);
            }
            return false;
        }
        if (params.getDataEncryptionCredential() != null && params.getDataEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve data encryption algorithm URI for credential";
            if (encryptionOptional) {
                this.log.debug(msg);
            } else {
                this.log.warn(msg);
            }
            return false;
        }
        if (params.getKeyTransportEncryptionCredential() != null && params.getDataEncryptionCredential() == null && params.getDataEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve a data encryption algorithm URI for auto-generation of data encryption key";
            if (encryptionOptional) {
                this.log.debug(msg);
            } else {
                this.log.warn(msg);
            }
            return false;
        }
        return true;
    }

    @Nonnull
    protected Predicate<String> getWhitelistBlacklistPredicate(@Nonnull CriteriaSet criteria) {
        return this.resolveWhitelistBlacklistPredicate(criteria, ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations());
    }

    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        List<Credential> keyTransportCredentials = this.getEffectiveKeyTransportCredentials(criteria);
        List<String> keyTransportAlgorithms = this.getEffectiveKeyTransportAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective key transport algorithms: {}", keyTransportAlgorithms);
        List<Credential> dataEncryptionCredentials = this.getEffectiveDataEncryptionCredentials(criteria);
        List<String> dataEncryptionAlgorithms = this.getEffectiveDataEncryptionAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective data encryption algorithms: {}", dataEncryptionAlgorithms);
        if (dataEncryptionCredentials.isEmpty()) {
            params.setDataEncryptionAlgorithm(this.resolveDataEncryptionAlgorithm(null, dataEncryptionAlgorithms));
        } else {
            for (Credential dataEncryptionCredential : dataEncryptionCredentials) {
                String dataEncryptionAlgorithm = this.resolveDataEncryptionAlgorithm(dataEncryptionCredential, dataEncryptionAlgorithms);
                if (dataEncryptionAlgorithm != null) {
                    params.setDataEncryptionCredential(dataEncryptionCredential);
                    params.setDataEncryptionAlgorithm(dataEncryptionAlgorithm);
                    break;
                }
                this.log.debug("Unable to resolve data encryption algorithm for credential with key type '{}', considering other credentials", (Object)CredentialSupport.extractEncryptionKey((Credential)dataEncryptionCredential).getAlgorithm());
            }
        }
        KeyTransportAlgorithmPredicate keyTransportPredicate = this.resolveKeyTransportAlgorithmPredicate(criteria);
        for (Credential keyTransportCredential : keyTransportCredentials) {
            String keyTransportAlgorithm = this.resolveKeyTransportAlgorithm(keyTransportCredential, keyTransportAlgorithms, params.getDataEncryptionAlgorithm(), keyTransportPredicate);
            if (keyTransportAlgorithm != null) {
                params.setKeyTransportEncryptionCredential(keyTransportCredential);
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm);
                break;
            }
            this.log.debug("Unable to resolve key transport algorithm for credential with key type '{}', considering other credentials", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
        }
        this.resolveAndPopulateRSAOAEPParams(params, criteria, whitelistBlacklistPredicate);
        this.processDataEncryptionCredentialAutoGeneration(params);
    }

    protected void resolveAndPopulateRSAOAEPParams(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        if (!AlgorithmSupport.isRSAOAEP((String)params.getKeyTransportEncryptionAlgorithm())) {
            return;
        }
        if (params.getRSAOAEPParameters() == null) {
            params.setRSAOAEPParameters(new RSAOAEPParameters());
        }
        this.populateRSAOAEPParams(params.getRSAOAEPParameters(), criteria, whitelistBlacklistPredicate);
    }

    protected void populateRSAOAEPParams(@Nonnull RSAOAEPParameters rsaParams, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        if (rsaParams.isComplete()) {
            return;
        }
        Predicate<String> algoSupportPredicate = this.getAlgorithmRuntimeSupportedPredicate();
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            RSAOAEPParameters rsaConfig = config.getRSAOAEPParameters();
            if (rsaConfig != null) {
                if (rsaParams.getDigestMethod() == null && rsaConfig.getDigestMethod() != null && whitelistBlacklistPredicate.apply((Object)rsaConfig.getDigestMethod()) && algoSupportPredicate.apply((Object)rsaConfig.getDigestMethod())) {
                    rsaParams.setDigestMethod(rsaConfig.getDigestMethod());
                }
                if (rsaParams.getMaskGenerationFunction() == null && rsaConfig.getMaskGenerationFunction() != null && whitelistBlacklistPredicate.apply((Object)rsaConfig.getMaskGenerationFunction())) {
                    rsaParams.setMaskGenerationFunction(rsaConfig.getMaskGenerationFunction());
                }
                if (rsaParams.getOAEPParams() == null && rsaConfig.getOAEPParams() != null) {
                    rsaParams.setOAEPparams(rsaConfig.getOAEPParams());
                }
            }
            if (!rsaParams.isComplete() && config.isRSAOAEPParametersMerge()) continue;
            return;
        }
    }

    @Nullable
    protected KeyTransportAlgorithmPredicate resolveKeyTransportAlgorithmPredicate(@Nonnull CriteriaSet criteria) {
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            if (config.getKeyTransportAlgorithmPredicate() == null) continue;
            return config.getKeyTransportAlgorithmPredicate();
        }
        return null;
    }

    @Nullable
    protected String resolveKeyTransportAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull List<String> keyTransportAlgorithms, @Nullable String dataEncryptionAlgorithm, @Nullable KeyTransportAlgorithmPredicate keyTransportPredicate) {
        if (this.log.isTraceEnabled()) {
            Key key = CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential);
            this.log.trace("Evaluating key transport encryption credential of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
        }
        for (String algorithm : keyTransportAlgorithms) {
            this.log.trace("Evaluating key transport credential against algorithm: {}", (Object)algorithm);
            if (!this.credentialSupportsAlgorithm(keyTransportCredential, algorithm) || !this.isKeyTransportAlgorithm(algorithm)) continue;
            if (keyTransportPredicate != null) {
                if (!keyTransportPredicate.apply((Object)new KeyTransportAlgorithmPredicate.SelectionInput(algorithm, dataEncryptionAlgorithm, keyTransportCredential))) continue;
                return algorithm;
            }
            return algorithm;
        }
        return null;
    }

    @Nullable
    protected String resolveKeyTransportAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate, @Nullable String dataEncryptionAlgorithm) {
        return this.resolveKeyTransportAlgorithm(keyTransportCredential, this.getEffectiveKeyTransportAlgorithms(criteria, whitelistBlacklistPredicate), dataEncryptionAlgorithm, this.resolveKeyTransportAlgorithmPredicate(criteria));
    }

    @Nullable
    protected String resolveDataEncryptionAlgorithm(@Nullable Credential dataEncryptionCredential, @Nonnull List<String> dataEncryptionAlgorithms) {
        if (this.log.isTraceEnabled()) {
            Key key = CredentialSupport.extractEncryptionKey((Credential)dataEncryptionCredential);
            this.log.trace("Evaluating data encryption credential of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
        }
        if (dataEncryptionCredential == null) {
            this.log.trace("Data encryption credential was null, selecting algorithm based on effective algorithms alone");
            if (!dataEncryptionAlgorithms.isEmpty()) {
                return dataEncryptionAlgorithms.get(0);
            }
            return null;
        }
        for (String algorithm : dataEncryptionAlgorithms) {
            this.log.trace("Evaluating data encryption credential against algorithm: {}", (Object)algorithm);
            if (!this.credentialSupportsAlgorithm(dataEncryptionCredential, algorithm) || !this.isDataEncryptionAlgorithm(algorithm)) continue;
            return algorithm;
        }
        return null;
    }

    @Nullable
    protected String resolveDataEncryptionAlgorithm(@Nonnull Credential dataEncryptionCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        return this.resolveDataEncryptionAlgorithm(dataEncryptionCredential, this.getEffectiveDataEncryptionAlgorithms(criteria, whitelistBlacklistPredicate));
    }

    @Nonnull
    protected List<Credential> getEffectiveDataEncryptionCredentials(@Nonnull CriteriaSet criteria) {
        ArrayList<Credential> accumulator = new ArrayList<Credential>();
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            accumulator.addAll(config.getDataEncryptionCredentials());
        }
        return accumulator;
    }

    @Nonnull
    protected List<String> getEffectiveDataEncryptionAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        ArrayList<String> accumulator = new ArrayList<String>();
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            accumulator.addAll(Collections2.filter((Collection)config.getDataEncryptionAlgorithms(), (Predicate)Predicates.and(this.getAlgorithmRuntimeSupportedPredicate(), whitelistBlacklistPredicate)));
        }
        return accumulator;
    }

    @Nonnull
    protected List<Credential> getEffectiveKeyTransportCredentials(@Nonnull CriteriaSet criteria) {
        ArrayList<Credential> accumulator = new ArrayList<Credential>();
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            accumulator.addAll(config.getKeyTransportEncryptionCredentials());
        }
        return accumulator;
    }

    @Nonnull
    protected List<String> getEffectiveKeyTransportAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        ArrayList<String> accumulator = new ArrayList<String>();
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            accumulator.addAll(Collections2.filter((Collection)config.getKeyTransportEncryptionAlgorithms(), (Predicate)Predicates.and(this.getAlgorithmRuntimeSupportedPredicate(), whitelistBlacklistPredicate)));
        }
        return accumulator;
    }

    @Nullable
    protected KeyInfoGenerator resolveDataKeyInfoGenerator(@Nullable CriteriaSet criteria, @Nullable Credential dataEncryptionCredential) {
        if (dataEncryptionCredential == null) {
            return null;
        }
        String name = null;
        if (criteria.get(KeyInfoGenerationProfileCriterion.class) != null) {
            name = ((KeyInfoGenerationProfileCriterion)criteria.get(KeyInfoGenerationProfileCriterion.class)).getName();
        }
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            KeyInfoGenerator kig = this.lookupKeyInfoGenerator(dataEncryptionCredential, config.getDataKeyInfoGeneratorManager(), name);
            if (kig == null) continue;
            return kig;
        }
        return null;
    }

    @Nullable
    protected KeyInfoGenerator resolveKeyTransportKeyInfoGenerator(@Nonnull CriteriaSet criteria, @Nullable Credential keyTransportEncryptionCredential) {
        if (keyTransportEncryptionCredential == null) {
            return null;
        }
        String name = null;
        if (criteria.get(KeyInfoGenerationProfileCriterion.class) != null) {
            name = ((KeyInfoGenerationProfileCriterion)criteria.get(KeyInfoGenerationProfileCriterion.class)).getName();
        }
        for (EncryptionConfiguration config : ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations()) {
            KeyInfoGenerator kig = this.lookupKeyInfoGenerator(keyTransportEncryptionCredential, config.getKeyTransportKeyInfoGeneratorManager(), name);
            if (kig == null) continue;
            return kig;
        }
        return null;
    }

    @Nonnull
    protected Predicate<String> getAlgorithmRuntimeSupportedPredicate() {
        return new AlgorithmRuntimeSupportedPredicate(this.getAlgorithmRegistry());
    }

    protected boolean credentialSupportsAlgorithm(@Nonnull Credential credential, @Nonnull @NotEmpty String algorithm) {
        return AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)this.getAlgorithmRegistry().get(algorithm));
    }

    protected boolean isKeyTransportAlgorithm(@Nonnull String algorithm) {
        return AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)this.getAlgorithmRegistry().get(algorithm));
    }

    protected boolean isDataEncryptionAlgorithm(String algorithm) {
        return AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)this.getAlgorithmRegistry().get(algorithm));
    }

    @Nullable
    protected Credential generateDataEncryptionCredential(@Nonnull String dataEncryptionAlgorithm) {
        try {
            return AlgorithmSupport.generateSymmetricKeyAndCredential((String)dataEncryptionAlgorithm);
        }
        catch (KeyException | NoSuchAlgorithmException e) {
            this.log.warn("Error generating a symmetric key credential using algorithm URI: " + dataEncryptionAlgorithm, (Throwable)e);
            return null;
        }
    }

    protected void processDataEncryptionCredentialAutoGeneration(@Nonnull EncryptionParameters params) {
        if (this.isAutoGenerateDataEncryptionCredential() && params.getKeyTransportEncryptionCredential() != null && params.getDataEncryptionCredential() == null && params.getDataEncryptionAlgorithm() != null) {
            this.log.debug("Auto-generating data encryption credential using algorithm URI: {}", (Object)params.getDataEncryptionAlgorithm());
            params.setDataEncryptionCredential(this.generateDataEncryptionCredential(params.getDataEncryptionAlgorithm()));
        }
    }
}

