/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.sql.JDBCType;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class MetaColumnInfo
implements Writeable,
ToXContentObject {
    private static final ConstructingObjectParser<MetaColumnInfo, Void> PARSER = new ConstructingObjectParser("column_info", true, objects -> new MetaColumnInfo((String)objects[0], (String)objects[1], (String)objects[2], objects[3] == null ? null : JDBCType.valueOf((Integer)objects[3]), objects[4] == null ? 0 : (Integer)objects[4], (Integer)objects[5]));
    private static final ParseField TABLE = new ParseField("table", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField ES_TYPE = new ParseField("type", new String[0]);
    private static final ParseField JDBC_TYPE = new ParseField("jdbc_type", new String[0]);
    private static final ParseField SIZE = new ParseField("size", new String[0]);
    private static final ParseField POSITION = new ParseField("position", new String[0]);
    private final String table;
    private final String name;
    private final String esType;
    @Nullable
    private final JDBCType jdbcType;
    private final int size;
    private final int position;

    public MetaColumnInfo(String table, String name, String esType, JDBCType jdbcType, int size, int position) {
        this.table = table;
        this.name = name;
        this.esType = esType;
        this.jdbcType = jdbcType;
        this.size = size;
        this.position = position;
    }

    public MetaColumnInfo(String table, String name, String esType, int position) {
        this(table, name, esType, null, 0, position);
    }

    MetaColumnInfo(StreamInput in) throws IOException {
        this.table = in.readString();
        this.name = in.readString();
        this.esType = in.readString();
        if (in.readBoolean()) {
            this.jdbcType = JDBCType.valueOf(in.readVInt());
            this.size = in.readVInt();
        } else {
            this.jdbcType = null;
            this.size = 0;
        }
        this.position = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.table);
        out.writeString(this.name);
        out.writeString(this.esType);
        if (this.jdbcType != null) {
            out.writeBoolean(true);
            out.writeVInt(this.jdbcType.getVendorTypeNumber().intValue());
            out.writeVInt(this.size);
        } else {
            out.writeBoolean(false);
        }
        out.writeVInt(this.position);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("table", this.table);
        builder.field("name", this.name);
        builder.field("type", this.esType);
        if (this.jdbcType != null) {
            builder.field("jdbc_type", this.jdbcType.getVendorTypeNumber());
            builder.field("size", this.size);
        }
        builder.field("position", this.position);
        return builder.endObject();
    }

    public static MetaColumnInfo fromXContent(XContentParser parser) {
        return (MetaColumnInfo)PARSER.apply(parser, null);
    }

    public String table() {
        return this.table;
    }

    public String name() {
        return this.name;
    }

    public String esType() {
        return this.esType;
    }

    public JDBCType jdbcType() {
        return this.jdbcType;
    }

    public int size() {
        return this.size;
    }

    public int position() {
        return this.position;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaColumnInfo that = (MetaColumnInfo)o;
        return this.size == that.size && this.position == that.position && Objects.equals(this.table, that.table) && Objects.equals(this.name, that.name) && Objects.equals(this.esType, that.esType) && this.jdbcType == that.jdbcType;
    }

    public int hashCode() {
        return Objects.hash(this.table, this.name, this.esType, this.jdbcType, this.size, this.position);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TABLE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ES_TYPE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), JDBC_TYPE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SIZE);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), POSITION);
    }
}

