/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.NotNullList;
import org.jetbrains.kotlin.gnu.trove.TLongArrayList;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.CachedValueImpl");
    private volatile SoftReference<Data<T>> myData;

    private Data<T> computeData(@Nullable CachedValueProvider.Result<T> result2) {
        Object value = result2 == null ? null : (Object)result2.getValue();
        Object[] dependencies2 = this.getDependencies(result2);
        if (dependencies2 == null) {
            return new Data<Object>(value, null, null);
        }
        TLongArrayList timeStamps = new TLongArrayList(dependencies2.length);
        NotNullList<Object> deps = new NotNullList<Object>(dependencies2.length);
        this.collectDependencies(timeStamps, deps, dependencies2);
        return new Data<Object>(value, ArrayUtil.toObjectArray(deps), timeStamps.toNativeArray());
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.myData = new SoftReference<Data<Data<T>>>(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data) {
        this.myData = new SoftReference<Data<Data<T>>>(data);
    }

    private synchronized boolean compareAndClearData(Data<T> expected) {
        if (this.getRawData() == expected) {
            this.myData = null;
            return true;
        }
        return false;
    }

    @Nullable
    protected Object[] getDependencies(CachedValueProvider.Result<T> result2) {
        return result2 == null ? null : result2.getDependencyItems();
    }

    @Nullable
    protected Object[] getDependenciesPlusValue(CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            return null;
        }
        Object[] items = result2.getDependencyItems();
        T value = result2.getValue();
        return value == null ? items : ArrayUtil.append(items, value);
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull(false) != null;
    }

    @Nullable
    private Data<T> getUpToDateOrNull(boolean dispose) {
        Data<T> data = this.getRawData();
        if (data != null) {
            if (this.isUpToDate(data)) {
                return data;
            }
            if (dispose && ((Data)data).myValue instanceof Disposable && this.compareAndClearData(data)) {
                Disposer.dispose((Disposable)((Data)data).myValue);
            }
        }
        return null;
    }

    @Nullable
    final Data<T> getRawData() {
        return SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data data) {
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        if (data.myTimeStamps == null) {
            return true;
        }
        for (int i = 0; i < data.myDependencies.length; ++i) {
            Object dependency = data.myDependencies[i];
            if (dependency == null || !this.isDependencyOutOfDate(dependency, data.myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private void collectDependencies(TLongArrayList timeStamps, List<Object> resultingDeps, Object[] dependencies2) {
        for (Object dependency : dependencies2) {
            if (dependency == null || dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                this.collectDependencies(timeStamps, resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
            timeStamps.add(this.getTimeStamp(dependency));
        }
    }

    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(CachedValueProvider.Result<T> result2) {
        Data<T> data = this.computeData(result2);
        this.setData(data);
        this.valueUpdated(result2.getDependencyItems());
        return (T)((Data)data).myValue;
    }

    protected void valueUpdated(@Nullable Object[] dependencies2) {
    }

    public abstract boolean isFromMyProject(Project var1);

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data<T> data = this.getUpToDateOrNull(true);
        if (data != null) {
            return (T)((Data)data).myValue;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.createGuard("cachedValue").markStack();
        data = this.computeData(this.doCompute(param));
        if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            while ((toReturn = this.cacheOrGetData(alreadyComputed, (reuse = (alreadyComputed = this.getRawData()) != null && this.isUpToDate(alreadyComputed)) ? null : data)) == null) {
            }
            this.valueUpdated(((Data)toReturn).myDependencies);
            return (T)((Data)toReturn).myValue;
        }
        return (T)((Data)data).myValue;
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/com/intellij/util/CachedValueBase", "isUpToDate"));
    }

    protected static class Data<T>
    implements Disposable {
        private final T myValue;
        private final Object[] myDependencies;
        private final long[] myTimeStamps;

        public Data(T value, Object[] dependencies2, long[] timeStamps) {
            this.myValue = value;
            this.myDependencies = dependencies2;
            this.myTimeStamps = timeStamps;
        }

        @Override
        public void dispose() {
            if (this.myValue instanceof Disposable) {
                Disposer.dispose((Disposable)this.myValue);
            }
        }
    }
}

