/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.util.Arrays;

public class JceBlockCipherWithCBCImplicitIVImpl
implements TlsBlockCipherImpl {
    private final Cipher cipher;
    private final String algorithm;
    private final boolean isEncrypting;
    private SecretKey key;
    private byte[] nextIV;

    public JceBlockCipherWithCBCImplicitIVImpl(Cipher cipher, String string, boolean bl) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = string;
        this.isEncrypting = bl;
    }

    public void setKey(byte[] byArray, int n, int n2) {
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    public void init(byte[] byArray, int n, int n2) {
        if (this.nextIV != null) {
            throw new IllegalStateException("unexpected reinitialization of an implicit-IV cipher");
        }
        this.nextIV = Arrays.copyOfRange((byte[])byArray, (int)n, (int)(n + n2));
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            this.cipher.init(this.isEncrypting ? 1 : 2, (Key)this.key, new IvParameterSpec(this.nextIV));
            this.nextIV = null;
            if (!this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange((byte[])byArray, (int)(n + n2 - this.cipher.getBlockSize()), (int)(n + n2));
            }
            int n4 = this.cipher.doFinal(byArray, n, n2, byArray2, n3);
            if (this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange((byte[])byArray2, (int)(n3 + n2 - this.cipher.getBlockSize()), (int)(n3 + n2));
            }
            return n4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

