#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.2.1
id: pandoc-2.2.1-2zbrEb7RIIU3FKkmnyz8ES
key: pandoc-2.2.1-2zbrEb7RIIU3FKkmnyz8ES
license: GPL-2.0-only
copyright: (c) 2006-2018 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
author: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: https://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, EPUB, FictionBook2, and Textile,
    and it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, JATS, OPML, TEI, OpenDocument,
    ODT, Word docx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    groff man, groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
abi: fb8428839a48da942d4b33e728cd447c
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.FB2
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.Haddock
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.LaTeX.Types Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Filter Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Docx.Fields
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Paths_pandoc
import-dirs: /usr/lib/ghc-8.4.3/site-local/pandoc-2.2.1
library-dirs: /usr/lib/ghc-8.4.3/site-local/pandoc-2.2.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.2.1-2zbrEb7RIIU3FKkmnyz8ES
depends:
    base-4.11.1.0 syb-0.7-2jW43lwzJV5e7EQvU8PxV containers-0.5.11.0
    unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu parsec-3.1.13.0
    mtl-2.2.2 exceptions-0.10.0-391qhPSiPEU3NJgxhfdaPf filepath-1.4.2
    process-1.6.3.0 directory-1.3.1.5 bytestring-0.10.8.2 text-1.2.3.0
    time-1.8.0.2 safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur
    zip-archive-0.3.2.5-8g8dXd62Xwd8ATpM2xwb3j
    HTTP-4000.3.12-6mxoDoPUcloDN1TpRnYqvr
    texmath-0.11.0.1-8ZVGzusJSdbDMEL9F7XLIm
    xml-1.3.14-Iiopw2ucwBuIKdlkbvc4Gm
    split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG
    random-1.1-9LLJAJa4iQFLJiLXBOBXBV
    pandoc-types-1.17.5.1-Boe6haaG3dxFpv19MiwhiO
    aeson-1.3.1.1-ArWpZy1DbZ6Lxt3YgJqPBO
    aeson-pretty-0.8.7-EDoz570Kdle1sORLB3l32T
    tagsoup-0.14.6-7Kjdp42VPmpFTv5v8vSEkC
    base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37
    zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH
    skylighting-0.7.2-JXymca6GWdE3IO4Auyltsa
    data-default-0.7.1.1-6pNGRUfj5nU7unWVd8ajT0
    temporary-1.3-41227bpMgK8Lci8YuU0nJm
    blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG
    blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug
    yaml-0.8.30-H2tq6pr0olyBQhs7fc0ZSU
    scientific-0.3.6.2-KcBBbCjUUZZKnRSUL2OTul
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    hslua-0.9.5.2-Ev2R9AZ6IUJBYbwxnWTv9u
    hslua-module-text-0.1.2.1-II5xZ2o1khDEMUduksFfcw binary-0.8.5.1
    SHA-1.6.4.4-J97i4k52krALB5u9VxmQ73
    haddock-library-1.5.0.1-GdV4wUFTVFeIpTSX9rklyd deepseq-1.4.3.0
    JuicyPixels-3.2.9.5-32b8Pvsx9HAXt4Yu6Ulma
    Glob-0.9.2-5yb38ydyVE42JmysXCdmSi
    cmark-gfm-0.1.3-28OjSF4mAR16RhLrmDcrH7
    doctemplates-0.2.2.1-GfiND3s7FzN9ezpuKf95cD
    http-client-0.5.13-GyLA8HATX9cHiBKliNKWxB
    http-client-tls-0.3.5.3-EfA9ZJY3lxYAntfw9R6ptV
    http-types-0.12.1-9rf2Bc0mANC4pe1MDcYyOl
    case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra unix-2.7.2.2
    network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9
    network-2.7.0.0-AFQUqm7hPUl7GJe3nXsQng
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             syb-0.7-2jW43lwzJV5e7EQvU8PxV=867165047495b4e6f144c8b9b108f918
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu=5b052eced98346d45f3db03378f2841d
             parsec-3.1.13.0=3626e7cedd22de76a8b10339d955721a
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             exceptions-0.10.0-391qhPSiPEU3NJgxhfdaPf=7910067871295cb7f4f6699a852863a6
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             directory-1.3.1.5=f5fa3aef63d61d9b32ef25d211ef137f
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur=42026212d0dad8beaed25fde58365be8
             zip-archive-0.3.2.5-8g8dXd62Xwd8ATpM2xwb3j=e8146d60cde3daac21567d8a76735b54
             HTTP-4000.3.12-6mxoDoPUcloDN1TpRnYqvr=a487ff6c9bb3592f71b6c25f5cf86ab5
             texmath-0.11.0.1-8ZVGzusJSdbDMEL9F7XLIm=2960ede149719fe313891f552593ae93
             xml-1.3.14-Iiopw2ucwBuIKdlkbvc4Gm=447f20f46280d63791817d6b9c8e0eb8
             split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG=cdf77c47c599317cfa01d2d98185c5d3
             random-1.1-9LLJAJa4iQFLJiLXBOBXBV=2cade9e72fa19fe7a43e5ace84505d9f
             pandoc-types-1.17.5.1-Boe6haaG3dxFpv19MiwhiO=05186e18046a2e2dea6dc78e639085f5
             aeson-1.3.1.1-ArWpZy1DbZ6Lxt3YgJqPBO=63ce14baf2a7c28abbc692d9e7dd92cc
             aeson-pretty-0.8.7-EDoz570Kdle1sORLB3l32T=4ef7d9725d6c6d289881ccfa8479d9e3
             tagsoup-0.14.6-7Kjdp42VPmpFTv5v8vSEkC=20f59525319cbc5c261121b478cbf532
             base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37=65adc4f5f54a1c07291b4ebc49756c05
             zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH=8fa648805d93281f19b98bbf203b4b1c
             skylighting-0.7.2-JXymca6GWdE3IO4Auyltsa=83d4b76354464c7a2151378ab77fb389
             data-default-0.7.1.1-6pNGRUfj5nU7unWVd8ajT0=e2403b7ea90422302496191f03ca1dc3
             temporary-1.3-41227bpMgK8Lci8YuU0nJm=aa15bae0626a93f7986aa943afc2ff36
             blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG=c53bb3bf02513bb30eb5ce3eb528e263
             blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug=71b515c6e3bfb99ff0075cc129b1fc3b
             yaml-0.8.30-H2tq6pr0olyBQhs7fc0ZSU=7504598c1eca33ce1599f93c59ed6449
             scientific-0.3.6.2-KcBBbCjUUZZKnRSUL2OTul=67146f6b2fe2f883da537f78817eb0dd
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             hslua-0.9.5.2-Ev2R9AZ6IUJBYbwxnWTv9u=3021272dbab559de833e60d25f0a5b5d
             hslua-module-text-0.1.2.1-II5xZ2o1khDEMUduksFfcw=5f15083698048d223bff61f1685a23e8
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             SHA-1.6.4.4-J97i4k52krALB5u9VxmQ73=7fdfeaf1e3416ffd434c90cf824fb303
             haddock-library-1.5.0.1-GdV4wUFTVFeIpTSX9rklyd=f97b9e137cea93e49b7e6d1ba17d79db
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             JuicyPixels-3.2.9.5-32b8Pvsx9HAXt4Yu6Ulma=08f25432ab0f2edd7f9c9a6839fe5f71
             Glob-0.9.2-5yb38ydyVE42JmysXCdmSi=2e0c28767328ce383047b3d3d84ba8bf
             cmark-gfm-0.1.3-28OjSF4mAR16RhLrmDcrH7=0e690b1d304c9b4105053990835ac3da
             doctemplates-0.2.2.1-GfiND3s7FzN9ezpuKf95cD=bba2c46795da935a563322e7adc8c6c8
             http-client-0.5.13-GyLA8HATX9cHiBKliNKWxB=c70ea065b1fde639c4b7cb3ed9f544b5
             http-client-tls-0.3.5.3-EfA9ZJY3lxYAntfw9R6ptV=71ad80d48ab3f56929ec297177737927
             http-types-0.12.1-9rf2Bc0mANC4pe1MDcYyOl=f077e3c0d9d6c05be2dfc7d9c3ae67ad
             case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra=0a5994e39a32f328ff4f350b25844411
             unix-2.7.2.2=f81aa481840dadf9c364a1cea96978c0
             network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9=4ea8f0efa7a1ade0af4e9ce0cffcff8c
             network-2.7.0.0-AFQUqm7hPUl7GJe3nXsQng=f721cf34b8f5e16aaba2f249d1eefa28
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

