/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.BasicService;
import sun.awt.DesktopBrowse;

public final class BasicServiceImpl
implements BasicService {
    private URL _codebase = null;
    private String _codebaseProtocol = null;
    private boolean _isWebBrowserSupported;
    private static BasicServiceImpl _sharedInstance = null;

    private BasicServiceImpl(URL uRL, boolean bl, String string) {
        this._codebaseProtocol = string;
        this._codebase = uRL;
        this._isWebBrowserSupported = bl;
        if (Config.isJavaVersionAtLeast16()) {
            try {
                DesktopBrowse.setInstance((DesktopBrowse)new BasicServiceBrowser());
            }
            catch (IllegalStateException illegalStateException) {
                if (Config.getDeployDebug()) {
                    illegalStateException.printStackTrace(System.out);
                }
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    public static BasicServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static void initialize(URL uRL, boolean bl, String string) {
        if (_sharedInstance == null) {
            _sharedInstance = new BasicServiceImpl(uRL, bl, string);
        }
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    public boolean isOffline() {
        return DeployOfflineManager.isGlobalOffline();
    }

    private boolean isFileProtocolCodebase() {
        return this._codebaseProtocol != null && this._codebaseProtocol.equalsIgnoreCase("file");
    }

    private boolean isValidURL(URL uRL) {
        LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        URL uRL2 = launchDesc.getMainJarURL();
        return uRL2 == null || URLUtil.checkDocumentURL((URL)uRL2, (URL)uRL);
    }

    public boolean showDocument(URL uRL) {
        DesktopBrowse desktopBrowse;
        if (uRL == null) {
            return false;
        }
        try {
            uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return false;
        }
        if (!URLUtil.checkDocumentURL((URL)this._codebase, (URL)uRL)) {
            return false;
        }
        if (Config.isJavaVersionAtLeast16() && (desktopBrowse = DesktopBrowse.getInstance()) != null && !(desktopBrowse instanceof BasicServiceBrowser)) {
            if (!this.isWebBrowserSupported()) {
                return false;
            }
            try {
                uRL = new URL(this._codebase, uRL.toString());
                if (!Platform.isArgumentOkay((String)uRL.toString())) {
                    return false;
                }
                if (!this.isValidURL(uRL)) {
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            desktopBrowse.browse(uRL);
            return true;
        }
        return this.showDocumentHelper(uRL);
    }

    private boolean showDocumentHelper(final URL uRL) {
        boolean bl = uRL.toString().toLowerCase().endsWith(".jnlp");
        boolean bl2 = ResourceProvider.get().isCached(uRL, null);
        Boolean bl3 = null;
        if ((bl || bl2) && (bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadEngine.isJnlpURL((URL)uRL)) {
                    try {
                        String string;
                        Resource resource = ResourceProvider.get().getResource(uRL, null, false, 1, null);
                        String string2 = string = resource != null ? resource.getResourceFilename() : null;
                        if (string != null && Platform.isArgumentOkay((String)string)) {
                            String[] stringArray = new String[]{Environment.getJavawsCommand(), "-Xnosplash", string};
                            Runtime.getRuntime().exec(stringArray);
                            return new Boolean(true);
                        }
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                }
                return new Boolean(false);
            }
        })) != null && bl3.booleanValue()) {
            return true;
        }
        if (!this.isWebBrowserSupported()) {
            return false;
        }
        try {
            final URL uRL2 = new URL(this._codebase, uRL.toString());
            if (!Platform.isArgumentOkay((String)uRL2.toString())) {
                return new Boolean(false);
            }
            if (!this.isValidURL(uRL2)) {
                return new Boolean(false);
            }
            bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(BrowserSupport.showDocument(uRL2));
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bl3 == null ? false : bl3;
    }

    public boolean isWebBrowserSupported() {
        PerfLogger.setEndTime((String)"BasicService.isWebBrowserSupported called");
        PerfLogger.outputLog();
        return this._isWebBrowserSupported;
    }

    public void logPerfStartMessage(String string) {
        PerfLogger.setStartTime((String)string);
    }

    public void logPerfEndMessage(String string) {
        PerfLogger.setEndTime((String)string);
    }

    public void logPerfTime(String string) {
        PerfLogger.setTime((String)string);
    }

    private class BasicServiceBrowser
    extends DesktopBrowse {
        private BasicServiceBrowser() {
        }

        public void browse(URL uRL) {
            BasicServiceImpl.this.showDocument(uRL);
        }
    }
}

