/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.NodeComponent;
import javax.vecmath.Color3f;

public class Material
extends NodeComponent {
    public static final int ALLOW_COMPONENT_READ = 0;
    public static final int ALLOW_COMPONENT_WRITE = 1;
    public static final int AMBIENT = 0;
    public static final int EMISSIVE = 1;
    public static final int DIFFUSE = 2;
    public static final int SPECULAR = 3;
    public static final int AMBIENT_AND_DIFFUSE = 4;
    private static final int[] readCapabilities = new int[]{0};

    public Material() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Material(Color3f color3f, Color3f color3f2, Color3f color3f3, Color3f color3f4, float f) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((MaterialRetained)this.retained).createMaterial(color3f, color3f2, color3f3, color3f4, f);
    }

    void createRetained() {
        this.retained = new MaterialRetained();
        this.retained.setSource(this);
    }

    public void setAmbientColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setAmbientColor(color3f);
        } else {
            ((MaterialRetained)this.retained).initAmbientColor(color3f);
        }
    }

    public void setAmbientColor(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setAmbientColor(f, f2, f3);
        } else {
            ((MaterialRetained)this.retained).initAmbientColor(f, f2, f3);
        }
    }

    public void getAmbientColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getAmbientColor(color3f);
    }

    public void setEmissiveColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setEmissiveColor(color3f);
        } else {
            ((MaterialRetained)this.retained).initEmissiveColor(color3f);
        }
    }

    public void setEmissiveColor(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setEmissiveColor(f, f2, f3);
        } else {
            ((MaterialRetained)this.retained).initEmissiveColor(f, f2, f3);
        }
    }

    public void getEmissiveColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getEmissiveColor(color3f);
    }

    public void setDiffuseColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setDiffuseColor(color3f);
        } else {
            ((MaterialRetained)this.retained).initDiffuseColor(color3f);
        }
    }

    public void setDiffuseColor(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setDiffuseColor(f, f2, f3);
        } else {
            ((MaterialRetained)this.retained).initDiffuseColor(f, f2, f3);
        }
    }

    public void setDiffuseColor(float f, float f2, float f3, float f4) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setDiffuseColor(f, f2, f3, f4);
        } else {
            ((MaterialRetained)this.retained).initDiffuseColor(f, f2, f3, f4);
        }
    }

    public void getDiffuseColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getDiffuseColor(color3f);
    }

    public void setSpecularColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setSpecularColor(color3f);
        } else {
            ((MaterialRetained)this.retained).initSpecularColor(color3f);
        }
    }

    public void setSpecularColor(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setSpecularColor(f, f2, f3);
        } else {
            ((MaterialRetained)this.retained).initSpecularColor(f, f2, f3);
        }
    }

    public void getSpecularColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        ((MaterialRetained)this.retained).getSpecularColor(color3f);
    }

    public void setShininess(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material0"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setShininess(f);
        } else {
            ((MaterialRetained)this.retained).initShininess(f);
        }
    }

    public float getShininess() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material2"));
        }
        return ((MaterialRetained)this.retained).getShininess();
    }

    public void setLightingEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material15"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setLightingEnable(bl);
        } else {
            ((MaterialRetained)this.retained).initLightingEnable(bl);
        }
    }

    public boolean getLightingEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material16"));
        }
        return ((MaterialRetained)this.retained).getLightingEnable();
    }

    public void setColorTarget(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material3"));
        }
        if (this.isLive()) {
            ((MaterialRetained)this.retained).setColorTarget(n);
        } else {
            ((MaterialRetained)this.retained).initColorTarget(n);
        }
    }

    public int getColorTarget() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Material4"));
        }
        return ((MaterialRetained)this.retained).getColorTarget();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getNamePrefix());
        stringBuffer.append("javax.media.j3d.Material: ");
        Color3f color3f = new Color3f();
        try {
            this.getAmbientColor(color3f);
            stringBuffer.append("AmbientColor=" + color3f);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append("AmbientColor=N/A");
        }
        try {
            this.getEmissiveColor(color3f);
            stringBuffer.append(" EmissiveColor=" + color3f);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append(" EmissiveColor=N/A");
        }
        try {
            this.getDiffuseColor(color3f);
            stringBuffer.append(" DiffuseColor=" + color3f);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append(" DiffuseColor=N/A");
        }
        try {
            this.getSpecularColor(color3f);
            stringBuffer.append(" SpecularColor=" + color3f);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append(" SpecularColor=N/A");
        }
        try {
            float f = this.getShininess();
            stringBuffer.append(" Shininess=" + f);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append(" Shininess=N/A");
        }
        try {
            boolean bl = this.getLightingEnable();
            stringBuffer.append(" LightingEnable=" + bl);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append(" LightingEnable=N/A");
        }
        try {
            int n = this.getColorTarget();
            stringBuffer.append(" ColorTarget=" + n);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append(" ColorTarget=N/A");
        }
        return new String(stringBuffer);
    }

    public NodeComponent cloneNodeComponent() {
        Material material = new Material();
        material.duplicateNodeComponent(this);
        return material;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        MaterialRetained materialRetained = (MaterialRetained)nodeComponent.retained;
        MaterialRetained materialRetained2 = (MaterialRetained)this.retained;
        Color3f color3f = new Color3f();
        materialRetained.getAmbientColor(color3f);
        materialRetained2.initAmbientColor(color3f);
        materialRetained.getEmissiveColor(color3f);
        materialRetained2.initEmissiveColor(color3f);
        materialRetained.getDiffuseColor(color3f);
        materialRetained2.initDiffuseColor(color3f);
        materialRetained.getSpecularColor(color3f);
        materialRetained2.initSpecularColor(color3f);
        materialRetained2.initShininess(materialRetained.getShininess());
        materialRetained2.initLightingEnable(materialRetained.getLightingEnable());
        materialRetained2.initColorTarget(materialRetained.getColorTarget());
    }
}

