/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EnumResolver<T extends Enum<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<T> _enumClass;
    protected final T[] _enums;
    protected final HashMap<String, T> _enumsById;

    protected EnumResolver(Class<T> enumClass, T[] enums, HashMap<String, T> map2) {
        this._enumClass = enumClass;
        this._enums = enums;
        this._enumsById = map2;
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructFor(Class<ET> enumCls, AnnotationIntrospector ai) {
        Enum[] enumValues = (Enum[])enumCls.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        HashMap<String, Enum> map2 = new HashMap<String, Enum>();
        for (Enum e2 : enumValues) {
            map2.put(ai.findEnumValue(e2), e2);
        }
        return new EnumResolver(enumCls, enumValues, map2);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingToString(Class<ET> enumCls) {
        Enum[] enumValues = (Enum[])enumCls.getEnumConstants();
        HashMap<String, Enum> map2 = new HashMap<String, Enum>();
        int i = enumValues.length;
        while (--i >= 0) {
            Enum e2 = enumValues[i];
            map2.put(e2.toString(), e2);
        }
        return new EnumResolver(enumCls, enumValues, map2);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingMethod(Class<ET> enumCls, Method accessor2) {
        Enum[] enumValues = (Enum[])enumCls.getEnumConstants();
        HashMap<String, Enum> map2 = new HashMap<String, Enum>();
        int i = enumValues.length;
        while (--i >= 0) {
            Enum en = enumValues[i];
            try {
                Object o = accessor2.invoke((Object)en, new Object[0]);
                if (o == null) continue;
                map2.put(o.toString(), en);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + en + ": " + e2.getMessage());
            }
        }
        return new EnumResolver(enumCls, enumValues, map2);
    }

    public static EnumResolver<?> constructUnsafe(Class<?> rawEnumCls, AnnotationIntrospector ai) {
        Class<?> enumCls = rawEnumCls;
        return EnumResolver.constructFor(enumCls, ai);
    }

    public static EnumResolver<?> constructUnsafeUsingToString(Class<?> rawEnumCls) {
        Class<?> enumCls = rawEnumCls;
        return EnumResolver.constructUsingToString(enumCls);
    }

    public static EnumResolver<?> constructUnsafeUsingMethod(Class<?> rawEnumCls, Method accessor2) {
        Class<?> enumCls = rawEnumCls;
        return EnumResolver.constructUsingMethod(enumCls, accessor2);
    }

    public T findEnum(String key2) {
        return (T)((Enum)this._enumsById.get(key2));
    }

    public T getEnum(int index2) {
        if (index2 < 0 || index2 >= this._enums.length) {
            return null;
        }
        return this._enums[index2];
    }

    public List<T> getEnums() {
        ArrayList<T> enums = new ArrayList<T>(this._enums.length);
        for (T e2 : this._enums) {
            enums.add(e2);
        }
        return enums;
    }

    public Class<T> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

