/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.MathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinitions;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.UnaryProcessorDefinition;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class MathFunction
extends UnaryScalarFunction {
    protected MathFunction(Location location) {
        super(location);
    }

    protected MathFunction(Location location, Expression field) {
        super(location, field);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    @Override
    protected String formatScript(String template) {
        return super.formatScript(String.format(Locale.ROOT, "Math.%s(%s)", this.mathFunction(), template));
    }

    protected String mathFunction() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children", new Object[0]);
        }
        return this.field().dataType().isNumeric() ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution("'%s' requires a numeric type, received %s", new Object[]{this.operation(), this.field().dataType().esType});
    }

    @Override
    protected final ProcessorDefinition makeProcessorDefinition() {
        return new UnaryProcessorDefinition(this.location(), this, ProcessorDefinitions.toProcessorDefinition(this.field()), new MathProcessor(this.operation()));
    }

    protected abstract MathProcessor.MathOperation operation();

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MathFunction other = (MathFunction)obj;
        return Objects.equals(other.field(), this.field());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field());
    }
}

