/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.webhook;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.actions.webhook.WebhookAction;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.support.Variables;

public class ExecutableWebhookAction
extends ExecutableAction<WebhookAction> {
    private final HttpClient httpClient;
    private final TextTemplateEngine templateEngine;

    public ExecutableWebhookAction(WebhookAction action, Logger logger, HttpClient httpClient, TextTemplateEngine templateEngine) {
        super((Action)action, logger);
        this.httpClient = httpClient;
        this.templateEngine = templateEngine;
    }

    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        HttpRequest request = ((WebhookAction)this.action).requestTemplate.render(this.templateEngine, model);
        if (ctx.simulateAction(actionId)) {
            return new WebhookAction.Result.Simulated(request);
        }
        HttpResponse response = this.httpClient.execute(request);
        if (response.status() >= 400) {
            return new WebhookAction.Result.Failure(request, response);
        }
        return new WebhookAction.Result.Success(request, response);
    }
}

