/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.pki;

import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.pki.PkiRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.CertUtils;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.security.authc.BytesKey;
import org.elasticsearch.xpack.security.authc.pki.X509AuthenticationToken;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.CompositeRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class PkiRealm
extends Realm
implements CachingRealm {
    public static final String PKI_CERT_HEADER_NAME = "__SECURITY_CLIENT_CERTIFICATE";
    private static final String AUTH_TYPE = "UNKNOWN";
    private final ReleasableLock readLock;
    private final ReleasableLock writeLock;
    private final X509TrustManager trustManager;
    private final Pattern principalPattern;
    private final UserRoleMapper roleMapper;
    private final Cache<BytesKey, User> cache;

    public PkiRealm(RealmConfig config, ResourceWatcherService watcherService, NativeRoleMappingStore nativeRoleMappingStore) {
        this(config, new CompositeRoleMapper("pki", config, watcherService, nativeRoleMappingStore));
    }

    PkiRealm(RealmConfig config, UserRoleMapper roleMapper) {
        super("pki", config);
        ReentrantReadWriteLock iterationLock = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(iterationLock.readLock());
        this.writeLock = new ReleasableLock(iterationLock.writeLock());
        this.trustManager = PkiRealm.trustManagers(config);
        this.principalPattern = (Pattern)PkiRealmSettings.USERNAME_PATTERN_SETTING.get(config.settings());
        this.roleMapper = roleMapper;
        this.cache = CacheBuilder.builder().setExpireAfterWrite((TimeValue)PkiRealmSettings.CACHE_TTL_SETTING.get(config.settings())).setMaximumWeight((long)((Integer)PkiRealmSettings.CACHE_MAX_USERS_SETTING.get(config.settings())).intValue()).build();
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof X509AuthenticationToken;
    }

    public X509AuthenticationToken token(ThreadContext context) {
        return PkiRealm.token(context.getTransient(PKI_CERT_HEADER_NAME), this.principalPattern, this.logger);
    }

    public void authenticate(AuthenticationToken authToken, ActionListener<AuthenticationResult> listener) {
        X509AuthenticationToken token = (X509AuthenticationToken)authToken;
        try {
            BytesKey fingerprint = PkiRealm.computeFingerprint(token.credentials()[0]);
            User user = (User)this.cache.get((Object)fingerprint);
            if (user != null) {
                listener.onResponse((Object)AuthenticationResult.success((User)user));
            } else if (!PkiRealm.isCertificateChainTrusted(this.trustManager, token, this.logger)) {
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Certificate for " + token.dn() + " is not trusted"), null));
            } else {
                Map<String, Object> metadata = Collections.singletonMap("pki_dn", token.dn());
                UserRoleMapper.UserData userData = new UserRoleMapper.UserData(token.principal(), token.dn(), Collections.emptySet(), metadata, this.config);
                this.roleMapper.resolveRoles(userData, (ActionListener<Set<String>>)ActionListener.wrap(roles -> {
                    User computedUser = new User(token.principal(), roles.toArray(new String[roles.size()]), null, null, metadata, true);
                    ReleasableLock ignored = this.readLock.acquire();
                    Throwable throwable = null;
                    try {
                        this.cache.put((Object)fingerprint, (Object)computedUser);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored != null) {
                            PkiRealm.$closeResource(throwable, (AutoCloseable)ignored);
                        }
                    }
                    listener.onResponse((Object)AuthenticationResult.success((User)computedUser));
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        }
        catch (CertificateEncodingException e) {
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Certificate for " + token.dn() + " has encoding issues"), (Exception)e));
        }
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        listener.onResponse(null);
    }

    static X509AuthenticationToken token(Object pkiHeaderValue, Pattern principalPattern, Logger logger) {
        if (pkiHeaderValue == null) {
            return null;
        }
        assert (pkiHeaderValue instanceof X509Certificate[]);
        X509Certificate[] certificates = (X509Certificate[])pkiHeaderValue;
        if (certificates.length == 0) {
            return null;
        }
        String dn = certificates[0].getSubjectX500Principal().toString();
        Matcher matcher = principalPattern.matcher(dn);
        if (!matcher.find()) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but could not extract principal from DN", (Object)dn);
            }
            return null;
        }
        String principal = matcher.group(1);
        if (Strings.isNullOrEmpty((String)principal)) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but extracted principal was empty", (Object)dn);
            }
            return null;
        }
        return new X509AuthenticationToken(certificates, principal, dn);
    }

    static boolean isCertificateChainTrusted(X509TrustManager trustManager, X509AuthenticationToken token, Logger logger) {
        if (trustManager != null) {
            try {
                trustManager.checkClientTrusted(token.credentials(), AUTH_TYPE);
                return true;
            }
            catch (CertificateException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace(() -> new ParameterizedMessage("failed certificate validation for principal [{}]", (Object)token.principal()), (Throwable)e);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("failed certificate validation for principal [{}]", (Object)token.principal());
                }
                return false;
            }
        }
        return true;
    }

    static X509TrustManager trustManagers(RealmConfig realmConfig) {
        Settings settings = realmConfig.settings();
        Environment env = realmConfig.env();
        List certificateAuthorities = settings.getAsList(PkiRealmSettings.SSL_SETTINGS.caPaths.getKey(), null);
        String truststorePath = ((Optional)PkiRealmSettings.SSL_SETTINGS.truststorePath.get(settings)).orElse(null);
        if (truststorePath == null && certificateAuthorities == null) {
            return null;
        }
        if (truststorePath != null && certificateAuthorities != null) {
            String pathKey = RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting)PkiRealmSettings.SSL_SETTINGS.truststorePath);
            String caKey = RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting)PkiRealmSettings.SSL_SETTINGS.caPaths);
            throw new IllegalArgumentException("[" + pathKey + "] and [" + caKey + "] cannot be used at the same time");
        }
        if (truststorePath != null) {
            return PkiRealm.trustManagersFromTruststore(truststorePath, realmConfig);
        }
        return PkiRealm.trustManagersFromCAs(settings, env);
    }

    private static X509TrustManager trustManagersFromTruststore(String truststorePath, RealmConfig realmConfig) {
        Settings settings = realmConfig.settings();
        if (!PkiRealmSettings.SSL_SETTINGS.truststorePassword.exists(settings) && !PkiRealmSettings.SSL_SETTINGS.legacyTruststorePassword.exists(settings)) {
            throw new IllegalArgumentException("Neither [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting)PkiRealmSettings.SSL_SETTINGS.truststorePassword) + "] or [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting)PkiRealmSettings.SSL_SETTINGS.legacyTruststorePassword) + "] is configured");
        }
        Throwable throwable = null;
        try (SecureString password = (SecureString)PkiRealmSettings.SSL_SETTINGS.truststorePassword.get(settings);){
            String trustStoreAlgorithm = (String)PkiRealmSettings.SSL_SETTINGS.truststoreAlgorithm.get(settings);
            String trustStoreType = SSLConfigurationSettings.getKeyStoreType((Setting)PkiRealmSettings.SSL_SETTINGS.truststoreType, (Settings)settings, (String)truststorePath);
            try {
                X509ExtendedTrustManager x509ExtendedTrustManager = CertUtils.trustManager((String)truststorePath, (String)trustStoreType, (char[])password.getChars(), (String)trustStoreAlgorithm, (Environment)realmConfig.env());
                return x509ExtendedTrustManager;
            }
            catch (Exception e) {
                try {
                    throw new IllegalArgumentException("failed to load specified truststore", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static X509TrustManager trustManagersFromCAs(Settings settings, Environment env) {
        List certificateAuthorities = settings.getAsList(PkiRealmSettings.SSL_SETTINGS.caPaths.getKey(), null);
        assert (certificateAuthorities != null);
        try {
            Certificate[] certificates = CertUtils.readCertificates((List)certificateAuthorities, (Environment)env);
            return CertUtils.trustManager((Certificate[])certificates);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load certificate authorities for PKI realm", (Throwable)e, new Object[0]);
        }
    }

    public void expire(String username) {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            Iterator userIterator = this.cache.values().iterator();
            while (userIterator.hasNext()) {
                if (!((User)userIterator.next()).principal().equals(username)) continue;
                userIterator.remove();
            }
        }
    }

    public void expireAll() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.cache.invalidateAll();
        }
    }

    private static BytesKey computeFingerprint(X509Certificate certificate) throws CertificateEncodingException {
        MessageDigest digest = MessageDigests.sha256();
        digest.update(certificate.getEncoded());
        return new BytesKey(digest.digest());
    }
}

